/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_379;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5224;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.mixin.client.GuiGraphicsAccessor;
import org.joml.Matrix4f;

public final class TESClientUtil {
    public static final class_2960 SPRITES_ATLAS = class_2960.method_60656((String)"textures/atlas/gui.png");
    public static final class_2960 ENTITY_ICON_FRAME = TESConstants.id("entity_icon_frame");
    public static final class_2960 BAR_EMPTY = TESConstants.id("bar/empty");
    public static final class_2960 BAR_OVERLAY_SEGMENTS = TESConstants.id("bar/overlay_segments");
    public static final class_2960 ENTITY_TYPE_AQUATIC = TESConstants.id("entity_type/aquatic");
    public static final class_2960 ENTITY_TYPE_ARTHROPOD = TESConstants.id("entity_type/arthropod");
    public static final class_2960 ENTITY_TYPE_ILLAGER = TESConstants.id("entity_type/illager");
    public static final class_2960 ENTITY_TYPE_UNDEAD = TESConstants.id("entity_type/undead");
    public static final class_2960 PROPERTY_FIRE_IMMUNE = TESConstants.id("property/fire_immune");
    public static final class_2960 PROPERTY_MELEE = TESConstants.id("property/melee");
    public static final class_2960 PROPERTY_RANGED = TESConstants.id("property/ranged");
    public static final class_2960 PROPERTY_STORAGE = TESConstants.id("property/storage");
    public static final class_2960 STAT_ARMOUR = TESConstants.id("stat/armour");
    public static final class_2960 STAT_TOUGHNESS = TESConstants.id("stat/toughness");
    public static final class_2960 STAT_MELEE_DAMAGE = TESConstants.id("stat/melee_damage");

    @Deprecated(forRemoval=true)
    public static void renderCenteredText(class_332 guiGraphics, String text, float x, float y, int colour) {
        TESClientUtil.renderCenteredText(guiGraphics, (class_2561)class_2561.method_43470((String)text), x, y, colour);
    }

    @Deprecated(forRemoval=true)
    public static void renderCenteredText(class_332 guiGraphics, class_2561 text, float x, float y, int colour) {
        TESClientUtil.drawText(guiGraphics, class_310.method_1551().field_1772, text, x - (float)class_310.method_1551().field_1772.method_27525((class_5348)text) / 2.0f, y + 4.0f, colour);
    }

    public static void centerTextForRender(class_2561 text, float x, float y, BiConsumer<Float, Float> renderRunnable) {
        Float f = Float.valueOf(x - (float)class_310.method_1551().field_1772.method_27525((class_5348)text) / 2.0f);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        renderRunnable.accept(f, Float.valueOf(y + (float)(9 - 1) / 2.0f));
    }

    public static void positionFacingCamera(class_4587 poseStack) {
        poseStack.method_22907(class_310.method_1551().field_1773.method_19418().method_23767());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
    }

    public static void prepRenderForTexture(class_2960 texture) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void constructBarRender(class_332 guiGraphics, int x, int y, int width, class_1058 sprite, float percentComplete, boolean withBarOverlay, float opacity) {
        int percentPixels = Math.round(percentComplete * (float)width);
        int midBarWidth = width - 10;
        RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
        TESClientUtil.drawSprite(guiGraphics, sprite, x, y, Math.min(5, percentPixels), 5, 0, 0, Math.min(5, percentPixels), 5, 182, 5);
        if (percentPixels > 5) {
            if (midBarWidth > 0) {
                TESClientUtil.drawSprite(guiGraphics, sprite, x + 5, y, Math.min(midBarWidth, percentPixels - 5), 5, 5, 0, Math.min(midBarWidth, percentPixels - 5), 5, 182, 5);
            }
            if (percentPixels > width - 5) {
                TESClientUtil.drawSprite(guiGraphics, sprite, x + 5 + midBarWidth, y, Math.min(5, percentPixels - 5), 5, 177, 0, Math.min(5, percentPixels - 5), 5, 182, 5);
            }
        }
        if (withBarOverlay && width > 10) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * opacity));
            class_1058 overlaySprite = TESClientUtil.getAtlasSprite(BAR_OVERLAY_SEGMENTS);
            RenderSystem.setShaderTexture((int)0, (class_2960)overlaySprite.method_45852());
            TESClientUtil.drawSprite(guiGraphics, overlaySprite, x, y, width, 5, 0, 0, 182, 5, 182, 5);
        }
    }

    public static void renderEntityIcon(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity, boolean includeFrame) {
        float scale = 0.04f * (float)Math.pow(Math.min(30.0f / entity.method_17681(), 40.0f / entity.method_17682()), 0.95f);
        class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
        boolean scissor = TESConstants.CONFIG.hudPreventEntityOverflow();
        if (scissor) {
            guiGraphics.method_44379(2, 2, 36, 47);
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        if (includeFrame) {
            TESClientUtil.prepRenderForTexture(SPRITES_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f * opacity));
            TESClientUtil.drawSprite(guiGraphics, TESClientUtil.getAtlasSprite(ENTITY_ICON_FRAME), 2, 2, 34, 45, 0, 0, 34, 45, 34, 45);
            poseStack.method_46416(20.0f, 25.0f, 0.0f);
            poseStack.method_22905(-20.0f, -20.0f, 20.0f);
        }
        poseStack.method_22905(scale, scale, scale);
        poseStack.method_46416(0.0f, entity.method_17682() * -0.5f, entity.method_17681());
        float yBodyRotPrev = entity.field_6283;
        float yRotPrev = entity.method_36454();
        float xRotPrev = entity.method_36455();
        float yHeadRotOldPrev = entity.field_6259;
        float yHeadRotPrev = entity.field_6241;
        int hurtTicks = entity.field_6235;
        float attackTimePrev = entity.field_6251;
        float attackTimeOldPrev = entity.field_6229;
        float partialTick = deltaTracker.method_60637(!entity.method_37908().method_54719().method_54746((class_1297)entity));
        entity.method_36456(22.5f);
        entity.method_36457(0.0f);
        entity.field_6283 = 22.5f;
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        entity.field_6235 = TESAPI.getConfig().hudEntityDamageOverlay() ? entity.field_6235 : 0;
        entity.field_6251 = 0.0f;
        entity.field_6229 = 0.0f;
        class_308.method_34742();
        RenderSystem.runAsFancy(() -> TESClientUtil.renderEntityRaw(poseStack, entity, partialTick, 0.0f, 0xF000F0, (class_4597)bufferSource));
        bufferSource.method_22993();
        class_308.method_24211();
        entity.method_36456(yRotPrev);
        entity.method_36457(xRotPrev);
        entity.field_6283 = yBodyRotPrev;
        entity.field_6241 = yHeadRotPrev;
        entity.field_6259 = yHeadRotOldPrev;
        entity.field_6235 = hurtTicks;
        entity.field_6251 = attackTimePrev;
        entity.field_6229 = attackTimeOldPrev;
        poseStack.method_22909();
        if (scissor) {
            guiGraphics.method_44380();
        }
    }

    public static <T extends class_1297> void renderEntityRaw(class_4587 poseStack, T entity, float partialTick, float rotYaw, int packedLight, class_4597 bufferSource) {
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953(entity);
        try {
            class_243 renderOffset = entityRenderer.method_23169(entity, partialTick);
            poseStack.method_22903();
            poseStack.method_22904(renderOffset.field_1352, renderOffset.field_1351, renderOffset.field_1350);
            entityRenderer.method_3936(entity, rotYaw, 1.0f, poseStack, bufferSource, packedLight);
            poseStack.method_22909();
        }
        catch (Exception ex) {
            class_128 wrappedReport = class_128.method_560((Throwable)ex, (String)"Rendering entity in world");
            class_129 entityReportCategory = wrappedReport.method_562("Entity being rendered");
            entity.method_5819(entityReportCategory);
            class_129 rendererReportCategory = wrappedReport.method_562("Renderer details");
            rendererReportCategory.method_578("Assigned renderer", (Object)entityRenderer);
            throw new class_148(wrappedReport);
        }
    }

    public static void drawSimpleTexture(class_332 guiGraphics, int posX, int posY, int width, int height, float u, float v, int pngSize) {
        TESClientUtil.drawSimpleTexture(guiGraphics, posX, posY, width, height, u, v, pngSize, pngSize);
    }

    public static void drawSimpleTexture(class_332 guiGraphics, int posX, int posY, int width, int height, float u, float v, int pngWidth, int pngHeight) {
        TESClientUtil.drawSimpleTexture(guiGraphics, posX, posY, width, height, u, v, width, height, pngWidth, pngHeight);
    }

    public static void drawSimpleTexture(class_332 guiGraphics, int posX, int posY, int width, int height, float u, float v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        Matrix4f pose = guiGraphics.method_51448().method_23760().method_23761();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        float widthRatio = 1.0f / (float)pngWidth;
        float heightRatio = 1.0f / (float)pngHeight;
        RenderSystem.enableBlend();
        buffer.method_22918(pose, (float)posX, (float)posY, 0.0f).method_22913(u * widthRatio, v * heightRatio);
        buffer.method_22918(pose, (float)posX, (float)posY + (float)height, 0.0f).method_22913(u * widthRatio, (v + (float)vHeight) * heightRatio);
        buffer.method_22918(pose, (float)posX + (float)width, (float)posY + (float)height, 0.0f).method_22913((u + (float)uWidth) * widthRatio, (v + (float)vHeight) * heightRatio);
        buffer.method_22918(pose, (float)posX + (float)width, (float)posY, 0.0f).method_22913((u + (float)uWidth) * widthRatio, v * heightRatio);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void drawSprite(class_332 guiGraphics, class_1058 sprite, int posX, int posY, int width, int height, int u, int v, int uWidth, int vHeight, int pngWidth, int pngHeight) {
        Matrix4f pose = guiGraphics.method_51448().method_23760().method_23761();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        float uMin = sprite.method_4580((float)u / (float)pngWidth);
        float uMax = sprite.method_4580((float)(u + uWidth) / (float)pngWidth);
        float vMin = sprite.method_4570((float)v / (float)pngHeight);
        float vMax = sprite.method_4570((float)(v + vHeight) / (float)pngHeight);
        RenderSystem.enableBlend();
        buffer.method_22918(pose, (float)posX, (float)posY, 0.0f).method_22913(uMin, vMin);
        buffer.method_22918(pose, (float)posX, (float)posY + (float)height, 0.0f).method_22913(uMin, vMax);
        buffer.method_22918(pose, (float)posX + (float)width, (float)posY + (float)height, 0.0f).method_22913(uMax, vMax);
        buffer.method_22918(pose, (float)posX + (float)width, (float)posY, 0.0f).method_22913(uMax, vMin);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void drawText(class_332 guiGraphics, class_327 font, String text, float x, float y, int colour) {
        TESClientUtil.drawText(guiGraphics, font, (class_2561)class_2561.method_43470((String)text), x, y, colour);
    }

    public static void drawText(class_332 guiGraphics, class_327 font, class_2561 text, float x, float y, int colour) {
        TESClientUtil.renderDefaultStyleText(font, guiGraphics.method_51448().method_23760().method_23761(), text.method_30937(), x, y, colour, TextRenderType.NORMAL.getOutlineColour(colour), 0xF000F0, guiGraphics.method_51450());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderDefaultStyleText(class_327 fontRenderer, Matrix4f pose, class_5481 text, float x, float y, int colour, int outlineColour, int packedLight, class_4597.class_4598 bufferSource) {
        fontRenderer.method_22942(text, x, y, colour, false, pose, (class_4597)bufferSource, class_327.class_6415.field_33993, outlineColour, packedLight);
    }

    public static void drawTextWithShadow(class_332 guiGraphics, class_327 font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithShadow(guiGraphics, font, (class_2561)class_2561.method_43470((String)text), x, y, colour);
    }

    public static void drawTextWithShadow(class_332 guiGraphics, class_327 font, class_2561 text, float x, float y, int colour) {
        TESClientUtil.renderDropShadowStyleText(font, guiGraphics.method_51448().method_23760().method_23761(), text.method_30937(), x, y, colour, TextRenderType.DROP_SHADOW.getOutlineColour(colour), 0xF000F0, guiGraphics.method_51450());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderDropShadowStyleText(class_327 fontRenderer, Matrix4f pose, class_5481 text, float x, float y, int colour, int outlineColour, int packedLight, class_4597.class_4598 bufferSource) {
        int borderColour = (outlineColour & 0xFC000000) == 0 ? outlineColour | 0xFF000000 : outlineColour;
        class_327 class_3272 = fontRenderer;
        Objects.requireNonNull(class_3272);
        class_327.class_5232 outlineOutput = new class_327.class_5232(class_3272, (class_4597)bufferSource, 0.0f, 0.0f, borderColour, false, pose, class_327.class_6415.field_33993, packedLight);
        float[] newX = new float[]{x};
        text.accept((currentPosition, style, codePoint) -> {
            class_379 glyphInfo = fontRenderer.method_27526(style.method_27708()).method_2011(codePoint, fontRenderer.field_39925);
            outlineOutput.field_24250 = newX[0] + glyphInfo.method_16800();
            outlineOutput.field_24251 = y + glyphInfo.method_16800();
            newX[0] = newX[0] + glyphInfo.method_16798(style.method_10984());
            return outlineOutput.accept(currentPosition, style.method_36139(borderColour), codePoint);
        });
        class_327 class_3273 = fontRenderer;
        Objects.requireNonNull(class_3273);
        class_327.class_5232 output = new class_327.class_5232(class_3273, (class_4597)bufferSource, x, y, (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour, false, pose, class_327.class_6415.field_33995, packedLight);
        text.accept((class_5224)output);
        output.method_27531(0, x);
    }

    public static void drawTextWithGlow(class_332 guiGraphics, class_327 font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithGlow(guiGraphics, font, (class_2561)class_2561.method_43470((String)text), x, y, colour);
    }

    public static void drawTextWithGlow(class_332 guiGraphics, class_327 font, class_2561 text, float x, float y, int colour) {
        TESClientUtil.renderGlowingStyleText(font, guiGraphics.method_51448().method_23760().method_23761(), text.method_30937(), x, y, colour, TextRenderType.GLOWING.getOutlineColour(colour), 0xF000F0, guiGraphics.method_51450());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderGlowingStyleText(class_327 fontRenderer, Matrix4f pose, class_5481 text, float x, float y, int colour, int outlineColour, int packedLight, class_4597.class_4598 bufferSource) {
        fontRenderer.method_37296(text, x, y, colour, outlineColour, pose, (class_4597)bufferSource, packedLight);
    }

    public static void drawTextWithOutline(class_332 guiGraphics, class_327 font, String text, float x, float y, int colour) {
        TESClientUtil.drawTextWithOutline(guiGraphics, font, (class_2561)class_2561.method_43470((String)text), x, y, colour);
    }

    public static void drawTextWithOutline(class_332 guiGraphics, class_327 font, class_2561 text, float x, float y, int colour) {
        TESClientUtil.renderOutlineStyleText(font, guiGraphics.method_51448().method_23760().method_23761(), text.method_30937(), x, y, colour, TextRenderType.OUTLINED.getOutlineColour(colour), 0xF000F0, guiGraphics.method_51450());
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }

    public static void renderOutlineStyleText(class_327 fontRenderer, Matrix4f pose, class_5481 text, float x, float y, int colour, int outlineColour, int packedLight, class_4597.class_4598 bufferSource) {
        int borderColour = (outlineColour & 0xFC000000) == 0 ? outlineColour | 0xFF000000 : outlineColour;
        class_327 class_3272 = fontRenderer;
        Objects.requireNonNull(class_3272);
        class_327.class_5232 outlineOutput = new class_327.class_5232(class_3272, (class_4597)bufferSource, 0.0f, 0.0f, borderColour, false, pose, class_327.class_6415.field_33993, packedLight);
        for (float deltaX = -1.0f; deltaX <= 1.0f; deltaX += 1.0f) {
            for (float deltaY = -1.0f; deltaY <= 1.0f; deltaY += 1.0f) {
                if (!(deltaX == 0.0f ^ deltaY == 0.0f)) continue;
                float[] newX = new float[]{x};
                float offsetX = deltaX;
                float offsetY = deltaY;
                text.accept((currentPosition, style, codePoint) -> {
                    class_379 glyphInfo = fontRenderer.method_27526(style.method_27708()).method_2011(codePoint, fontRenderer.field_39925);
                    outlineOutput.field_24250 = newX[0] + offsetX * glyphInfo.method_16800() * 0.6f;
                    outlineOutput.field_24251 = y + offsetY * glyphInfo.method_16800() * 0.6f;
                    newX[0] = newX[0] + glyphInfo.method_16798(style.method_10984());
                    return outlineOutput.accept(currentPosition, style.method_36139(borderColour), codePoint);
                });
            }
        }
        class_327 class_3273 = fontRenderer;
        Objects.requireNonNull(class_3273);
        class_327.class_5232 output = new class_327.class_5232(class_3273, (class_4597)bufferSource, x, y, (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour, false, pose, class_327.class_6415.field_33995, packedLight);
        text.accept((class_5224)output);
        output.method_27531(0, x);
    }

    public static void drawColouredSquare(class_332 guiGraphics, int posX, int posY, int width, int height, int colour) {
        guiGraphics.method_25294(posX, posY, posX + width, posY + height, colour);
    }

    public static String translateKey(String key, Object ... args) {
        return class_1074.method_4662((String)key, (Object[])args);
    }

    public static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    public static class_243 getCameraPosition() {
        return class_310.method_1551().field_1773.method_19418().method_19326();
    }

    public static class_243 getClosestEntityPosition(class_1297 entity) {
        class_243 cameraPos = TESClientUtil.getCameraPosition();
        class_243 angle = TESClientUtil.getClientPlayer().method_5720();
        return entity.method_5829().method_992(cameraPos, cameraPos.method_1019(angle.method_1021(500.0))).orElseGet(() -> new class_243((double)(class_3532.method_15362((float)((float)angle.field_1352)) * entity.method_17681() * 0.5f), class_3532.method_15350((double)cameraPos.field_1351, (double)entity.method_23318(), (double)entity.method_23323(1.0)), (double)(class_3532.method_15374((float)((float)angle.field_1350)) * entity.method_17681() * 0.5f)));
    }

    public static class_332 createInlineGuiGraphics(class_4587 poseStack, class_4597.class_4598 bufferSource) {
        class_332 guiGraphics = new class_332(class_310.method_1551(), bufferSource);
        guiGraphics.method_51448().method_34425(poseStack.method_23760().method_23761());
        return guiGraphics;
    }

    public static class_1058 getAtlasSprite(class_2960 texture) {
        return class_310.method_1551().method_52699().method_18667(texture);
    }

    public static int multiplyARGBColour(int colour, float multiplier) {
        return class_5253.class_5254.method_27764((int)(colour >>> 24), (int)(class_3532.method_15375((float)((float)(colour >> 16 & 0xFF) * multiplier)) & 0xFF), (int)(class_3532.method_15375((float)((float)(colour >> 8 & 0xFF) * multiplier)) & 0xFF), (int)(class_3532.method_15375((float)((float)(colour & 0xFF) * multiplier)) & 0xFF));
    }

    public static enum TextRenderType {
        NORMAL(TESClientUtil::renderDefaultStyleText, colour -> 0),
        DROP_SHADOW(TESClientUtil::renderDropShadowStyleText, colour -> TESClientUtil.multiplyARGBColour(colour, 0.25f)),
        GLOWING(TESClientUtil::renderGlowingStyleText, colour -> TESClientUtil.multiplyARGBColour(colour, 0.25f)),
        OUTLINED(TESClientUtil::renderOutlineStyleText, colour -> 0);

        private final StyledTextRenderer style;
        private final Int2IntFunction outlineColourGenerator;

        private TextRenderType(StyledTextRenderer style, Int2IntFunction outlineColourGenerator) {
            this.style = style;
            this.outlineColourGenerator = outlineColourGenerator;
        }

        public void render(class_327 fontRenderer, class_4587 poseStack, class_2561 component, float x, float y, int colour, class_4597.class_4598 bufferSource) {
            this.render(fontRenderer, poseStack.method_23760().method_23761(), component.method_30937(), x, y, colour, this.outlineColourGenerator.applyAsInt(colour), 0xF000F0, bufferSource);
        }

        public void render(class_327 fontRenderer, Matrix4f pose, class_5481 text, float x, float y, int colour, int outlineColour, int packedLight, class_4597.class_4598 bufferSource) {
            this.style.render(fontRenderer, pose, text, x, y, colour, outlineColour, packedLight, bufferSource);
        }

        public int getOutlineColour(int colour) {
            return this.outlineColourGenerator.applyAsInt(colour);
        }
    }

    @FunctionalInterface
    public static interface StyledTextRenderer {
        public void render(class_327 var1, Matrix4f var2, class_5481 var3, float var4, float var5, int var6, int var7, int var8, class_4597.class_4598 var9);
    }
}

