/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1492;
import net.minecraft.class_1496;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.minecraft.class_9779;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESEntityType;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.hud.element.TESHudEntityIcon;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public final class BuiltinHudElements {
    public static int renderEntityName(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity, boolean inWorldHud) {
        Objects.requireNonNull(mc.field_1772);
        int lineHeight = 9;
        if (inWorldHud) {
            if (!(TESAPI.getConfig().inWorldHudEntityName() || TESAPI.getConfig().inWorldHudNameOverride() && entity.method_16914())) {
                return 0;
            }
            TESClientUtil.centerTextForRender(entity.method_5476(), 0.0f, 0.0f, (x, y) -> TESAPI.getConfig().inWorldHudEntityNameFontStyle().render(mc.field_1772, guiGraphics.method_51448(), entity.method_5476(), x.floatValue(), y.floatValue(), class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.method_51450()));
            if (TESAPI.getConfig().inWorldHudEntityNamespace()) {
                TESClientUtil.centerTextForRender((class_2561)class_2561.method_43470((String)("(" + class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836() + ")")), 0.0f, lineHeight, (x, y) -> TESAPI.getConfig().inWorldHudEntityNameFontStyle().render(mc.field_1772, guiGraphics.method_51448(), entity.method_5476(), x.floatValue(), y.floatValue(), class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)200, (int)200, (int)200), guiGraphics.method_51450()));
                Objects.requireNonNull(mc.field_1772);
                lineHeight += 9;
            }
        } else {
            if (!TESAPI.getConfig().hudEntityName()) {
                return 0;
            }
            TESAPI.getConfig().hudEntityNameFontStyle().render(mc.field_1772, guiGraphics.method_51448(), entity.method_5476(), 0.0f, 0.0f, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255), guiGraphics.method_51450());
            if (TESAPI.getConfig().hudEntityNamespace()) {
                TESAPI.getConfig().hudEntityNameFontStyle().render(mc.field_1772, guiGraphics.method_51448(), (class_2561)class_2561.method_43470((String)("(" + class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836() + ")")), 0.0f, lineHeight, class_5253.class_5254.method_27764((int)255, (int)200, (int)200, (int)200), guiGraphics.method_51450());
                Objects.requireNonNull(mc.field_1772);
                lineHeight += 9;
            }
        }
        TESEntityTracking.markNameRendered(entity);
        guiGraphics.method_51450().method_37104();
        return lineHeight;
    }

    public static int renderEntityHealth(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity, boolean inWorldHud) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null) {
            return 0;
        }
        TESConfig config = TESAPI.getConfig();
        int barWidth = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        TESHud.BarRenderType renderType = inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, inWorldHud ? 4.0f : 1.0f, 0.0f);
        if (inWorldHud) {
            poseStack.method_46416((float)barWidth * -0.5f, 0.0f, 0.0f);
            poseStack.method_22905(1.0f, 1.0f, -1.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        RenderSystem.enableDepthTest();
        if (renderType != TESHud.BarRenderType.NUMERIC) {
            float percentHealth = entityState.getHealth() / entity.method_6063();
            float percentTransitionHealth = entityState.getLastTransitionHealth() / entity.method_6063();
            boolean doSegments = inWorldHud ? config.inWorldBarsSegments() : config.hudHealthBarSegments();
            TESEntityType entityType = TESConstants.UTILS.getEntityType(entity);
            class_1058 backgroundSprite = TESClientUtil.getAtlasSprite(entityType.backgroundTexture());
            class_1058 progressSprite = TESClientUtil.getAtlasSprite(entityType.overlayTexture());
            class_1058 emptyBarSprite = TESClientUtil.getAtlasSprite(TESClientUtil.BAR_EMPTY);
            TESClientUtil.prepRenderForTexture(backgroundSprite.method_45852());
            TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, emptyBarSprite, 1.0f, false, opacity);
            poseStack.method_46416(0.0f, 0.0f, 0.001f);
            if (percentTransitionHealth > percentHealth) {
                TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, backgroundSprite, entityState.getLastTransitionHealth() / entity.method_6063(), false, opacity);
            }
            poseStack.method_46416(0.0f, 0.0f, 0.001f);
            RenderSystem.enableBlend();
            TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, progressSprite, percentHealth, doSegments, opacity);
        }
        if (renderType != TESHud.BarRenderType.BAR && renderType != TESHud.BarRenderType.BAR_ICONS) {
            String healthText = TESUtil.roundToDecimal(entityState.getHealth(), 1) + "/" + TESUtil.roundToDecimal(entity.method_6063(), 1);
            float halfTextWidth = (float)mc.field_1772.method_1727(healthText) / 2.0f;
            float center = (float)barWidth / 2.0f;
            RenderSystem.setShader(class_757::method_34540);
            poseStack.method_46416(0.0f, 0.0f, 0.001f);
            TESClientUtil.drawColouredSquare(guiGraphics, (int)(center - halfTextWidth - 1.0f), -2, (int)(halfTextWidth * 2.0f) + 1, 9, 0x90909 | (int)(opacity * 255.0f * TESAPI.getConfig().hudBarFontBackingOpacity()) << 24);
            poseStack.method_46416(0.0f, 0.0f, 0.005f);
            (inWorldHud ? TESAPI.getConfig().inWorldHudHealthFontStyle() : TESAPI.getConfig().hudHealthFontStyle()).render(mc.field_1772, guiGraphics.method_51448(), (class_2561)class_2561.method_43470((String)healthText), center - halfTextWidth, -1.0f, class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.method_51450());
        }
        poseStack.method_22909();
        Objects.requireNonNull(mc.field_1772);
        return 9;
    }

    public static int renderEntityArmour(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudArmour() : !TESAPI.getConfig().hudArmour()) {
            return 0;
        }
        int armour = TESUtil.getArmour(entity);
        float toughness = TESUtil.getArmourToughness(entity);
        float meleeDamage = TESUtil.getMeleeDamage(entity);
        float health = TESUtil.getHealth(entity);
        int hearts = health <= 0.0f ? 0 : Math.max(1, class_3532.method_15375((float)(health / 2.0f)));
        int textColour = class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255);
        class_5250 armourString = armour > 0 ? class_2561.method_43470((String)("x" + armour)) : null;
        class_5250 toughnessString = toughness > 0.0f ? class_2561.method_43470((String)("x" + TESUtil.roundToDecimal(toughness, 1))) : null;
        class_5250 meleeDamageString = meleeDamage > 0.0f ? class_2561.method_43470((String)("x" + TESUtil.roundToDecimal(meleeDamage, 1))) : null;
        class_5250 heartsString = (inWorldHud ? TESAPI.getConfig().inWorldBarsRenderType() : TESAPI.getConfig().hudHealthRenderType()) == TESHud.BarRenderType.BAR_ICONS ? class_2561.method_43470((String)("x" + hearts)) : null;
        int armourX = 0;
        int toughnessX = armourX + (armourString == null ? 0 : 11 + mc.field_1772.method_27525((class_5348)armourString));
        int meleeDamageX = toughnessX + (toughnessString == null ? 0 : 11 + mc.field_1772.method_27525((class_5348)toughnessString));
        int healthX = meleeDamageX + (meleeDamageString == null ? 0 : 11 + mc.field_1772.method_27525((class_5348)meleeDamageString));
        class_4587 poseStack = guiGraphics.method_51448();
        class_1058 armourSprite = TESClientUtil.getAtlasSprite(TESClientUtil.STAT_ARMOUR);
        class_1058 toughnessSprite = TESClientUtil.getAtlasSprite(TESClientUtil.STAT_TOUGHNESS);
        class_1058 meleeDamageSprite = TESClientUtil.getAtlasSprite(TESClientUtil.STAT_MELEE_DAMAGE);
        if (healthX == 0 && heartsString == null) {
            return 0;
        }
        poseStack.method_22903();
        if (inWorldHud) {
            poseStack.method_46416((float)(healthX + (heartsString == null ? 0 : mc.field_1772.method_27525((class_5348)heartsString)) + 2) * -0.5f, 0.0f, 0.0f);
        }
        TESClientUtil.prepRenderForTexture(armourSprite.method_45852());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        if (armour > 0) {
            TESClientUtil.drawSprite(guiGraphics, armourSprite, armourX, 0, 9, 9, 0, 0, 9, 9, 9, 9);
        }
        if (toughness > 0.0f) {
            TESClientUtil.drawSprite(guiGraphics, toughnessSprite, toughnessX, 0, 9, 9, 0, 0, 9, 9, 9, 9);
        }
        if (meleeDamage > 0.0f) {
            TESClientUtil.drawSprite(guiGraphics, meleeDamageSprite, meleeDamageX, 0, 9, 9, 0, 0, 9, 9, 9, 9);
        }
        if (heartsString != null) {
            TESClientUtil.drawSprite(guiGraphics, TESClientUtil.getAtlasSprite(class_2960.method_60656((String)"hud/heart/container")), healthX, 0, 9, 9, 0, 0, 9, 9, 9, 9);
            TESClientUtil.drawSprite(guiGraphics, TESClientUtil.getAtlasSprite(class_2960.method_60656((String)"hud/heart/full")), healthX, 0, 9, 9, 0, 0, 9, 9, 9, 9);
        }
        if (armour > 0) {
            (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.field_1772, guiGraphics.method_51448(), (class_2561)armourString, armourX + 10, 1.0f, textColour, guiGraphics.method_51450());
        }
        if (toughness > 0.0f) {
            (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.field_1772, guiGraphics.method_51448(), (class_2561)toughnessString, toughnessX + 10, 1.0f, textColour, guiGraphics.method_51450());
        }
        if (meleeDamage > 0.0f) {
            (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.field_1772, guiGraphics.method_51448(), (class_2561)meleeDamageString, meleeDamageX + 10, 1.0f, textColour, guiGraphics.method_51450());
        }
        if (heartsString != null) {
            (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.field_1772, guiGraphics.method_51448(), (class_2561)heartsString, healthX + 10, 1.0f, textColour, guiGraphics.method_51450());
        }
        poseStack.method_22909();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Objects.requireNonNull(mc.field_1772);
        return 9;
    }

    public static int renderEntityIcons(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudEntityIcons() : !TESAPI.getConfig().hudEntityIcons()) {
            return 0;
        }
        int x = 0;
        TESClientUtil.prepRenderForTexture(TESClientUtil.SPRITES_ATLAS);
        for (TESHudEntityIcon icon : TESHud.getEntityIcons()) {
            if (!icon.renderIfApplicable(guiGraphics, entity, x, 0)) continue;
            x += 9;
        }
        return x == 0 ? 0 : 8;
    }

    public static int renderEntityEffects(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudPotionIcons() : !TESAPI.getConfig().hudPotionIcons()) {
            return 0;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || entityState.getEffects().isEmpty()) {
            return 0;
        }
        int effectsSize = entityState.getEffects().size();
        class_4074 textureManager = mc.method_18505();
        int barLength = inWorldHud ? TESAPI.getConfig().inWorldBarsLength() : TESAPI.getConfig().hudHealthBarLength();
        float maxX = (float)barLength * 2.0f;
        int iconsPerRow = (int)Math.floor(maxX / 18.0f);
        int rows = (int)Math.ceil((float)effectsSize / (float)iconsPerRow);
        int x = inWorldHud ? Math.min(effectsSize, iconsPerRow) * -9 : 0;
        int y = 0;
        int i = 0;
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        poseStack.method_22905(0.5f, 0.5f, 1.0f);
        if (inWorldHud) {
            poseStack.method_22904(0.0, Math.floor((float)(effectsSize * 18) / maxX) * -18.0, 0.0);
        }
        for (class_6880<class_1291> effect : entityState.getEffects()) {
            class_1058 sprite = textureManager.method_18663(effect);
            RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
            guiGraphics.method_25298(i * 18 + x, y, 0, 18, 18, sprite);
            if (++i < iconsPerRow) continue;
            i = 0;
            if (!inWorldHud || (y += 18) / 18 != rows - 1) continue;
            x = effectsSize % iconsPerRow % iconsPerRow * -9;
        }
        RenderSystem.disableBlend();
        poseStack.method_22909();
        return (int)Math.ceil((float)effectsSize / (float)iconsPerRow) * 9;
    }

    public static int renderHorseStats(class_332 guiGraphics, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity, boolean inWorldHud) {
        class_1492 chestedHorse;
        boolean hasChest;
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudHorseStats() : !TESAPI.getConfig().hudHorseStats()) {
            return 0;
        }
        if (!(entity instanceof class_1496)) {
            return 0;
        }
        class_1496 horse = (class_1496)entity;
        boolean bl = hasChest = entity instanceof class_1492 && (chestedHorse = (class_1492)entity).method_6703();
        int x = inWorldHud ? (hasChest ? -18 : -11) : 1;
        guiGraphics.method_51433(mc.field_1772, "H", x, 1, class_3532.method_60599((float)class_3532.method_15363((float)(0.35f * ((float)horse.method_45326(class_5134.field_23716) - class_1496.field_42645) / (class_1496.field_42646 - class_1496.field_42645)), (float)0.0f, (float)0.35f), (float)1.0f, (float)1.0f, (int)255), false);
        guiGraphics.method_51433(mc.field_1772, "S", x + 8, 1, class_3532.method_60599((float)class_3532.method_15363((float)(0.35f * ((float)horse.method_45326(class_5134.field_23719) - class_1496.field_42641) / (class_1496.field_42642 - class_1496.field_42641)), (float)0.0f, (float)0.35f), (float)1.0f, (float)1.0f, (int)255), false);
        guiGraphics.method_51433(mc.field_1772, "J", x + 16, 1, class_3532.method_60599((float)class_3532.method_15363((float)(0.35f * ((float)horse.method_45326(class_5134.field_23728) - class_1496.field_42643) / (class_1496.field_42644 - class_1496.field_42643)), (float)0.0f, (float)0.35f), (float)1.0f, (float)1.0f, (int)255), false);
        if (hasChest) {
            TESClientUtil.prepRenderForTexture(TESClientUtil.SPRITES_ATLAS);
            TESClientUtil.drawSprite(guiGraphics, TESClientUtil.getAtlasSprite(TESClientUtil.PROPERTY_STORAGE), x + 24, 1, 8, 8, 0, 0, 36, 36, 36, 36);
        }
        return 9;
    }
}

