/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.TESParticleClaimant;
import net.tslat.tes.core.particle.TESParticleSourceHandler;
import net.tslat.tes.core.state.EntityState;

public final class TESParticleManager {
    private static final ConcurrentLinkedQueue<TESParticle<?>> PARTICLES = new ConcurrentLinkedQueue();
    private static final Object2ObjectOpenHashMap<class_2960, TESParticleClaimant> CLAIMANTS = new Object2ObjectOpenHashMap();
    private static final ConcurrentMap<Integer, List<Pair<class_2960, Optional<class_2487>>>> CLAIMS = new ConcurrentHashMap<Integer, List<Pair<class_2960, Optional<class_2487>>>>();
    private static final ObjectArrayList<TESParticleSourceHandler> HANDLERS = new ObjectArrayList();
    private static final ObjectArrayList<Runnable> NEW_CLAIMS = new ObjectArrayList();

    public static void addParticle(TESParticle<?> particle) {
        if (!TESAPI.getConfig().particlesEnabled()) {
            return;
        }
        PARTICLES.add(particle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerParticleClaimant(class_2960 id, TESParticleClaimant claimant) {
        Object2ObjectOpenHashMap<class_2960, TESParticleClaimant> object2ObjectOpenHashMap = CLAIMANTS;
        synchronized (object2ObjectOpenHashMap) {
            CLAIMANTS.put((Object)id, (Object)claimant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerParticleSourceHandler(TESParticleSourceHandler handler) {
        ObjectArrayList<TESParticleSourceHandler> objectArrayList = HANDLERS;
        synchronized (objectArrayList) {
            HANDLERS.add((Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParticleClaim(int entityId, class_2960 claimantId, Optional<class_2487> data) {
        if (!TESAPI.getConfig().particlesEnabled()) {
            return;
        }
        ObjectArrayList<Runnable> objectArrayList = NEW_CLAIMS;
        synchronized (objectArrayList) {
            NEW_CLAIMS.add(() -> CLAIMS.computeIfAbsent(entityId, key -> new ObjectArrayList()).add(Pair.of((Object)claimantId, (Object)data)));
        }
    }

    public static float handleParticleClaims(EntityState entityState, float healthDelta, Consumer<TESParticle<?>> particleAdder, boolean checkSourceHandlers) {
        Pair pair;
        ObjectListIterator objectListIterator = CLAIMS.getOrDefault(entityState.getEntity().method_5628(), List.of()).iterator();
        while (objectListIterator.hasNext() && (healthDelta = ((TESParticleClaimant)CLAIMANTS.getOrDefault((pair = (Pair)objectListIterator.next()).getFirst(), (state, delta, data, adder) -> delta)).checkClaim(entityState, healthDelta, (Optional)pair.getSecond(), particleAdder)) != 0.0f) {
        }
        if (checkSourceHandlers && healthDelta < 0.0f) {
            for (TESParticleSourceHandler handler : HANDLERS) {
                if (!handler.checkIncomingDamage(entityState, -healthDelta, entityState.getEntity().method_6081(), particleAdder)) continue;
                healthDelta = 0.0f;
                break;
            }
        }
        return healthDelta;
    }

    public static void tick() {
        class_310 mc = class_310.method_1551();
        if (!mc.method_1493() && mc.field_1687 != null && !mc.field_1687.method_54719().method_54754()) {
            if (!TESAPI.getConfig().particlesEnabled()) {
                PARTICLES.clear();
                CLAIMS.clear();
                return;
            }
            PARTICLES.forEach((Consumer<TESParticle<?>>)((Consumer<TESParticle>)particle -> particle.tick(mc)));
            PARTICLES.removeIf(particle -> !particle.isValid());
        }
    }

    public static void clearClaims() {
        CLAIMS.clear();
        NEW_CLAIMS.forEach(Runnable::run);
        NEW_CLAIMS.clear();
    }

    public static void render(class_332 guiGraphics, class_9779 deltaTracker) {
        class_310 mc = class_310.method_1551();
        class_327 fontRenderer = mc.field_1772;
        float partialTick = deltaTracker.method_60637(false);
        PARTICLES.forEach((Consumer<TESParticle<?>>)((Consumer<TESParticle>)particle -> particle.render(guiGraphics, mc, fontRenderer, partialTick)));
    }
}

