/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle.type;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.mixin.client.GuiGraphicsAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TextParticle
extends GenericTESParticle<String> {
    protected String text;
    protected int colour = -1;

    public TextParticle(@Nullable EntityState entityState, Vector3f position, String text) {
        this(entityState, position, TESParticle.Animation.POP_OFF, text);
    }

    public TextParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, String text) {
        this(entityState, position, animation, text, TESConstants.CONFIG.defaultParticleLifespan());
    }

    public TextParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, String text, int lifespan) {
        super(entityState, position, animation, lifespan);
        this.updateData(text);
    }

    public TextParticle withColour(int colour) {
        this.colour = colour;
        return this;
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void updateData(String data) {
        this.text = data;
    }

    @Override
    public void render(class_332 guiGraphics, class_310 mc, class_327 fontRenderer, float partialTick) {
        this.defaultedTextRender(mc, guiGraphics.method_51448(), this.prevPos, this.pos, partialTick, () -> TESAPI.getConfig().particleFontStyle().render(fontRenderer, guiGraphics.method_51448(), (class_2561)class_2561.method_43470((String)this.text), (float)(-fontRenderer.method_27525((class_5348)class_2561.method_43470((String)this.text))) / 2.0f, 4.0f, this.getColour(), guiGraphics.method_51450()));
        ((GuiGraphicsAccessor)guiGraphics).callFlushIfUnmanaged();
    }
}

