/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESParticle;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.particle.type.ComponentParticle;
import net.tslat.tes.core.particle.type.DamageParticle;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.particle.type.HealParticle;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class EntityState {
    protected final WeakReference<class_1309> entity;
    protected Set<class_6880<class_1291>> effects;
    protected float currentHealth;
    protected float lastHealth;
    protected float lastTransitionHealth;
    protected long lastTransitionTime;
    protected WeakReference<class_1282> lastDamageSource;
    protected int lastRenderTick;

    public EntityState(class_1309 entity) {
        this.entity = new WeakReference<class_1309>(entity);
        this.lastHealth = this.currentHealth = entity.method_6032();
        this.lastRenderTick = entity.field_6012;
        if (TESConstants.CONFIG.isSyncingEffects()) {
            TESConstants.NETWORKING.requestEffectsSync(entity.method_5628());
        }
    }

    @Nullable
    public class_1309 getEntity() {
        return (class_1309)this.entity.get();
    }

    public float getHealth() {
        return this.currentHealth;
    }

    public float getLastHealth() {
        return this.lastHealth;
    }

    public float getLastTransitionHealth() {
        return this.lastTransitionHealth;
    }

    public float getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public Set<class_6880<class_1291>> getEffects() {
        return this.effects == null ? Set.of() : this.effects;
    }

    public void modifyEffects(Set<class_6880<class_1291>> ids, Set<class_6880<class_1291>> idsToRemove) {
        if (this.effects == null) {
            this.effects = new ObjectOpenHashSet(ids);
        } else {
            this.effects.addAll(ids);
        }
        this.effects.removeAll(idsToRemove);
    }

    public void markActive() {
        this.lastRenderTick = this.getEntity().field_6012;
    }

    public boolean isValid() {
        class_1309 entity = this.getEntity();
        return entity != null && !entity.method_31481() && entity.method_37908() == class_310.method_1551().field_1687 && (this.lastRenderTick < 0 || this.lastRenderTick >= entity.field_6012 - 200);
    }

    public void tick() {
        class_1309 entity = this.getEntity();
        if (entity == null) {
            return;
        }
        this.currentHealth = Math.min(entity.method_6032(), entity.method_6063());
        if (this.currentHealth != this.lastHealth && entity.field_6012 > 2) {
            this.handleHealthChange();
            this.lastDamageSource = new WeakReference<class_1282>(entity.method_6081());
        }
        this.lastHealth = this.currentHealth;
        if (entity.method_37908().method_8510() - this.lastTransitionTime > 20L) {
            if (this.lastTransitionHealth > this.currentHealth) {
                this.lastTransitionHealth -= this.getEntity().method_6063() / 30.0f;
            } else {
                this.lastTransitionTime = 0L;
                this.lastTransitionHealth = this.currentHealth;
            }
        }
    }

    protected void handleHealthChange() {
        class_1309 entity = this.getEntity();
        if (entity != null && TESAPI.getConfig().particlesEnabled()) {
            GenericTESParticle particle;
            boolean damageSourceAccurate;
            float healthDelta = this.currentHealth - this.lastHealth;
            boolean bl = damageSourceAccurate = entity.method_6081() != null && this.lastDamageSource != null && this.lastDamageSource.get() != entity.method_6081();
            if (healthDelta != 0.0f) {
                healthDelta = TESParticleManager.handleParticleClaims(this, healthDelta, TESParticleManager::addParticle, damageSourceAccurate);
            }
            if (healthDelta == 0.0f) {
                return;
            }
            Vector3f particlePos = new Vector3f((float)this.getEntity().method_23317(), (float)this.getEntity().method_23320(), (float)this.getEntity().method_23321());
            if (healthDelta < 0.0f) {
                class_1309 attacker;
                int teamColour;
                class_1297 class_12972;
                this.lastTransitionTime = this.getEntity().method_37908().method_8510();
                int colour = TESAPI.getConfig().getDamageParticleColour();
                if (this.lastTransitionHealth == 0.0f) {
                    this.lastTransitionHealth = this.lastHealth;
                }
                if (damageSourceAccurate && TESAPI.getConfig().teamBasedDamageParticleColours() && (class_12972 = this.getEntity().method_6081().method_5529()) instanceof class_1309 && (teamColour = (attacker = (class_1309)class_12972).method_22861()) != 0xFFFFFF) {
                    colour = teamColour;
                }
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth <= 0.0f && this.lastHealth >= this.getEntity().method_6063() ? new ComponentParticle(this, particlePos, TESParticle.Animation.POP_OFF, (class_2561)class_2561.method_43471((String)"config.tes.particle.verbal.instakill").method_10862(class_2583.field_24360.method_36139(colour))) : new DamageParticle(this, particlePos, -healthDelta).withColour(colour);
            } else {
                particle = TESAPI.getConfig().verbalHealthParticles() && this.currentHealth >= this.getEntity().method_6063() && this.lastHealth <= this.getEntity().method_6063() * 0.05f ? new ComponentParticle(this, particlePos, TESParticle.Animation.RISE, (class_2561)class_2561.method_43471((String)"config.tes.particle.verbal.fullHeal").method_10862(class_2583.field_24360.method_36139(TESAPI.getConfig().getHealParticleColour()))) : new HealParticle(this, particlePos, healthDelta);
            }
            TESParticleManager.addParticle(particle);
        }
    }
}

