/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public final class BuiltinHudElements {
    private static final class_2960 BARS_TEXTURE = new class_2960("textures/gui/bars.png");
    private static final class_2960 ICONS_TEXTURE = new class_2960("tslatentitystatus", "textures/gui/tes_icons.png");

    public static int renderEntityName(class_332 guiGraphics, class_310 mc, float partialTick, class_1309 entity, float opacity, boolean inWorldHud) {
        Objects.requireNonNull(mc.field_1772);
        int lineHeight = 9;
        if (inWorldHud) {
            if (!(TESAPI.getConfig().inWorldHudEntityName() || TESConstants.CONFIG.inWorldHudNameOverride() && entity.method_16914())) {
                return 0;
            }
            TESClientUtil.centerTextForRender(entity.method_5476(), 0.0f, 0.0f, (x, y) -> TESAPI.getConfig().inWorldHudEntityNameFontStyle().render(mc.field_1772, guiGraphics.method_51448(), entity.method_5476(), x.floatValue(), y.floatValue(), class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.method_51450()));
            if (TESAPI.getConfig().inWorldHudEntityNamespace()) {
                TESClientUtil.centerTextForRender((class_2561)class_2561.method_43470((String)("(" + class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836() + ")")), 0.0f, lineHeight, (x, y) -> TESAPI.getConfig().inWorldHudEntityNameFontStyle().render(mc.field_1772, guiGraphics.method_51448(), entity.method_5476(), x.floatValue(), y.floatValue(), class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)200, (int)200, (int)200), guiGraphics.method_51450()));
                Objects.requireNonNull(mc.field_1772);
                lineHeight += 9;
            }
        } else {
            if (!TESAPI.getConfig().hudEntityName()) {
                return 0;
            }
            TESAPI.getConfig().hudEntityNameFontStyle().render(mc.field_1772, guiGraphics.method_51448(), entity.method_5476(), 0.0f, 0.0f, class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.method_51450());
            if (TESAPI.getConfig().hudEntityNamespace()) {
                TESAPI.getConfig().hudEntityNameFontStyle().render(mc.field_1772, guiGraphics.method_51448(), (class_2561)class_2561.method_43470((String)("(" + class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836() + ")")), 0.0f, lineHeight, class_5253.class_5254.method_27764((int)255, (int)200, (int)200, (int)200), guiGraphics.method_51450());
                Objects.requireNonNull(mc.field_1772);
                lineHeight += 9;
            }
        }
        TESEntityTracking.markNameRendered(entity);
        guiGraphics.method_51450().method_37104();
        return lineHeight;
    }

    public static int renderEntityHealth(class_332 guiGraphics, class_310 mc, float partialTick, class_1309 entity, float opacity, boolean inWorldHud) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null) {
            return 0;
        }
        TESConfig config = TESAPI.getConfig();
        int barWidth = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        TESHud.BarRenderType renderType = inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, inWorldHud ? 4.0f : 1.0f, 0.0f);
        if (inWorldHud) {
            poseStack.method_46416((float)barWidth * -0.5f, 0.0f, 0.0f);
            poseStack.method_22905(1.0f, 1.0f, -1.0f);
        }
        TESClientUtil.prepRenderForTexture(BARS_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        RenderSystem.enableDepthTest();
        if (renderType != TESHud.BarRenderType.NUMERIC) {
            float percentHealth = entityState.getHealth() / entity.method_6063();
            float percentTransitionHealth = entityState.getLastTransitionHealth() / entity.method_6063();
            boolean doSegments = inWorldHud ? config.inWorldBarsSegments() : config.hudHealthBarSegments();
            int uvY = TESConstants.UTILS.getEntityType(entity).getTextureYPos();
            TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, 60, 1.0f, false, opacity);
            poseStack.method_46416(0.0f, 0.0f, 0.001f);
            if (percentTransitionHealth > percentHealth) {
                TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, uvY, entityState.getLastTransitionHealth() / entity.method_6063(), false, opacity);
            }
            poseStack.method_46416(0.0f, 0.0f, 0.001f);
            RenderSystem.enableBlend();
            TESClientUtil.constructBarRender(guiGraphics, 0, 0, barWidth, uvY + 5, percentHealth, doSegments, opacity);
        }
        if (renderType != TESHud.BarRenderType.BAR) {
            String healthText = TESUtil.roundToDecimal(entityState.getHealth(), 1) + "/" + TESUtil.roundToDecimal(entity.method_6063(), 1);
            float halfTextWidth = (float)mc.field_1772.method_1727(healthText) / 2.0f;
            float center = (float)barWidth / 2.0f;
            RenderSystem.setShader(class_757::method_34540);
            poseStack.method_46416(0.0f, 0.0f, 0.001f);
            TESClientUtil.drawColouredSquare(guiGraphics, (int)(center - halfTextWidth - 1.0f), -2, (int)(halfTextWidth * 2.0f) + 1, 9, 0x90909 | (int)(opacity * 255.0f * TESConstants.CONFIG.hudBarFontBackingOpacity()) << 24);
            poseStack.method_46416(0.0f, 0.0f, 0.001f);
            (inWorldHud ? TESAPI.getConfig().inWorldHudHealthFontStyle() : TESAPI.getConfig().hudHealthFontStyle()).render(mc.field_1772, guiGraphics.method_51448(), (class_2561)class_2561.method_43470((String)healthText), center - halfTextWidth, -1.0f, class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255), guiGraphics.method_51450());
        }
        poseStack.method_22909();
        Objects.requireNonNull(mc.field_1772);
        return 9;
    }

    public static int renderEntityArmour(class_332 guiGraphics, class_310 mc, float partialTick, class_1309 entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudArmour() : !TESAPI.getConfig().hudArmour()) {
            return 0;
        }
        int armour = TESUtil.getArmour(entity);
        if (armour <= 0) {
            return 0;
        }
        float toughness = TESUtil.getArmourToughness(entity);
        int textColour = class_5253.class_5254.method_27764((int)((int)(opacity * 255.0f)), (int)255, (int)255, (int)255);
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        if (inWorldHud) {
            int totalWidth = toughness > 0.0f ? 43 + mc.field_1772.method_1727("x" + TESUtil.roundToDecimal(toughness, 1)) : mc.field_1772.method_1727("x" + armour) + 10;
            poseStack.method_46416((float)totalWidth * -0.5f, 0.0f, 0.0f);
        }
        TESClientUtil.prepRenderForTexture(TESClientUtil.VANILLA_GUI_ICONS_LOCATION);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        TESClientUtil.drawSimpleTexture(guiGraphics, 0, 0, 9, 9, 34.0f, 9.0f, 256);
        if (toughness > 0.0f) {
            TESClientUtil.drawSimpleTexture(guiGraphics, 33, 0, 9, 9, 43.0f, 18.0f, 256);
        }
        (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.field_1772, guiGraphics.method_51448(), (class_2561)class_2561.method_43470((String)("x" + armour)), 9.5f, 1.0f, textColour, guiGraphics.method_51450());
        if (toughness > 0.0f) {
            (inWorldHud ? TESAPI.getConfig().inWorldHudArmourFontStyle() : TESAPI.getConfig().hudArmourFontStyle()).render(mc.field_1772, guiGraphics.method_51448(), (class_2561)class_2561.method_43470((String)("x" + TESUtil.roundToDecimal(toughness, 1))), 43.0f, 1.0f, textColour, guiGraphics.method_51450());
        }
        poseStack.method_22909();
        Objects.requireNonNull(mc.field_1772);
        return 9;
    }

    public static int renderEntityIcons(class_332 guiGraphics, class_310 mc, float partialTick, class_1309 entity, float opacity, boolean inWorldHud) {
        class_1310 mobType;
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudEntityIcons() : !TESAPI.getConfig().hudEntityIcons()) {
            return 0;
        }
        int x = 0;
        TESClientUtil.prepRenderForTexture(ICONS_TEXTURE);
        if (TESUtil.isFireImmune((class_1297)entity)) {
            TESClientUtil.drawSimpleTexture(guiGraphics, x, 0, 8, 8, 0.0f, 0.0f, 32);
            x += 9;
        }
        if (TESUtil.isMeleeMob(entity)) {
            TESClientUtil.drawSimpleTexture(guiGraphics, x, 0, 8, 8, 8.0f, 0.0f, 32);
            x += 9;
        }
        if (TESUtil.isRangedMob(entity)) {
            TESClientUtil.drawSimpleTexture(guiGraphics, x, 0, 8, 8, 16.0f, 0.0f, 32);
            x += 9;
        }
        if ((mobType = entity.method_6046()) != class_1310.field_6290) {
            int mobTypeU = mobType == class_1310.field_6292 ? 24 : (mobType == class_1310.field_6291 ? 16 : (mobType == class_1310.field_6293 ? 8 : 0));
            TESClientUtil.drawSimpleTexture(guiGraphics, x, 0, 8, 8, mobTypeU, 8.0f, 32);
            x += 9;
        }
        return x == 0 ? 0 : 8;
    }

    public static int renderEntityEffects(class_332 guiGraphics, class_310 mc, float partialTick, class_1309 entity, float opacity, boolean inWorldHud) {
        if (inWorldHud ? !TESAPI.getConfig().inWorldHudPotionIcons() : !TESAPI.getConfig().hudPotionIcons()) {
            return 0;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || entityState.getEffects().isEmpty()) {
            return 0;
        }
        int effectsSize = entityState.getEffects().size();
        class_4074 textureManager = mc.method_18505();
        int barLength = inWorldHud ? TESAPI.getConfig().inWorldBarsLength() : TESAPI.getConfig().hudHealthBarLength();
        float maxX = (float)barLength * 2.0f;
        int iconsPerRow = (int)Math.floor(maxX / 18.0f);
        int rows = (int)Math.ceil((float)effectsSize / (float)iconsPerRow);
        int x = inWorldHud ? Math.min(effectsSize, iconsPerRow) * -9 : 0;
        int y = 0;
        int i = 0;
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        RenderSystem.setShader(class_757::method_34542);
        poseStack.method_22905(0.5f, 0.5f, 1.0f);
        if (inWorldHud) {
            poseStack.method_22904(0.0, Math.floor((float)(effectsSize * 18) / maxX) * -18.0, 0.0);
        }
        for (class_2960 effectId : entityState.getEffects()) {
            class_1058 sprite = textureManager.method_18663((class_1291)class_7923.field_41174.method_10223(effectId));
            RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
            guiGraphics.method_25298(i * 18 + x, y, 0, 18, 18, sprite);
            if (++i < iconsPerRow) continue;
            i = 0;
            if (!inWorldHud || (y += 18) / 18 != rows - 1) continue;
            x = effectsSize % iconsPerRow % iconsPerRow * -9;
        }
        poseStack.method_22909();
        return (int)Math.ceil((float)effectsSize / (float)iconsPerRow) * 9;
    }
}

