/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util.render;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11247;
import net.minecraft.class_11767;
import net.minecraft.class_11768;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8030;
import net.minecraft.class_9848;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.object.TextRenderStyle;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;

public class TextRenderHelper {
    private final class_2561 component;
    private TextRenderStyle style = TextRenderStyle.NORMAL;
    private class_327 font;
    private int textColour;
    private int secondaryColour;
    private int packedLight;
    private boolean centered;
    private int wrapWidth;
    private int backdropColour;

    TextRenderHelper(class_2561 component) {
        this.font = class_310.method_1551().field_1772;
        this.textColour = -1;
        this.secondaryColour = -1;
        this.packedLight = 0xF000F0;
        this.centered = false;
        this.wrapWidth = -1;
        this.backdropColour = 0;
        this.component = component;
    }

    public static TextRenderHelper of(String text) {
        return TextRenderHelper.of((class_2561)class_2561.method_43470((String)text));
    }

    public static TextRenderHelper of(class_2561 component) {
        return new TextRenderHelper(component);
    }

    public TextRenderHelper style(TextRenderStyle style) {
        this.style = style;
        return this;
    }

    public TextRenderHelper colour(int colour) {
        this.textColour = colour;
        return this;
    }

    public TextRenderHelper centered() {
        return this.centered(true);
    }

    public TextRenderHelper centered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public TextRenderHelper wrapWidth(int wrapWidth) {
        this.wrapWidth = wrapWidth;
        return this;
    }

    public TextRenderHelper font(class_327 font) {
        this.font = font;
        return this;
    }

    public TextRenderHelper lightLevel(int packedLight) {
        this.packedLight = packedLight;
        return this;
    }

    public TextRenderHelper withBackdrop() {
        return this.withBackdrop(class_310.method_1551().field_1690.method_19345(0.0f));
    }

    public TextRenderHelper withBackdrop(int colour) {
        this.backdropColour = colour;
        return this;
    }

    public TextRenderHelper colour(int red, int green, int blue, int alpha) {
        return this.colour(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
    }

    public TextRenderHelper colour(float red, float green, float blue, float alpha) {
        return this.colour(class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public TextRenderHelper colour(float red, float green, float blue) {
        return this.colour(red, green, blue, 1.0f);
    }

    public TextRenderHelper colour(int red, int green, int blue) {
        return this.colour(red, green, blue, 255);
    }

    public TextRenderHelper secondaryColour(int colour) {
        this.secondaryColour = colour;
        return this;
    }

    public TextRenderHelper secondaryColour(int red, int green, int blue, int alpha) {
        return this.secondaryColour(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
    }

    public TextRenderHelper secondaryColour(float red, float green, float blue, float alpha) {
        return this.secondaryColour(class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public TextRenderHelper secondaryColour(float red, float green, float blue) {
        return this.secondaryColour(red, green, blue, 1.0f);
    }

    public TextRenderHelper secondaryColour(int red, int green, int blue) {
        return this.secondaryColour(red, green, blue, 255);
    }

    public void render(TESHudRenderContext renderContext, float x, float y) {
        renderContext.forGui(args -> this.renderForHud((TESHudRenderContext.InGuiArgs)args, x, y)).forInWorld(args -> this.renderInWorld((TESHudRenderContext.InWorldArgs)args, x, y));
    }

    public void renderForHud(TESHudRenderContext.InGuiArgs args, float x, float y) {
        if (class_9848.method_61320((int)this.textColour) == 0 && class_9848.method_61320((int)this.secondaryColour) == 0) {
            return;
        }
        Style style = Style.fromTextRenderStyle(this.style);
        int shadowColour = this.secondaryColour == -1 ? (Integer)style.colourFunction.apply((Object)this.textColour) : this.secondaryColour;
        int stringWidth = this.font.method_27525((class_5348)this.component);
        int width = this.wrapWidth == -1 ? stringWidth : Math.min(stringWidth, this.wrapWidth);
        int posX = class_3532.method_15375((float)x) - (this.centered ? width / 2 : 0);
        int posY = class_3532.method_15375((float)y);
        class_5481 charSequence = this.component.method_30937();
        class_332 guiGraphics = args.guiGraphics();
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448());
        for (Pair<class_327.class_11465, class_8030> text : style.renderFunction.prepare(this.font, charSequence, posX, posY, this.textColour, shadowColour, this.backdropColour, this.packedLight, (Either<Matrix3x2f, Matrix4f>)Either.left((Object)pose), guiGraphics.field_44659.method_70863(), null)) {
            RenderState renderState = new RenderState((class_327.class_11465)text.getFirst(), this.font, charSequence, pose, posX, posY, this.textColour, shadowColour, guiGraphics.field_44659.method_70863());
            renderState.field_60752 = (class_8030)text.getSecond();
            guiGraphics.field_59826.method_70921((class_11247)renderState);
        }
    }

    public void renderInWorld(TESHudRenderContext.InWorldArgs args, float x, float y) {
        if (class_9848.method_61320((int)this.textColour) == 0 && class_9848.method_61320((int)this.secondaryColour) == 0) {
            return;
        }
        Style style = Style.fromTextRenderStyle(this.style);
        int shadowColour = this.secondaryColour == -1 ? (Integer)style.colourFunction.apply((Object)this.textColour) : this.secondaryColour;
        int stringWidth = this.font.method_27525((class_5348)this.component);
        int width = this.wrapWidth == -1 ? stringWidth : Math.min(stringWidth, this.wrapWidth);
        int posX = class_3532.method_15375((float)x) - (this.centered ? width / 2 : 0);
        int posY = class_3532.method_15375((float)y);
        class_5481 charSequence = this.component.method_30937();
        args.renderTasks().method_73483(args.poseStack(), class_1921.method_49046(), (pose, vertexConsumer) -> style.renderFunction.prepare(this.font, charSequence, posX, posY, this.textColour, shadowColour, this.backdropColour, this.packedLight, (Either<Matrix3x2f, Matrix4f>)Either.right((Object)pose.method_23761()), null, class_310.method_1551().method_22940().method_23000()));
    }

    static class_327.class_5232 configurablePreparedText(final class_327 font, float x, float y, int colour, final int shadowColour, int backgroundColour, final boolean dropShadow) {
        class_327 class_3272 = font;
        Objects.requireNonNull(class_3272);
        return new class_327.class_5232(class_3272, x, y, colour, backgroundColour, dropShadow){
            {
                class_327 class_3273 = x0;
                Objects.requireNonNull(class_3273);
                super(class_3273, x, y, color, backgroundColor, dropShadow2);
            }

            public int method_65177(class_2583 textStyle, int textColour) {
                if (dropShadow && shadowColour != 0) {
                    return shadowColour;
                }
                Integer textStyleColour = textStyle.method_65301();
                if (textStyleColour != null) {
                    float textAlpha = class_9848.method_65100((int)textColour);
                    float shadowAlpha = class_9848.method_65100((int)textStyleColour);
                    return textAlpha != 1.0f ? class_9848.method_61330((int)class_9848.method_61326((float)(textAlpha * shadowAlpha)), (int)textStyleColour) : textStyleColour;
                }
                return 0;
            }

            public void method_71801(class_327.class_11464 glyphVisitor) {
                if (class_9848.method_61320((int)this.field_54818) != 0) {
                    glyphVisitor.method_71798(font.field_61529.method_73366().method_73406(this.field_60703, this.field_60704, this.field_60705, this.field_60706, -0.01f, this.field_54818, 0, 0.0f));
                }
                for (class_11767 renderable : this.field_60707) {
                    glyphVisitor.method_71797(renderable);
                }
                if (this.field_24252 != null) {
                    for (class_11767 effect : this.field_24252) {
                        glyphVisitor.method_71798(effect);
                    }
                }
            }
        };
    }

    static class_327.class_11464 getWorldspaceGlyphVisitor(class_4597 bufferSource, Matrix4f pose, class_327.class_6415 displayMode, int packedLight, boolean dropShadow) {
        return class_327.class_11464.method_71799((class_4597)bufferSource, (Matrix4f)pose, (class_327.class_6415)displayMode, (int)packedLight);
    }

    public static enum Style {
        NORMAL(Style::renderDefault, colour -> -16777216),
        DROP_SHADOW(Style::renderDropShadow, colour -> class_9848.method_61321((int)colour, (float)0.25f)),
        GLOWING(Style::renderOutlined, colour -> class_9848.method_61321((int)colour, (float)0.5f)),
        OUTLINED(Style::renderOutlined, colour -> -16777216);

        final RenderFunction renderFunction;
        final Int2IntFunction colourFunction;

        private Style(RenderFunction renderFunction, Int2IntFunction defaultShadowColour) {
            this.renderFunction = renderFunction;
            this.colourFunction = defaultShadowColour;
        }

        public static Style fromTextRenderStyle(TextRenderStyle style) {
            return switch (style) {
                default -> throw new MatchException(null, null);
                case TextRenderStyle.NORMAL -> NORMAL;
                case TextRenderStyle.DROP_SHADOW -> DROP_SHADOW;
                case TextRenderStyle.GLOWING -> GLOWING;
                case TextRenderStyle.OUTLINED -> OUTLINED;
            };
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        class_327.class_11465, @Nullable class_8030>> renderDefault(class_327 font, class_5481 charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable class_8030 scissor, @Nullable class_4597.class_4598 bufferSource) {
            return Style.renderDefault(font, charSequence, x, y, colour, secondaryColour, backgroundColour, packedLight, false, pose, scissor, bufferSource);
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        class_327.class_11465, @Nullable class_8030>> renderDropShadow(class_327 font, class_5481 charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable class_8030 scissor, @Nullable class_4597.class_4598 bufferSource) {
            return Style.renderDefault(font, charSequence, x, y, colour, secondaryColour, backgroundColour, packedLight, true, pose, scissor, bufferSource);
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        class_327.class_11465, @Nullable class_8030>> renderDefault(class_327 font, class_5481 charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, boolean dropShadow, Either<Matrix3x2f, Matrix4f> pose, @Nullable class_8030 scissor, @Nullable class_4597.class_4598 bufferSource) {
            class_327.class_5232 preparedText = TextRenderHelper.configurablePreparedText(font, x, y, colour, secondaryColour, backgroundColour, dropShadow);
            charSequence.accept((class_5224)preparedText);
            return (List)Either.unwrap((Either)pose.mapBoth(pose2d -> {
                class_8030 region = preparedText.method_71800();
                if (region != null) {
                    region = region.method_71523(pose2d);
                    if (scissor != null) {
                        region = scissor.method_49701(region);
                    }
                }
                return List.of(Pair.of((Object)preparedText, (Object)region));
            }, pose3d -> {
                preparedText.method_71801(TextRenderHelper.getWorldspaceGlyphVisitor((class_4597)bufferSource, pose3d, class_327.class_6415.field_33995, packedLight, dropShadow));
                return List.of();
            }));
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        class_327.class_11465, @Nullable class_8030>> renderOutlined(class_327 font, class_5481 charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable class_8030 scissor, @Nullable class_4597.class_4598 bufferSource) {
            class_327.class_5232 outlineText = TextRenderHelper.configurablePreparedText(font, 0.0f, 0.0f, secondaryColour, 0, backgroundColour, false);
            float outlineWeight = 0.6f;
            for (int xO = -1; xO <= 1; ++xO) {
                for (int yO = -1; yO <= 1; ++yO) {
                    if (xO == 0 && yO == 0) continue;
                    float[] cumulativeXOffset = new float[]{x};
                    int xOffset = xO;
                    int yOffset = yO;
                    charSequence.accept((charIndex, style, character) -> {
                        class_11768 glyph = font.method_72731(character, style);
                        float shadowOffset = glyph.method_73398().method_16800() * 0.6f;
                        outlineText.field_24250 = cumulativeXOffset[0] + (float)xOffset * shadowOffset;
                        outlineText.field_24251 = y + (float)yOffset * shadowOffset;
                        cumulativeXOffset[0] = cumulativeXOffset[0] + glyph.method_73398().method_16798(style.method_10984());
                        return outlineText.accept(charIndex, style.method_36139(backgroundColour), character);
                    });
                }
            }
            class_327.class_5232 text = TextRenderHelper.configurablePreparedText(font, x, y, colour, 0, backgroundColour, false);
            return (List)Either.unwrap((Either)pose.mapBoth(pose2d -> {
                charSequence.accept((class_5224)text);
                class_8030 region = outlineText.method_71800();
                class_8030 bounds = null;
                class_8030 bounds2 = null;
                if (region != null) {
                    region = region.method_71523(pose2d);
                    class_8030 class_80302 = bounds = scissor != null ? scissor.method_49701(region) : region;
                }
                if ((region = text.method_71800()) != null) {
                    region = region.method_71523(pose2d);
                    bounds2 = scissor != null ? scissor.method_49701(region) : region;
                }
                return List.of(Pair.of((Object)outlineText, (Object)bounds), Pair.of((Object)text, bounds2));
            }, pose3d -> {
                class_327.class_11464 glyphVisitor = TextRenderHelper.getWorldspaceGlyphVisitor((class_4597)bufferSource, pose3d, class_327.class_6415.field_33993, packedLight, false);
                for (class_11767 glyph : outlineText.field_60707) {
                    glyphVisitor.method_71797(glyph);
                }
                charSequence.accept((class_5224)text);
                text.method_71801(TextRenderHelper.getWorldspaceGlyphVisitor((class_4597)bufferSource, pose3d, class_327.class_6415.field_33995, packedLight, false));
                return List.of();
            }));
        }

        @FunctionalInterface
        static interface RenderFunction {
            public List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
            class_327.class_11465, @Nullable class_8030>> prepare(class_327 var1, class_5481 var2, float var3, float var4, int var5, int var6, int var7, int var8, Either<Matrix3x2f, Matrix4f> var9, @Nullable class_8030 var10, @Nullable class_4597.class_4598 var11);
        }
    }

    static class RenderState
    extends class_11247 {
        public RenderState(class_327.class_11465 preparedText, class_327 font, class_5481 charSequence, Matrix3x2f pose, int x, int y, int colour, int secondaryColour, @Nullable class_8030 scissor) {
            super(font, charSequence, pose, x, y, colour, secondaryColour, false, scissor);
            this.field_60751 = preparedText;
        }

        public class_327.class_11465 method_71837() {
            return this.field_60751;
        }
    }
}

