/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle.type;

import net.minecraft.class_310;
import net.minecraft.class_327;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.object.TESParticle;
import net.tslat.tes.api.util.render.TextRenderHelper;
import net.tslat.tes.core.particle.type.GenericTESParticle;
import net.tslat.tes.core.state.EntityState;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TextParticle
extends GenericTESParticle<String> {
    protected String text;
    protected int colour = -1;

    public TextParticle(@Nullable EntityState entityState, Vector3f position, String text) {
        this(entityState, position, TESParticle.Animation.POP_OFF, text);
    }

    public TextParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, String text) {
        this(entityState, position, animation, text, TESConstants.CONFIG.defaultParticleLifespan());
    }

    public TextParticle(@Nullable EntityState entityState, Vector3f position, TESParticle.Animation animation, String text, int lifespan) {
        super(entityState, position, animation, lifespan);
        this.updateData(text);
    }

    public TextParticle withColour(int colour) {
        this.colour = colour;
        return this;
    }

    public int getColour() {
        return this.colour;
    }

    @Override
    public void updateData(String data) {
        this.text = data;
    }

    @Override
    public void submitRender(TESHudRenderContext.InWorldArgs renderArgs, class_310 mc, class_327 fontRenderer) {
        this.defaultedTextRender(mc, renderArgs.poseStack(), this.prevPos, this.pos, renderArgs.partialTick(), () -> TextRenderHelper.of(this.text).centered().colour(this.getColour()).style(TESAPI.getConfig().particleFontStyle()).renderInWorld(renderArgs, 0.0f, -4.0f));
    }
}

