/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.mixin;

import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerSnowMixin {
    private static final String SSP = "SereneSeasonsPlus";

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private static void ssp$write(ServerLevel level, ChunkAccess access, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag root = (CompoundTag)cir.getReturnValue();
        if (!(access instanceof ISnowTrackedChunk)) {
            return;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("LastWinterId", tracked.sereneseasonsplus$getLastWinterId());
        tag.m_128405_("SurfaceHeight", tracked.sereneseasonsplus$getSurfaceHeight());
        tag.m_128350_("StormProgress", tracked.sereneseasonsplus$getStormProgress());
        tag.m_128405_("StormIdApplied", tracked.sereneseasonsplus$getStormIdApplied());
        tag.m_128405_("LastProgressTick", tracked.sereneseasonsplus$getLastProgressTick());
        tag.m_128405_("AvailableColumns", tracked.sereneseasonsplus$getAvailableSnowColumns());
        tag.m_128405_("DestroyedStormId", tracked.sereneseasonsplus$getDestroyedStormId());
        ListTag snowList = new ListTag();
        for (Map.Entry<BlockPos, Integer> entry : tracked.sereneseasonsplus$getSnowColumns().entrySet()) {
            CompoundTag entry2 = new CompoundTag();
            entry2.m_128356_("Pos", entry.getKey().m_121878_());
            entry2.m_128405_("Layers", entry.getValue().intValue());
            snowList.add((Object)entry2);
        }
        tag.m_128365_("SnowColumns", (Tag)snowList);
        ListTag iceList = new ListTag();
        for (BlockPos pos : tracked.sereneseasonsplus$getIceColumns()) {
            CompoundTag entry = new CompoundTag();
            entry.m_128356_("Pos", pos.m_121878_());
            iceList.add((Object)entry);
        }
        tag.m_128365_("IceColumns", (Tag)iceList);
        ListTag listTag = new ListTag();
        for (Long key : tracked.sereneseasonsplus$getDestroyedColumns()) {
            CompoundTag entry = new CompoundTag();
            entry.m_128356_("XZ", key.longValue());
            listTag.add((Object)entry);
        }
        tag.m_128365_("DestroyedColumns", (Tag)listTag);
        root.m_128365_(SSP, (Tag)tag);
    }

    @Inject(method={"read(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/ai/village/poi/PoiManager;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/level/chunk/ProtoChunk;"}, at={@At(value="RETURN")})
    private static void ssp$rehydrateOnRead(ServerLevel level, PoiManager poi, ChunkPos pos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> cir) {
        CompoundTag tag = nbt.m_128469_(SSP);
        if (tag.m_128456_()) {
            return;
        }
        ProtoChunk ret = (ProtoChunk)cir.getReturnValue();
        if (ret instanceof ImposterProtoChunk) {
            ImposterProtoChunk ipc = (ImposterProtoChunk)ret;
            LevelChunk lc = ipc.m_62768_();
            ChunkSerializerSnowMixin.ssp$applyTagToTracked(lc, tag);
        } else {
            ChunkSerializerSnowMixin.ssp$applyTagToTracked(ret, tag);
        }
    }

    @Unique
    private static void ssp$applyTagToTracked(Object chunk, CompoundTag tag) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        if (tag.m_128441_("LastWinterId")) {
            tracked.sereneseasonsplus$setLastWinterId(tag.m_128451_("LastWinterId"));
        }
        if (tag.m_128441_("SurfaceHeight")) {
            tracked.sereneseasonsplus$setSurfaceHeight(tag.m_128451_("SurfaceHeight"));
        }
        if (tag.m_128441_("StormProgress")) {
            tracked.sereneseasonsplus$setStormProgress(tag.m_128457_("StormProgress"));
        }
        if (tag.m_128441_("StormIdApplied")) {
            tracked.sereneseasonsplus$setStormIdApplied(tag.m_128451_("StormIdApplied"));
        }
        if (tag.m_128441_("LastProgressTick")) {
            tracked.sereneseasonsplus$setLastProgressTick(tag.m_128451_("LastProgressTick"));
        }
        if (tag.m_128441_("AvailableColumns")) {
            tracked.sereneseasonsplus$setAvailableSnowColumns(tag.m_128451_("AvailableColumns"));
        }
        if (tag.m_128441_("DestroyedStormId")) {
            tracked.sereneseasonsplus$setDestroyedStormId(tag.m_128451_("DestroyedStormId"));
        }
        tracked.sereneseasonsplus$getSnowColumns().clear();
        ListTag snow = tag.m_128437_("SnowColumns", 10);
        for (int i = 0; i < snow.size(); ++i) {
            CompoundTag e = snow.m_128728_(i);
            tracked.sereneseasonsplus$getSnowColumns().put(BlockPos.m_122022_((long)e.m_128454_("Pos")).m_7949_(), e.m_128451_("Layers"));
        }
        tracked.sereneseasonsplus$getIceColumns().clear();
        ListTag ice = tag.m_128437_("IceColumns", 10);
        for (int i = 0; i < ice.size(); ++i) {
            CompoundTag e = ice.m_128728_(i);
            tracked.sereneseasonsplus$getIceColumns().add(BlockPos.m_122022_((long)e.m_128454_("Pos")).m_7949_());
        }
        tracked.sereneseasonsplus$getDestroyedColumns().clear();
        ListTag destroyed = tag.m_128437_("DestroyedColumns", 10);
        for (int i = 0; i < destroyed.size(); ++i) {
            CompoundTag e = destroyed.m_128728_(i);
            tracked.sereneseasonsplus$getDestroyedColumns().add(e.m_128454_("XZ"));
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void ssp$read(ServerLevel level, PoiManager poi, ChunkPos pos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> cir) {
        ChunkAccess access = (ChunkAccess)cir.getReturnValue();
        if (access instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
            CompoundTag tag = nbt.m_128469_(SSP);
            if (!tag.m_128456_()) {
                BlockPos bp;
                if (tag.m_128441_("LastWinterId")) {
                    tracked.sereneseasonsplus$setLastWinterId(tag.m_128451_("LastWinterId"));
                }
                if (tag.m_128441_("SurfaceHeight")) {
                    tracked.sereneseasonsplus$setSurfaceHeight(tag.m_128451_("SurfaceHeight"));
                }
                if (tag.m_128441_("StormProgress")) {
                    tracked.sereneseasonsplus$setStormProgress(tag.m_128457_("StormProgress"));
                }
                if (tag.m_128441_("StormIdApplied")) {
                    tracked.sereneseasonsplus$setStormIdApplied(tag.m_128451_("StormIdApplied"));
                }
                if (tag.m_128441_("LastProgressTick")) {
                    tracked.sereneseasonsplus$setLastProgressTick(tag.m_128451_("LastProgressTick"));
                }
                if (tag.m_128441_("AvailableColumns")) {
                    tracked.sereneseasonsplus$setAvailableSnowColumns(tag.m_128451_("AvailableColumns"));
                }
                if (tag.m_128441_("DestroyedStormId")) {
                    tracked.sereneseasonsplus$setDestroyedStormId(tag.m_128451_("DestroyedStormId"));
                }
                tracked.sereneseasonsplus$getSnowColumns().clear();
                ListTag list = tag.m_128437_("SnowColumns", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag entry = list.m_128728_(i);
                    long posLong = entry.m_128454_("Pos");
                    int layers = entry.m_128451_("Layers");
                    bp = BlockPos.m_122022_((long)posLong);
                    tracked.sereneseasonsplus$getSnowColumns().put(bp.m_7949_(), layers);
                }
                tracked.sereneseasonsplus$getIceColumns().clear();
                ListTag iceList = tag.m_128437_("IceColumns", 10);
                for (int i = 0; i < iceList.size(); ++i) {
                    CompoundTag entry = iceList.m_128728_(i);
                    long posLong = entry.m_128454_("Pos");
                    bp = BlockPos.m_122022_((long)posLong);
                    tracked.sereneseasonsplus$getIceColumns().add(bp.m_7949_());
                }
                tracked.sereneseasonsplus$getDestroyedColumns().clear();
                ListTag destroyedList = tag.m_128437_("DestroyedColumns", 10);
                for (int i = 0; i < destroyedList.size(); ++i) {
                    CompoundTag entry = destroyedList.m_128728_(i);
                    long xz = entry.m_128454_("XZ");
                    tracked.sereneseasonsplus$getDestroyedColumns().add(xz);
                }
            }
        }
    }
}

