/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.util;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.storage.SnowSavedData;
import com.Gabou.sereneseasonsplus.util.DefaultRainHandler;
import com.Gabou.sereneseasonsplus.util.HotSeason;
import com.Gabou.sereneseasonsplus.util.IEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.IRainHandler;
import com.Gabou.sereneseasonsplus.util.WorldContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;
import sereneseasons.api.season.Season;

public class EnvironmentHelper {
    private static IEnvironmentHelper delegate;
    private static IRainHandler rainHandler;
    private static final String SAVE_DIR = "data/sereneseasonsplus";
    private static final String SAVE_FILE = "world_state.json";
    private static final Gson GSON;
    private static Season.SubSeason lastSubSeason;
    private static int currentWinterId;

    public static void init(IEnvironmentHelper impl) {
        delegate = impl;
    }

    public static boolean isClient() {
        return delegate.isClient();
    }

    public static boolean isRainning(ServerLevel level, BlockPos pos) {
        return rainHandler.isRainingAt(level, pos);
    }

    public static void onSimpleCloudSpawned(ServerLevel level, int hashcode) {
        rainHandler.onSimpleCloudsSpawned(level, hashcode);
    }

    public static void checkAndUpdate(ServerLevel level) {
        rainHandler.checkAndUpdate(level);
    }

    public static void onSimpleCloudsDespawned(ServerLevel level, int hashcode) {
        rainHandler.onSimpleCloudsDespawned(level, hashcode);
    }

    public static void initRainHandler(IRainHandler handler) {
        if (handler != null) {
            rainHandler = handler;
        }
    }

    public static void onWorldLoad(ServerLevel level) {
        if (level == null || level.m_5776_()) {
            return;
        }
        Path path = EnvironmentHelper.getWorldDataPath(level);
        try {
            String raw;
            JsonObject obj;
            if (Files.exists(path, new LinkOption[0]) && (obj = (JsonObject)GSON.fromJson(raw = Files.readString(path, StandardCharsets.UTF_8), JsonObject.class)) != null) {
                if (obj.has("currentWinterId")) {
                    currentWinterId = obj.get("currentWinterId").getAsInt();
                }
                if (obj.has("lastSubSeason")) {
                    try {
                        lastSubSeason = Season.SubSeason.valueOf((String)obj.get("lastSubSeason").getAsString());
                    }
                    catch (IllegalArgumentException ignored) {
                        lastSubSeason = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void onWorldSave(ServerLevel level) {
        if (level == null || level.m_5776_()) {
            return;
        }
        Path path = EnvironmentHelper.getWorldDataPath(level);
        try {
            Season.SubSeason cur;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            JsonObject obj = new JsonObject();
            obj.addProperty("version", (Number)1);
            obj.addProperty("currentWinterId", (Number)currentWinterId);
            Season.SubSeason subSeason = cur = lastSubSeason != null ? lastSubSeason : EnvironmentHelper.getCurrentSeason();
            if (cur != null) {
                obj.addProperty("lastSubSeason", cur.name());
            }
            String json = GSON.toJson((JsonElement)obj);
            Files.writeString(path, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Path getWorldDataPath(ServerLevel level) {
        Path root = level.m_7654_().m_129843_(LevelResource.f_78182_);
        return root.resolve(SAVE_DIR).resolve(SAVE_FILE);
    }

    public static boolean shouldRunMod() {
        return delegate.shouldRunMod();
    }

    public static boolean isHotSeason() {
        return delegate.isHotSeason();
    }

    public static boolean isSnowySeason() {
        return delegate.isSnowySeason();
    }

    public static Season.SubSeason getCurrentSeason() {
        return delegate.getCurrentSeason();
    }

    public static void onServerStarted(ServerLevel level) {
        WorldContext.setOverworld(level);
        EnvironmentHelper.onWorldLoad(level);
        EnvironmentHelper.onSeasonChange(level, false);
        CommonSnowBlockFeature.HANDLER.resetWinterState(level, currentWinterId);
    }

    public static int getCurrentWinterId() {
        return currentWinterId;
    }

    public static void onSeasonChange(ServerLevel serverLevel, boolean forced) {
        delegate.onSeasonChange(serverLevel);
        Season.SubSeason current = EnvironmentHelper.getCurrentSeason();
        if (current == Season.SubSeason.EARLY_WINTER && lastSubSeason != Season.SubSeason.EARLY_WINTER) {
            CommonSnowBlockFeature.HANDLER.resetWinterState(serverLevel, ++currentWinterId);
        }
        lastSubSeason = current;
        if (HotSeason.isHotSeason(current)) {
            SnowHistorySavedData hist = SnowHistorySavedData.get();
            hist.currentStormId = 0;
            hist.snowHistory.clear();
            hist.m_77762_();
        }
        if (forced) {
            CommonSnowBlockFeature.onSeasonChange(serverLevel);
        }
    }

    public static void onServerStopping(ServerLevel level) {
        EnvironmentHelper.onWorldSave(level);
        CommonSnowBlockFeature.onServerStopping();
        CommonSnowBlockFeature.HANDLER.clear(level);
        WorldContext.clear();
        SnowSavedData.clearCachedInstance();
        SnowHistorySavedData.clearCachedInstance();
    }

    public static int getGrassChance() {
        return delegate.getGrassChance(false);
    }

    static {
        rainHandler = new DefaultRainHandler();
        GSON = new GsonBuilder().setPrettyPrinting().create();
        lastSubSeason = null;
        currentWinterId = 0;
    }
}

