/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class SereneExtendedConfig {
    public static final int MIN_CORES_FOR_ASYNC = 6;
    public static final BooleanValue USE_ASYNC;
    public static final IntValue TICK_SNOW_PILLER;
    public static final IntValue TICK_SNOW_REPLACER;
    public static final BooleanValue ENABLE_SEASONAL_DAYLIGHT_CYCLE;
    public static final DoubleValue CUSTOM_DAY_LENGTH;
    public static final DoubleValue CUSTOM_NIGHT_LENGTH;
    public static final BooleanValue CUSTOM_CYCLE_LENGTH;
    public static final BooleanValue SNOWSTORM_ENABLED;
    public static final IntValue SNOWSTORM_INTENSITY;
    private static final Gson GSON;
    private static final Path CONFIG_PATH;
    private static final List<Runnable> reloadListeners;

    public static void load() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            SereneExtendedConfig.save();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj == null) {
                return;
            }
            USE_ASYNC.load(obj);
            TICK_SNOW_PILLER.load(obj);
            TICK_SNOW_REPLACER.load(obj);
            SNOWSTORM_ENABLED.load(obj);
            SNOWSTORM_INTENSITY.load(obj);
            ENABLE_SEASONAL_DAYLIGHT_CYCLE.load(obj);
            CUSTOM_CYCLE_LENGTH.load(obj);
            CUSTOM_DAY_LENGTH.load(obj);
            CUSTOM_NIGHT_LENGTH.load(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void notifyReloadListeners() {
        for (Runnable r : reloadListeners) {
            try {
                r.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void registerReloadListener(Runnable listener) {
        reloadListeners.add(listener);
    }

    public static void save() {
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            JsonObject obj = new JsonObject();
            USE_ASYNC.save(obj);
            TICK_SNOW_PILLER.save(obj);
            TICK_SNOW_REPLACER.save(obj);
            SNOWSTORM_ENABLED.save(obj);
            SNOWSTORM_INTENSITY.save(obj);
            ENABLE_SEASONAL_DAYLIGHT_CYCLE.save(obj);
            CUSTOM_CYCLE_LENGTH.save(obj);
            CUSTOM_DAY_LENGTH.save(obj);
            CUSTOM_NIGHT_LENGTH.save(obj);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((JsonElement)obj, (Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("sereneseasonsplus.json");
        reloadListeners = new ArrayList<Runnable>();
        USE_ASYNC = new BooleanValue("useAsync", Runtime.getRuntime().availableProcessors() > 6);
        TICK_SNOW_PILLER = new IntValue("tickSnowPiller", 20, 1, Integer.MAX_VALUE);
        TICK_SNOW_REPLACER = new IntValue("tickSnowReplacer", 100, 1, Integer.MAX_VALUE);
        SNOWSTORM_ENABLED = new BooleanValue("snowstormEnabled", false);
        SNOWSTORM_INTENSITY = new IntValue("snowstormIntensity", 0, 0, 100);
        ENABLE_SEASONAL_DAYLIGHT_CYCLE = new BooleanValue("enableSeasonalDaylightCycle", true);
        CUSTOM_CYCLE_LENGTH = new BooleanValue("customCycleLength", false);
        CUSTOM_DAY_LENGTH = new DoubleValue("customDayLength", 1.0, 0.05, 100.0);
        CUSTOM_NIGHT_LENGTH = new DoubleValue("customNightLength", 1.0, 0.05, 100.0);
        SereneExtendedConfig.load();
    }

    public static final class BooleanValue {
        private final String key;
        private boolean value;
        private final boolean def;

        public BooleanValue(String key, boolean def) {
            this.key = key;
            this.value = def;
            this.def = def;
        }

        public boolean get() {
            return this.value;
        }

        public void set(boolean v) {
            this.value = v;
        }

        void load(JsonObject obj) {
            if (obj.has(this.key)) {
                this.value = obj.get(this.key).getAsBoolean();
            }
        }

        void save(JsonObject obj) {
            obj.addProperty(this.key, Boolean.valueOf(this.value));
        }
    }

    public static final class IntValue {
        private final String key;
        private int value;
        private final int min;
        private final int max;

        public IntValue(String key, int def, int min, int max) {
            this.key = key;
            this.value = def;
            this.min = min;
            this.max = max;
        }

        public int get() {
            return this.value;
        }

        public void set(int v) {
            this.value = Math.max(this.min, Math.min(this.max, v));
        }

        void load(JsonObject obj) {
            if (obj.has(this.key)) {
                this.set(obj.get(this.key).getAsInt());
            }
        }

        void save(JsonObject obj) {
            obj.addProperty(this.key, (Number)this.value);
        }
    }

    public static final class DoubleValue {
        private final String key;
        private double value;
        private final double min;
        private final double max;

        public DoubleValue(String key, double def, double min, double max) {
            this.key = key;
            this.value = def;
            this.min = min;
            this.max = max;
        }

        public double get() {
            return this.value;
        }

        public void set(double v) {
            this.value = Math.max(this.min, Math.min(this.max, v));
        }

        void load(JsonObject obj) {
            if (obj.has(this.key)) {
                this.set(obj.get(this.key).getAsDouble());
            }
        }

        void save(JsonObject obj) {
            obj.addProperty(this.key, (Number)this.value);
        }
    }
}

