/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.config;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class SereneExtendedList
extends ObjectSelectionList<Row> {
    public SereneExtendedList(Minecraft mc, int width, int height, int top, int itemHeight) {
        super(mc, width, height, top, itemHeight);
    }

    public int getRowWidth() {
        return 360;
    }

    protected int getScrollbarPosition() {
        return this.getRowLeft() + this.getRowWidth() + 8;
    }

    public void addRow(Component label, AbstractWidget ... widgets) {
        this.addEntry((AbstractSelectionList.Entry)new Row(this, label, widgets));
    }

    public static class Row
    extends ObjectSelectionList.Entry<Row> {
        private final SereneExtendedList owner;
        private final Component label;
        private final List<AbstractWidget> widgets;
        private int lastX = Integer.MIN_VALUE;
        private int lastY = Integer.MIN_VALUE;
        private int lastRowW = Integer.MIN_VALUE;
        private int lastRowH = Integer.MIN_VALUE;

        Row(SereneExtendedList owner, Component label, AbstractWidget ... widgets) {
            this.owner = owner;
            this.label = label;
            this.widgets = Arrays.asList(widgets);
        }

        private void layoutIfNeeded(int x, int y, int rowWidth, int rowHeight) {
            if (x == this.lastX && y == this.lastY && rowWidth == this.lastRowW && rowHeight == this.lastRowH) {
                return;
            }
            this.lastX = x;
            this.lastY = y;
            this.lastRowW = rowWidth;
            this.lastRowH = rowHeight;
            int wx = x + rowWidth - 200;
            int wy = y + (rowHeight - 20) / 2;
            for (AbstractWidget w : this.widgets) {
                if (w.getX() != wx) {
                    w.setX(wx);
                }
                if (w.getY() != wy) {
                    w.setY(wy);
                }
                if (w.getWidth() == 200) continue;
                w.setWidth(200);
            }
        }

        public void render(GuiGraphics g, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.layoutIfNeeded(x, y, rowWidth, rowHeight);
            g.drawString(((SereneExtendedList)this.owner).minecraft.font, this.label, x, y + 6, 0xFFFFFF, false);
            for (AbstractWidget w : this.widgets) {
                w.render(g, mouseX, mouseY, delta);
            }
        }

        public List<? extends NarratableEntry> narratables() {
            return this.widgets;
        }

        public List<? extends GuiEventListener> children() {
            return this.widgets;
        }

        public boolean mouseClicked(double mx, double my, int button) {
            for (AbstractWidget w : this.widgets) {
                if (!w.mouseClicked(mx, my, button)) continue;
                this.owner.setSelected((AbstractSelectionList.Entry)this);
                w.setFocused(true);
                return true;
            }
            this.owner.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public boolean mouseReleased(double mx, double my, int button) {
            for (AbstractWidget w : this.widgets) {
                w.mouseReleased(mx, my, button);
            }
            return false;
        }

        public boolean mouseDragged(double mx, double my, int button, double dx, double dy) {
            for (AbstractWidget w : this.widgets) {
                if (!w.mouseDragged(mx, my, button, dx, dy)) continue;
                return true;
            }
            return false;
        }

        public boolean mouseScrolled(double mx, double my, double deltaX, double deltaY) {
            for (AbstractWidget w : this.widgets) {
                if (!w.mouseScrolled(mx, my, deltaX, deltaY)) continue;
                return true;
            }
            return false;
        }

        public boolean keyPressed(int key, int sc, int mods) {
            for (AbstractWidget w : this.widgets) {
                if (!w.keyPressed(key, sc, mods)) continue;
                return true;
            }
            return false;
        }

        public boolean charTyped(char c, int mods) {
            for (AbstractWidget w : this.widgets) {
                if (!w.charTyped(c, mods)) continue;
                return true;
            }
            return false;
        }

        public void updateNarration(NarrationElementOutput out) {
        }

        public Component getNarration() {
            return this.label;
        }
    }
}

