/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.features.DefaultSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.features.SnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.features.logic.SnowLogic;
import com.Gabou.sereneseasonsplus.features.snowstorm.ISnowStormLevel;
import com.Gabou.sereneseasonsplus.storage.ChunkQueue;
import com.Gabou.sereneseasonsplus.tags.SSPTags;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import com.Gabou.sereneseasonsplus.util.MinecraftServerAccess;
import com.Gabou.sereneseasonsplus.util.SnowUtils;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.season.SeasonHooks;

public class CommonSnowBlockFeature {
    public static final Logger LOGGER = LogManager.getLogger((String)"SnowBlockReplacer");
    protected static final Random RANDOM = new Random();
    protected static final Map<ServerPlayer, BlockPos> playerPositions = new ConcurrentHashMap<ServerPlayer, BlockPos>();
    protected static boolean snowStormEnabled = false;
    protected static int tickThresholdSnowReplacer;
    protected static int tickThresholdSnowReplacerForHotSeasons;
    protected static int tickCounter;
    public static SnowEnvironmentHandler HANDLER;
    protected static int snowStormIntensity;
    protected static boolean isSnowStorming;
    private static boolean didStartupCatchUp;
    protected static final int MAX_ATTEMPTS = 12;
    public static int counterTime;

    public static int getTickCounter() {
        return tickCounter;
    }

    public static void handleServerTick(MinecraftServer server, ServerLevel level) {
        if (level != null && !level.isClientSide()) {
            ChunkQueue.Entry entry;
            ++tickCounter;
            if (level.random.nextInt(16) == 0) {
                CommonSnowBlockFeature.updatePlayerPositions(level.players());
                CommonSnowBlockFeature.passifSnowBlocks(level);
            }
            if (!didStartupCatchUp && tickCounter > 40) {
                CommonSnowBlockFeature.performStartupCatchUp(level);
                didStartupCatchUp = true;
            }
            if (tickCounter % 5 != 0 && tickCounter > 10) {
                return;
            }
            int processed = 0;
            if (ChunkQueue.isEmpty()) {
                ChunkQueue.shuffle();
            }
            block4: while ((entry = ChunkQueue.poll()) != null) {
                if (!(((MinecraftServerAccess)server).sereneseasonsplus$tempsEcoule() && processed < 100 || processed < 8)) {
                    if (entry.type() == ChunkQueue.TaskType.APPLY_SNOW) {
                        CommonSnowBlockFeature.enqueueChunkForSnowApply(entry.pos(), entry.subSeason());
                        break;
                    }
                    CommonSnowBlockFeature.enqueueChunkForSnowMelt(entry.pos(), entry.fullClear());
                    break;
                }
                boolean changed = false;
                ChunkPos chunkPos = entry.pos();
                if (!level.hasChunk(chunkPos.x, chunkPos.z)) continue;
                LevelChunk chunk = level.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false);
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                switch (entry.type()) {
                    case APPLY_SNOW: {
                        boolean allowPile;
                        int globalWinterId = EnvironmentHelper.getCurrentWinterId();
                        Season.SubSeason subSeason = EnvironmentHelper.getCurrentSeason();
                        if (tracked.sereneseasonsplus$getLastWinterId() != globalWinterId) {
                            tracked.sereneseasonsplus$setLastWinterId(globalWinterId);
                            tracked.sereneseasonsplus$setSnowCount(-1);
                            tracked.sereneseasonsplus$setHasAppliedInitialSnow(false);
                            tracked.sereneseasonsplus$setShouldApplyInitialSnow(false);
                            tracked.sereneseasonsplus$willReceiveSnow(false);
                            tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(true);
                            continue block4;
                        }
                        boolean isRainingNow = EnvironmentHelper.isRainning(level, chunkPos.getMiddleBlockPosition(65));
                        int sc = tracked.sereneseasonsplus$getSnowCount();
                        boolean bl = allowPile = sc < 1 || sc > 1 || sc == 1 && !isRainingNow;
                        if (!allowPile) {
                            CommonSnowBlockFeature.enqueueChunkForSnowApplyWithSitting(chunkPos, subSeason, entry.sittingTicks());
                            tracked.sereneseasonsplus$willReceiveSnow(true);
                            break;
                        }
                        changed = CommonSnowBlockFeature.applySnowToChunk(level, chunkPos, subSeason, level.getRandom());
                        if (changed) {
                            chunk.setUnsaved(true);
                            tracked.sereneseasonsplus$setHasAppliedInitialSnow(true);
                            tracked.sereneseasonsplus$setShouldApplyInitialSnow(false);
                            tracked.sereneseasonsplus$incrementSnowCount();
                            tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(true);
                            tracked.sereneseasonsplus$willReceiveSnow(false);
                        } else if (tracked.sereneseasonsplus$getSnowCount() <= 0 && entry.sittingTicks() < 20) {
                            tracked.sereneseasonsplus$willReceiveSnow(true);
                            CommonSnowBlockFeature.enqueueChunkForSnowApplyWithSitting(chunkPos, subSeason, entry.sittingTicks());
                        } else {
                            tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(true);
                            tracked.sereneseasonsplus$willReceiveSnow(false);
                            ChunkQueue.enqueueBugged(chunkPos, subSeason);
                        }
                        HANDLER.onSnowApplied(level, chunkPos, changed);
                        break;
                    }
                    case MELT_SNOW: {
                        changed = CommonSnowBlockFeature.meltSnowInChunk(level, chunkPos, entry.fullClear());
                        if (!changed) break;
                        chunk.setUnsaved(true);
                        tracked.sereneseasonsplus$setHasAppliedInitialSnow(false);
                        tracked.sereneseasonsplus$setShouldApplyInitialSnow(false);
                        tracked.sereneseasonsplus$setSnowCount(0);
                        tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(false);
                        tracked.sereneseasonsplus$willReceiveSnow(false);
                    }
                }
                ++processed;
            }
        }
    }

    public static void handleOnChunkLoad(LevelChunk chunk, ServerLevel level) {
        ++counterTime;
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        if (tracked == null) {
            return;
        }
        ChunkPos chunkPos = chunk.getPos();
        ISeasonState seasonState = SeasonHelper.getSeasonState((Level)level);
        Season.SubSeason currentSeason = EnvironmentHelper.getCurrentSeason();
        if (seasonState == null || currentSeason == null) {
            ChunkQueue.enqueueScheduled(chunkPos);
            return;
        }
        SnowLogic.evaluate(level, currentSeason, seasonState, tracked, chunkPos, true);
    }

    public static void enqueueChunkForSnowApply(ChunkPos chunkPos, Season.SubSeason subSeason) {
        ChunkQueue.enqueueApply(chunkPos, subSeason);
    }

    public static void enqueueChunkForSnowApplyWithSitting(ChunkPos chunkPos, Season.SubSeason subSeason, int sitting) {
        ChunkQueue.enqueueApplyWithSitting(chunkPos, subSeason, sitting + 1);
    }

    public static void enqueueChunkForSnowMelt(ChunkPos chunkPos, boolean fullClear) {
        ChunkQueue.enqueueMelt(chunkPos, fullClear);
    }

    public static boolean applySnowToChunk(ServerLevel level, ChunkPos chunkPos, Season.SubSeason subSeason, RandomSource random) {
        LevelChunk chunk = level.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false);
        if (chunk == null) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int day = SeasonHelper.getSeasonState((Level)level).getDay();
        LayerBounds bounds = CommonSnowBlockFeature.getSeasonalLayerBounds(subSeason, day);
        if (bounds == null) {
            tracked.sereneseasonsplus$willReceiveSnow(false);
            return false;
        }
        boolean[] changed = new boolean[]{false};
        RandomSource columnRandom = RandomSource.create((long)(chunkPos.toLong() ^ level.getSeed() ^ random.nextLong()));
        CommonSnowBlockFeature.iterateChunkColumns(level, chunkPos, (pos, state) -> {
            BlockPos belowPos = pos.below();
            if (CommonSnowBlockFeature.tryPlaceSnow(level, (BlockPos)pos, belowPos, subSeason, day, columnRandom, bounds)) {
                changed[0] = true;
            }
        });
        return changed[0];
    }

    private static boolean tryPlaceSnow(ServerLevel level, BlockPos surfacePos, BlockPos belowPos, Season.SubSeason subSeason, int day, RandomSource columnRandom, LayerBounds bounds) {
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.isAir() || !belowState.getFluidState().isEmpty()) {
            return false;
        }
        if (!SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (BlockPos)surfacePos)) {
            return false;
        }
        BlockState current = level.getBlockState(surfacePos);
        if (current.canBeReplaced()) {
            return CommonSnowBlockFeature.setSnowLayersIfChanged(level, surfacePos, 1, true);
        }
        if (!Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)level, surfacePos)) {
            return false;
        }
        double wave = Math.sin((double)surfacePos.getX() * 0.12 + (double)surfacePos.getZ() * 0.12 + (double)day * 0.05);
        double normalized = (wave + 1.0) * 0.5;
        int range = bounds.maxLayers() - bounds.minLayers();
        int baseLayers = bounds.minLayers() + (range > 0 ? (int)Math.round(normalized * (double)range) : 0);
        baseLayers = Mth.clamp((int)baseLayers, (int)bounds.minLayers(), (int)bounds.maxLayers());
        int jitter = columnRandom.nextInt(3) - 1;
        int targetLayers = Mth.clamp((int)(baseLayers + jitter), (int)1, (int)8);
        if (current.is(Blocks.SNOW_BLOCK)) {
            targetLayers = 8;
        } else if (current.is(Blocks.SNOW) && current.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            int existing = (Integer)current.getValue((Property)SnowLayerBlock.LAYERS);
            targetLayers = Math.max(existing, targetLayers);
        }
        return CommonSnowBlockFeature.setSnowLayersIfChanged(level, surfacePos, targetLayers, true);
    }

    public static boolean meltSnowInChunk(ServerLevel level, ChunkPos chunkPos, boolean fullClear) {
        if (fullClear) {
            CommonSnowBlockFeature.clearSnowAndIce(level, chunkPos);
            return true;
        }
        RandomSource random = level.getRandom();
        CommonSnowBlockFeature.iterateChunkColumns(level, chunkPos, (pos, state) -> {
            if (state.is(Blocks.SNOW_BLOCK)) {
                if (random.nextBoolean()) {
                    CommonSnowBlockFeature.clearIfChanged(level, (BlockPos)pos, false);
                } else {
                    CommonSnowBlockFeature.setSnowLayersIfChanged(level, (BlockPos)pos, 4, false);
                }
            } else if (state.is(Blocks.SNOW)) {
                int drop;
                int layers = (Integer)state.getValue((Property)BlockStateProperties.LAYERS);
                int newLayers = Math.max(0, layers - (drop = 1 + random.nextInt(2)));
                if (newLayers <= 0) {
                    CommonSnowBlockFeature.clearIfChanged(level, (BlockPos)pos, false);
                } else {
                    CommonSnowBlockFeature.setSnowLayersIfChanged(level, (BlockPos)pos, newLayers, false);
                }
            } else if (state.is(Blocks.ICE) && random.nextFloat() < 0.35f) {
                CommonSnowBlockFeature.clearIfChanged(level, (BlockPos)pos, true);
            }
        });
        return true;
    }

    protected static void updatePlayerPositions(Iterable<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            playerPositions.put(player, player.blockPosition());
        }
    }

    protected static void passifSnowBlocks(ServerLevel level) {
        for (Map.Entry<ServerPlayer, BlockPos> entry : playerPositions.entrySet()) {
            ServerPlayer player = entry.getKey();
            BlockPos playerPos = entry.getValue();
            int simulationDistance = CommonSnowBlockFeature.getSimulationDistance(player);
            int radius = Mth.clamp((int)(simulationDistance * 16), (int)16, (int)64);
            int blocksToReplace = HANDLER.getBlocksToReplace(level, playerPos);
            if (blocksToReplace < 0) {
                if (!EnvironmentHelper.isRainning(level, playerPos)) {
                    return;
                }
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                BlockPos.MutableBlockPos below = new BlockPos.MutableBlockPos();
                RandomSource random = level.random;
                for (int attempt = 0; attempt < 12; ++attempt) {
                    boolean canStackSnow;
                    int dx = random.nextInt(radius * 2 + 1) - radius;
                    int dz = random.nextInt(radius * 2 + 1) - radius;
                    int x = playerPos.getX() + dx;
                    int z = playerPos.getZ() + dz;
                    int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                    pos.set(x, y, z);
                    below.set(x, y - 1, z);
                    BlockState stateAt = level.getBlockState((BlockPos)pos);
                    boolean bl = canStackSnow = stateAt.is(Blocks.SNOW) && stateAt.hasProperty((Property)SnowLayerBlock.LAYERS) && (Integer)stateAt.getValue((Property)SnowLayerBlock.LAYERS) < 8;
                    if (!level.isEmptyBlock((BlockPos)pos) && !canStackSnow || level.getBlockState((BlockPos)below).is(Blocks.WATER)) continue;
                    CommonSnowBlockFeature.placeSingleLayerNoClimb(level, (BlockPos)pos);
                }
                continue;
            }
            for (int i = 0; i < blocksToReplace; ++i) {
                BlockPos targetPos = CommonSnowBlockFeature.findSnowBlockInRadius(level, playerPos, radius);
                if (targetPos == null) continue;
                SnowUtils.breakOrDecrementLayer((Level)level, targetPos);
            }
        }
    }

    protected static int calculateBlocksToReplace1(float temperature) {
        return (int)Math.ceil(temperature / 5.0f);
    }

    protected static int calculateBlocksToReplace(float temperature) {
        if (temperature < 0.2f) {
            return 1;
        }
        return temperature < 0.5f ? 3 : 5;
    }

    protected static int getSimulationDistance(ServerPlayer player) {
        MinecraftServer server = player.getServer();
        return server != null ? server.getPlayerList().getViewDistance() : 10;
    }

    protected static BlockPos findSnowBlockInRadius(ServerLevel level, BlockPos center, int radius) {
        ServerChunkCache chunkSource = level.getChunkSource();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int chunkZ;
                int chunkX = center.getX() + x >> 4;
                LevelChunk chunk = chunkSource.getChunk(chunkX, chunkZ = center.getZ() + z >> 4, false);
                if (chunk == null) continue;
                for (int y = -5; y <= 5; ++y) {
                    pos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                    if (pos.getY() < level.getMinBuildHeight() || pos.getY() >= level.getMaxBuildHeight() || !chunk.getBlockState((BlockPos)pos).is(SSPTags.Blocks.MELTABLE)) continue;
                    return pos.immutable();
                }
            }
        }
        return null;
    }

    private static void iterateChunkColumns(ServerLevel level, ChunkPos chunkPos, BiConsumer<BlockPos.MutableBlockPos, BlockState> action) {
        int minY = level.getMinBuildHeight();
        int baseX = chunkPos.getMinBlockX();
        int maxX = chunkPos.getMaxBlockX();
        int baseZ = chunkPos.getMinBlockZ();
        int maxZ = chunkPos.getMaxBlockZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int worldX = baseX; worldX <= maxX; ++worldX) {
            for (int worldZ = baseZ; worldZ <= maxZ; ++worldZ) {
                CommonSnowBlockFeature.columnsLogic(level, action, worldX, worldZ, minY, mutable);
            }
        }
    }

    private static void columnsLogic(ServerLevel level, BiConsumer<BlockPos.MutableBlockPos, BlockState> action, int worldX, int worldZ, int minY, BlockPos.MutableBlockPos mutable) {
        int topY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, worldX, worldZ);
        CommonSnowBlockFeature.checkHeight(level, action, worldX, worldZ, minY, mutable, topY);
        BlockPos noLeavesPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(worldX, 0, worldZ));
        if (noLeavesPos.getY() != topY) {
            int nlTopY = noLeavesPos.getY();
            CommonSnowBlockFeature.checkHeight(level, action, worldX, worldZ, minY, mutable, nlTopY);
        }
    }

    private static void checkHeight(ServerLevel level, BiConsumer<BlockPos.MutableBlockPos, BlockState> action, int worldX, int worldZ, int minY, BlockPos.MutableBlockPos mutable, int nlTopY) {
        int nlStart = nlTopY + 1;
        int nlEnd = Math.max(minY, nlTopY - 8);
        for (int y = nlStart; y >= nlEnd; --y) {
            mutable.set(worldX, y, worldZ);
            BlockState state = level.getBlockState((BlockPos)mutable);
            action.accept(mutable, state);
        }
    }

    private static void sampleRandomChunkColumns(ServerLevel level, ChunkPos chunkPos, int attempts, BiConsumer<BlockPos.MutableBlockPos, BlockState> action) {
        int minY = level.getMinBuildHeight();
        int baseX = chunkPos.getMinBlockX();
        int baseZ = chunkPos.getMinBlockZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        RandomSource random = level.random;
        for (int i = 0; i < attempts; ++i) {
            int worldX = baseX + random.nextInt(16);
            int worldZ = baseZ + random.nextInt(16);
            CommonSnowBlockFeature.columnsLogic(level, action, worldX, worldZ, minY, mutable);
        }
    }

    public static boolean isSnowStormAt(ServerLevel level, ChunkPos pos) {
        if (level instanceof ISnowStormLevel) {
            ISnowStormLevel stormLevel = (ISnowStormLevel)level;
            return stormLevel.sereneseasonsplus$isSnowStormAt(pos);
        }
        return false;
    }

    public static int getSnowStormIntensity(ServerLevel level, ChunkPos pos) {
        if (level instanceof ISnowStormLevel) {
            ISnowStormLevel stormLevel = (ISnowStormLevel)level;
            return stormLevel.sereneseasonsplus$getSnowStormIntensity(pos);
        }
        return 0;
    }

    protected static void clearSnowAndIce(ServerLevel level, ChunkPos chunkPos) {
        CommonSnowBlockFeature.iterateChunkColumns(level, chunkPos, (pos, state) -> {
            if (state.is(Blocks.SNOW) || state.is(Blocks.SNOW_BLOCK)) {
                CommonSnowBlockFeature.clearIfChanged(level, (BlockPos)pos, false);
            } else if (state.is(Blocks.ICE)) {
                CommonSnowBlockFeature.clearIfChanged(level, (BlockPos)pos, true);
            }
        });
    }

    private static void performStartupCatchUp(ServerLevel level) {
        Season.SubSeason currentSeason = EnvironmentHelper.getCurrentSeason();
        if (currentSeason == null) {
            currentSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        }
        int day = SeasonHelper.getSeasonState((Level)level).getDay();
        LayerBounds bounds = CommonSnowBlockFeature.getSeasonalLayerBounds(currentSeason, day);
        ServerChunkCache chunkSource = level.getChunkSource();
        for (ServerPlayer player : level.players()) {
            BlockPos center = player.blockPosition();
            int view = CommonSnowBlockFeature.getSimulationDistance(player);
            int pcx = center.getX() >> 4;
            int pcz = center.getZ() >> 4;
            for (int dx = -view; dx <= view; ++dx) {
                for (int dz = -view; dz <= view; ++dz) {
                    int cx = pcx + dx;
                    int cz = pcz + dz;
                    LevelChunk access = chunkSource.getChunk(cx, cz, false);
                    if (!(access instanceof LevelChunk)) continue;
                    LevelChunk lc = access;
                    ISnowTrackedChunk tracked = (ISnowTrackedChunk)lc;
                    if (bounds != null) {
                        boolean allowPile;
                        boolean hasSnow;
                        boolean pending = HANDLER.shouldApplySnow(level, lc.getPos());
                        boolean bl = hasSnow = tracked.sereneseasonsplus$getSnowCount() > 0;
                        if (!pending && !hasSnow || hasSnow && tracked.sereneseasonsplus$hasReceivedSnowLayerThisStorm()) continue;
                        if (pending) {
                            tracked.sereneseasonsplus$setShouldApplyInitialSnow(true);
                            tracked.sereneseasonsplus$willReceiveSnow(true);
                        }
                        boolean isRainingHere = EnvironmentHelper.isRainning(level, lc.getPos().getMiddleBlockPosition(65));
                        int sc = tracked.sereneseasonsplus$getSnowCount();
                        boolean bl2 = allowPile = sc < 1 || sc > 1 || sc == 1 && !isRainingHere;
                        if (!allowPile) continue;
                        CommonSnowBlockFeature.enqueueChunkForSnowApply(lc.getPos(), currentSeason);
                        continue;
                    }
                    CommonSnowBlockFeature.enqueueChunkForSnowMelt(lc.getPos(), true);
                }
            }
        }
    }

    public static LayerBounds getSeasonalLayerBounds(Season.SubSeason subSeason, int day) {
        return switch (subSeason) {
            case Season.SubSeason.EARLY_WINTER -> {
                if (day >= 6) {
                    yield new LayerBounds(1, 3);
                }
                yield null;
            }
            case Season.SubSeason.MID_WINTER -> new LayerBounds(3, 5);
            case Season.SubSeason.LATE_WINTER -> new LayerBounds(5, 7);
            case Season.SubSeason.EARLY_SPRING -> {
                if (day < 4) {
                    yield new LayerBounds(1, Math.max(1, 5 - day));
                }
                yield null;
            }
            default -> null;
        };
    }

    public static void onServerStarting(int config, boolean snowStorm) {
        tickThresholdSnowReplacer = config;
        tickCounter = 0;
        playerPositions.clear();
        tickCounter = 0;
        snowStormEnabled = snowStorm;
        ChunkQueue.clear();
        counterTime = 0;
    }

    public static void onServerStopping() {
        playerPositions.clear();
        tickCounter = 0;
        ChunkQueue.clear();
        counterTime = 0;
    }

    public static void onConfigReload(int config, boolean snowStorm) {
        tickThresholdSnowReplacer = config;
        snowStormEnabled = snowStorm;
    }

    public static void onSeasonChange(ServerLevel level) {
        ChunkQueue.clear();
        ServerChunkCache source = level.getChunkSource();
        for (ServerPlayer player : level.players()) {
            int view = CommonSnowBlockFeature.getSimulationDistance(player);
            ChunkPos pc = new ChunkPos(player.blockPosition());
            for (int dx = -view; dx <= view; ++dx) {
                for (int dz = -view; dz <= view; ++dz) {
                    LevelChunk access = source.getChunk(pc.x + dx, pc.z + dz, false);
                    if (access == null) continue;
                    ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
                    tracked.sereneseasonsplus$willReceiveSnow(false);
                    tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(true);
                }
            }
        }
        CommonSnowBlockFeature.performStartupCatchUp(level);
    }

    private static void placeSingleLayerNoClimb(ServerLevel level, BlockPos pos) {
        BlockState snow;
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.SNOW) && state.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            int layers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
            if (layers < 8) {
                CommonSnowBlockFeature.setSnowLayersIfChanged(level, pos, layers + 1, false);
            }
        } else if (level.isEmptyBlock(pos) && (snow = Blocks.SNOW.defaultBlockState()).canSurvive((LevelReader)level, pos)) {
            CommonSnowBlockFeature.setSnowLayersIfChanged(level, pos, 1, true);
        }
    }

    private static void placeRandomLayersNoClimb(ServerLevel level, BlockPos pos, int minLayers, int maxLayers) {
        BlockState snow;
        if (maxLayers < minLayers) {
            int t = maxLayers;
            maxLayers = minLayers;
            minLayers = t;
        }
        minLayers = Mth.clamp((int)minLayers, (int)1, (int)8);
        maxLayers = Mth.clamp((int)maxLayers, (int)1, (int)8);
        RandomSource rng = level.random;
        int add = maxLayers == minLayers ? minLayers : rng.nextInt(minLayers, maxLayers + 1);
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.SNOW) && state.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            int layers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
            if (layers < 8) {
                int newLayers = Mth.clamp((int)(layers + add), (int)1, (int)8);
                CommonSnowBlockFeature.setSnowLayersIfChanged(level, pos, newLayers, false);
            }
        } else if (level.isEmptyBlock(pos) && (snow = Blocks.SNOW.defaultBlockState()).canSurvive((LevelReader)level, pos)) {
            int startLayers = Mth.clamp((int)add, (int)1, (int)8);
            CommonSnowBlockFeature.setSnowLayersIfChanged(level, pos, startLayers, true);
        }
    }

    private static boolean setSnowLayersIfChanged(ServerLevel level, BlockPos pos, int targetLayers, boolean allowPlace) {
        BlockState state = level.getBlockState(pos);
        if (state.is(Blocks.SNOW) && state.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            int current = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
            if (current == targetLayers) {
                return false;
            }
            BlockState newState = (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(targetLayers));
            return level.setBlock(pos, newState, 2);
        }
        if (allowPlace && (level.isEmptyBlock(pos) || state.canBeReplaced())) {
            BlockState snow = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(Mth.clamp((int)targetLayers, (int)1, (int)8)));
            if (!snow.canSurvive((LevelReader)level, pos)) {
                return false;
            }
            return level.setBlock(pos, snow, 2);
        }
        return false;
    }

    private static boolean setBlockIfDifferent(ServerLevel level, BlockPos pos, BlockState wanted, boolean knownShape) {
        BlockState current = level.getBlockState(pos);
        if (current.equals(wanted)) {
            return false;
        }
        int flags = 2 | (knownShape ? 16 : 0);
        return level.setBlock(pos, wanted, flags);
    }

    private static boolean clearIfChanged(ServerLevel level, BlockPos pos, boolean toWater) {
        BlockState wanted = toWater ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
        BlockState current = level.getBlockState(pos);
        if (current.is(wanted.getBlock())) {
            return false;
        }
        return level.setBlock(pos, wanted, 34);
    }

    static {
        tickThresholdSnowReplacerForHotSeasons = 30;
        tickCounter = 0;
        HANDLER = new DefaultSnowEnvironmentHandler();
        snowStormIntensity = 0;
        isSnowStorming = false;
        didStartupCatchUp = false;
        counterTime = 0;
    }

    public record LayerBounds(int minLayers, int maxLayers) {
    }
}

