/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.SnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.storage.ChunkQueue;
import com.Gabou.sereneseasonsplus.storage.SnowSavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import com.Gabou.sereneseasonsplus.util.SnowUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class DefaultSnowEnvironmentHandler
implements SnowEnvironmentHandler {
    private final Map<ResourceKey<Level>, SnowData> perLevelData = new HashMap<ResourceKey<Level>, SnowData>();

    private SnowData data(ServerLevel level) {
        return this.perLevelData.computeIfAbsent((ResourceKey<Level>)level.dimension(), k -> {
            SnowData d = new SnowData();
            SnowSavedData store = SnowSavedData.get(level);
            d.winterId = store.winterId;
            d.stormCount = store.stormCount;
            d.stormActive = store.stormActive;
            d.pendingChunks.addAll(store.pendingChunks);
            d.observedChunks.addAll(store.observedChunks);
            d.lastBlanketStormCount = store.lastBlanketStormCount;
            return d;
        });
    }

    private void persist(ServerLevel level, SnowData d) {
        SnowSavedData store = SnowSavedData.get(level);
        store.winterId = d.winterId;
        store.stormCount = d.stormCount;
        store.stormActive = d.stormActive;
        store.pendingChunks.clear();
        store.pendingChunks.addAll(d.pendingChunks);
        store.observedChunks.clear();
        store.observedChunks.addAll(d.observedChunks);
        store.lastBlanketStormCount = d.lastBlanketStormCount;
        store.setDirty();
    }

    @Override
    public int getBlocksToReplace(ServerLevel level, BlockPos playerPos) {
        Season.SubSeason currentSubSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        float temperature = SnowUtils.getCachedBiomeTemperature((Level)level, playerPos, currentSubSeason);
        if (temperature >= 0.15f) {
            return CommonSnowBlockFeature.calculateBlocksToReplace(temperature);
        }
        return 0;
    }

    @Override
    public void resetWinterState(ServerLevel level, int winterId) {
        SnowData data = this.data(level);
        if (data.winterId == winterId) {
            return;
        }
        data.winterId = winterId;
        data.stormCount = 0;
        data.stormActive = false;
        data.pendingChunks.clear();
        data.observedChunks.clear();
        data.lastBlanketStormCount = 0;
        this.persist(level, data);
    }

    @Override
    public void onRainChanged(ServerLevel level, ChunkPos chunkPos, boolean isRaining, ISnowTrackedChunk trackedChunk) {
        SnowData data = this.data(level);
        long key = chunkPos.toLong();
        if (isRaining) {
            boolean snowySeason = EnvironmentHelper.isSnowySeason();
            if (snowySeason && !data.stormActive) {
                data.stormActive = true;
                ++data.stormCount;
            } else if (!snowySeason) {
                data.stormActive = false;
            }
            if (snowySeason && data.pendingChunks.add(key)) {
                data.observedChunks.add(key);
            }
            if (snowySeason) {
                trackedChunk.sereneseasonsplus$setShouldApplyInitialSnow(true);
                trackedChunk.sereneseasonsplus$willReceiveSnow(true);
                ChunkQueue.enqueueScheduled(chunkPos);
            }
        } else if (!EnvironmentHelper.isRainning(level, chunkPos.getMiddleBlockPosition(65))) {
            boolean wasActive = data.stormActive;
            data.stormActive = false;
            if (wasActive && data.stormCount > 1 && data.lastBlanketStormCount < data.stormCount) {
                this.blanketApplyLoadedChunks(level);
                data.lastBlanketStormCount = data.stormCount;
            }
        }
        this.persist(level, data);
    }

    @Override
    public boolean shouldApplySnow(ServerLevel level, ChunkPos chunkPos) {
        return this.data((ServerLevel)level).pendingChunks.contains(chunkPos.toLong());
    }

    @Override
    public void onSnowApplied(ServerLevel level, ChunkPos chunkPos, boolean success) {
        SnowData data = this.data(level);
        long key = chunkPos.toLong();
        if (success) {
            data.pendingChunks.remove(key);
        }
        data.observedChunks.add(key);
        this.persist(level, data);
    }

    @Override
    public int getSnowStormsThisWinter(ServerLevel level) {
        return this.data((ServerLevel)level).stormCount;
    }

    @Override
    public boolean hasChunkSeenSnow(ServerLevel level, ChunkPos chunkPos) {
        return this.data((ServerLevel)level).observedChunks.contains(chunkPos.toLong());
    }

    @Override
    public void clear(ServerLevel level) {
        SnowData d = this.perLevelData.remove(level.dimension());
        if (d != null) {
            this.persist(level, d);
        }
    }

    private void blanketApplyLoadedChunks(ServerLevel level) {
        if (!EnvironmentHelper.isSnowySeason()) {
            return;
        }
        Season.SubSeason current = EnvironmentHelper.getCurrentSeason();
        if (current == null) {
            return;
        }
        ServerChunkCache chunkSource = level.getChunkSource();
        for (ServerPlayer player : level.players()) {
            int view = level.getServer() != null ? level.getServer().getPlayerList().getViewDistance() : 10;
            BlockPos center = player.blockPosition();
            int pcx = center.getX() >> 4;
            int pcz = center.getZ() >> 4;
            for (int dx = -view; dx <= view; ++dx) {
                for (int dz = -view; dz <= view; ++dz) {
                    int cx = pcx + dx;
                    int cz = pcz + dz;
                    LevelChunk access = chunkSource.getChunk(cx, cz, false);
                    if (!(access instanceof LevelChunk)) continue;
                    LevelChunk lc = access;
                    CommonSnowBlockFeature.enqueueChunkForSnowApply(lc.getPos(), current);
                }
            }
        }
    }

    private static final class SnowData {
        int winterId = -1;
        int stormCount = 0;
        boolean stormActive = false;
        final Set<Long> pendingChunks = new HashSet<Long>();
        final Set<Long> observedChunks = new HashSet<Long>();
        int lastBlanketStormCount = 0;

        private SnowData() {
        }
    }
}

