/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features.logic;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.logic.WinterFlags;
import com.Gabou.sereneseasonsplus.storage.ChunkQueue;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;

public final class SnowLogic {
    private SnowLogic() {
    }

    public static void evaluate(ServerLevel level, Season.SubSeason currentSeason, ISeasonState seasonState, ISnowTrackedChunk tracked, ChunkPos chunkPos, boolean isLoadEvent) {
        CommonSnowBlockFeature.LayerBounds bounds;
        Season.SubSeason prevSeason = tracked.sereneseasonsplus$getLastSeason();
        if (prevSeason != currentSeason) {
            tracked.sereneseasonsplus$setLastSeason(currentSeason);
        }
        boolean wasRaining = tracked.sereneseasonsplus$wasRaining();
        boolean isRaining = EnvironmentHelper.isRainning(level, chunkPos.getMiddleBlockPosition(65));
        if (isRaining != wasRaining) {
            CommonSnowBlockFeature.HANDLER.onRainChanged(level, chunkPos, isRaining, tracked);
            tracked.sereneseasonsplus$incrementWasRaining(isRaining);
            if (!isRaining) {
                if (tracked.sereneseasonsplus$hasReceivedSnowLayerThisStorm()) {
                    WinterFlags.markFirstStormFinished(level, EnvironmentHelper.getCurrentWinterId());
                }
                tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(false);
            }
        }
        int globalWinterId = EnvironmentHelper.getCurrentWinterId();
        if (tracked.sereneseasonsplus$getLastWinterId() != globalWinterId) {
            boolean seenThisWinter;
            tracked.sereneseasonsplus$setLastWinterId(globalWinterId);
            tracked.sereneseasonsplus$setSnowCount(-1);
            tracked.sereneseasonsplus$setHasAppliedInitialSnow(false);
            tracked.sereneseasonsplus$setShouldApplyInitialSnow(false);
            tracked.sereneseasonsplus$willReceiveSnow(false);
            tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(false);
            boolean bl = seenThisWinter = CommonSnowBlockFeature.HANDLER.hasChunkSeenSnow(level, chunkPos) || tracked.sereneseasonsplus$getSnowCount() > 0;
            if (!seenThisWinter) {
                ChunkQueue.enqueueMelt(chunkPos, true);
            }
            if (!isLoadEvent) {
                return;
            }
        }
        if ((bounds = CommonSnowBlockFeature.getSeasonalLayerBounds(currentSeason, seasonState.getDay())) != null) {
            boolean applyNow;
            int sc;
            boolean hasSnowHistory;
            boolean pendingSnow = CommonSnowBlockFeature.HANDLER.shouldApplySnow(level, chunkPos);
            boolean bl = hasSnowHistory = pendingSnow || CommonSnowBlockFeature.HANDLER.hasChunkSeenSnow(level, chunkPos) || tracked.sereneseasonsplus$getSnowCount() > 0;
            if (pendingSnow) {
                tracked.sereneseasonsplus$setShouldApplyInitialSnow(true);
            }
            boolean firstTimeHere = (sc = tracked.sereneseasonsplus$getSnowCount()) <= 0;
            boolean firstStormFinished = WinterFlags.hasFirstStormFinished(level, globalWinterId);
            boolean okForInitialSpread = firstStormFinished && !isRaining;
            boolean needsInitial = firstTimeHere && !tracked.sereneseasonsplus$hasAppliedInitialSnow();
            boolean bl2 = applyNow = (pendingSnow && firstTimeHere || tracked.sereneseasonsplus$shouldReceiveSnow()) && okForInitialSpread && needsInitial && hasSnowHistory;
            if (applyNow) {
                ChunkQueue.enqueueApply(chunkPos, currentSeason);
                tracked.sereneseasonsplus$willReceiveSnow(true);
                if (pendingSnow) {
                    tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(true);
                } else if (okForInitialSpread && needsInitial) {
                    tracked.sereneseasonsplus$setHasAppliedInitialSnow(true);
                }
            }
        } else {
            boolean longGap = prevSeason == null || Math.abs(currentSeason.ordinal() - prevSeason.ordinal()) != 1 || EnvironmentHelper.isHotSeason();
            ChunkQueue.enqueueMelt(chunkPos, longGap);
        }
    }
}

