/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.mixin;

import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import sereneseasons.api.season.Season;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerSnowMixin {
    private static final String SSP = "SereneSeasonsPlus";

    @Inject(method={"write"}, at={@At(value="RETURN")}, cancellable=true)
    private static void ssp$write(ServerLevel level, ChunkAccess access, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag root = (CompoundTag)cir.getReturnValue();
        if (access instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
            CompoundTag tag = new CompoundTag();
            tag.putInt("SnowCount", tracked.sereneseasonsplus$getSnowCount());
            tag.putBoolean("HasAppliedInitialSnow", tracked.sereneseasonsplus$hasAppliedInitialSnow());
            tag.putBoolean("ShouldApplyInitialSnow", tracked.sereneseasonsplus$shouldApplyInitialSnow());
            tag.putBoolean("WasRaining", tracked.sereneseasonsplus$wasRaining());
            tag.putBoolean("HasReceivedSnowLayerThisStorm", tracked.sereneseasonsplus$hasReceivedSnowLayerThisStorm());
            tag.putBoolean("WillReceiveSnow", tracked.sereneseasonsplus$shouldReceiveSnow());
            if (tracked.sereneseasonsplus$getLastSeason() != null) {
                tag.putString("LastSeason", tracked.sereneseasonsplus$getLastSeason().name());
            }
            if (tag.contains("LastWinterId")) {
                tracked.sereneseasonsplus$setLastWinterId(tag.getInt("LastWinterId"));
            }
            root.put(SSP, (Tag)tag);
            cir.setReturnValue((Object)root);
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void ssp$read(ServerLevel level, PoiManager poi, RegionStorageInfo storageInfo, ChunkPos pos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> cir) {
        ChunkAccess access = (ChunkAccess)cir.getReturnValue();
        if (access instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
            CompoundTag tag = nbt.getCompound(SSP);
            if (!tag.isEmpty()) {
                tracked.sereneseasonsplus$setSnowCount(tag.getInt("SnowCount"));
                tracked.sereneseasonsplus$setHasAppliedInitialSnow(tag.getBoolean("HasAppliedInitialSnow"));
                tracked.sereneseasonsplus$setShouldApplyInitialSnow(tag.getBoolean("ShouldApplyInitialSnow"));
                tracked.sereneseasonsplus$incrementWasRaining(tag.getBoolean("WasRaining"));
                tracked.sereneseasonsplus$setHasReceivedSnowLayerThisStorm(tag.getBoolean("HasReceivedSnowLayerThisStorm"));
                tracked.sereneseasonsplus$willReceiveSnow(tag.getBoolean("WillReceiveSnow"));
                tag.putInt("LastWinterId", tracked.sereneseasonsplus$getLastWinterId());
                if (tag.contains("LastSeason")) {
                    try {
                        tracked.sereneseasonsplus$setLastSeason(Season.SubSeason.valueOf((String)tag.getString("LastSeason")));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

