/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.storage;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class SnowSavedData
extends SavedData {
    public int winterId = -1;
    public int stormCount = 0;
    public boolean stormActive = false;
    public final Set<Long> pendingChunks = new HashSet<Long>();
    public final Set<Long> observedChunks = new HashSet<Long>();
    public int lastBlanketStormCount = 0;

    public static SnowSavedData load(CompoundTag tag, HolderLookup.Provider provider) {
        SnowSavedData data = new SnowSavedData();
        if (tag == null) {
            return data;
        }
        data.winterId = tag.getInt("WinterId");
        data.stormCount = tag.getInt("StormCount");
        data.stormActive = tag.getBoolean("StormActive");
        data.lastBlanketStormCount = tag.getInt("LastBlanketStormCount");
        for (long v : tag.getLongArray("PendingChunks")) {
            data.pendingChunks.add(v);
        }
        for (long v : tag.getLongArray("ObservedChunks")) {
            data.observedChunks.add(v);
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("WinterId", this.winterId);
        tag.putInt("StormCount", this.stormCount);
        tag.putBoolean("StormActive", this.stormActive);
        tag.putInt("LastBlanketStormCount", this.lastBlanketStormCount);
        tag.putLongArray("PendingChunks", this.pendingChunks.stream().mapToLong(Long::longValue).toArray());
        tag.putLongArray("ObservedChunks", this.observedChunks.stream().mapToLong(Long::longValue).toArray());
        return tag;
    }

    public static SnowSavedData get(ServerLevel level) {
        SavedData.Factory factory = new SavedData.Factory(SnowSavedData::new, SnowSavedData::load, DataFixTypes.LEVEL);
        return (SnowSavedData)level.getDataStorage().computeIfAbsent(factory, "ssp_snow_data");
    }
}

