/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.season.Season;

public class SnowUtils {
    private static final Logger LOGGER = LogManager.getLogger((String)"SnowUtils");
    private static final Map<String, Float> biomeTemperatures = new HashMap<String, Float>();

    public static float getCachedBiomeTemperature(Level level, BlockPos pos, Season.SubSeason currentSubSeason) {
        float newTemperature;
        Holder biomeHolder = level.getBiome(pos);
        String biomeName = biomeHolder.unwrapKey().map(Object::toString).orElse("unknown");
        if (!biomeTemperatures.containsKey(biomeName)) {
            float temperature = SnowUtils.getBiomeTemperature((Holder<Biome>)biomeHolder);
            if (SnowUtils.isWinterSubSeason(currentSubSeason) && temperature > 0.14f) {
                temperature = 0.14f;
            }
            biomeTemperatures.put(biomeName, Float.valueOf(temperature));
            return temperature;
        }
        float cachedTemperature = biomeTemperatures.get(biomeName).floatValue();
        if (!SnowUtils.isWinterSubSeason(currentSubSeason) && ((newTemperature = SnowUtils.getBiomeTemperature((Holder<Biome>)biomeHolder)) != cachedTemperature || cachedTemperature <= 0.14f)) {
            biomeTemperatures.put(biomeName, Float.valueOf(newTemperature));
            return newTemperature;
        }
        if (SnowUtils.isWinterSubSeason(currentSubSeason) && cachedTemperature > 0.14f) {
            cachedTemperature = 0.14f;
            biomeTemperatures.put(biomeName, Float.valueOf(cachedTemperature));
        }
        return cachedTemperature;
    }

    public static float getBiomeTemperature(Holder<Biome> biomeHolder) {
        Biome biome = (Biome)biomeHolder.value();
        return biome.getBaseTemperature();
    }

    private static boolean isWinterSubSeason(Season.SubSeason subSeason) {
        return subSeason == Season.SubSeason.EARLY_WINTER || subSeason == Season.SubSeason.MID_WINTER || subSeason == Season.SubSeason.LATE_WINTER;
    }

    public static void breakOrDecrementLayer(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().execute(() -> SnowUtils.doBreakOrDecrementLayer((Level)serverLevel, pos));
        } else {
            SnowUtils.doBreakOrDecrementLayer(level, pos);
        }
    }

    private static void doBreakOrDecrementLayer(Level level, BlockPos pos) {
        int layers;
        BlockState state = level.getBlockState(pos);
        if (state.hasProperty((Property)BlockStateProperties.LAYERS) && (layers = ((Integer)state.getValue((Property)BlockStateProperties.LAYERS)).intValue()) > 1) {
            BlockState newState = (BlockState)state.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(layers - 1));
            if (!newState.equals(state)) {
                level.setBlock(pos, newState, 34);
            }
            return;
        }
        if (!level.getBlockState(pos).is(Blocks.AIR)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 34);
        }
    }
}

