/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.util;

import com.Gabou.sereneseasonsplus.util.HotSeason;
import com.Gabou.sereneseasonsplus.util.IEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.SnowySeason;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class FabricEnvironmentHelper
implements IEnvironmentHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FabricEnvironmentHelper");
    private Season.SubSeason season;
    private boolean isHotSeason;
    private boolean isSnowySeason;
    private int baseChance = -1;

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public boolean shouldRunMod() {
        return !this.isClient();
    }

    @Override
    public boolean isHotSeason() {
        return this.isHotSeason;
    }

    @Override
    public boolean isSnowySeason() {
        return this.isSnowySeason;
    }

    @Override
    public Season.SubSeason getCurrentSeason() {
        return this.season;
    }

    @Override
    public void onSeasonChange(class_3218 serverLevel) {
        this.season = SeasonHelper.getSeasonState((class_1937)serverLevel).getSubSeason();
        LOGGER.info("Season changed to: {}", (Object)this.season);
        this.isHotSeason = HotSeason.isHotSeason(this.season);
        this.isSnowySeason = SnowySeason.isSnowySeason(this.season);
        this.baseChance = this.getGrassChance(true);
    }

    @Override
    public int getGrassChance(boolean force) {
        if (this.baseChance != -1 || force) {
            return this.baseChance;
        }
        switch (this.season) {
            case EARLY_SUMMER: 
            case LATE_SUMMER: {
                this.baseChance = 300;
                break;
            }
            case MID_SUMMER: {
                this.baseChance = 200;
                break;
            }
            case EARLY_SPRING: 
            case LATE_AUTUMN: {
                this.baseChance = 1200;
                break;
            }
            case MID_SPRING: 
            case MID_AUTUMN: {
                this.baseChance = 800;
                break;
            }
            case LATE_SPRING: 
            case EARLY_AUTUMN: {
                this.baseChance = 600;
            }
        }
        return this.baseChance;
    }
}

