/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.config;

import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.config.SereneExtendedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class SereneExtendedScreen
extends Screen {
    private final Screen parent;
    private boolean snowFeatureEnabled;
    private int tickSnowReplacerThreshold;
    private int maxSnowHeight;
    private EditBox maxReplacerBox;
    private EditBox maxSnowHeightBox;
    private EditBox dayLengthBox;
    private EditBox nightLengthBox;
    private boolean seasonalDaylightCycle;
    private boolean customDayCycle;
    private double customDayLength;
    private double customNightLength;
    private boolean grassFlowerGrowth;
    private Component replacerLabel = Component.m_237113_((String)"Common Feature Threshold:");
    private Component pillerLabel = Component.m_237113_((String)"");
    private Component snowHeightLabel = Component.m_237113_((String)"Max Snow Height (layers):");
    private Component nightLabel = Component.m_237113_((String)"Custom Night Speed:");
    private Component dayLabel = Component.m_237113_((String)"Custom Day Speed:");
    private SereneExtendedList list;

    public SereneExtendedScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Project Atmosphere Config"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.snowFeatureEnabled = (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get();
        this.tickSnowReplacerThreshold = (Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get();
        this.maxSnowHeight = (Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get();
        this.seasonalDaylightCycle = (Boolean)SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.get();
        this.customDayCycle = (Boolean)SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.get();
        this.customDayLength = (Double)SereneExtendedConfig.CUSTOM_DAY_LENGTH.get();
        this.customNightLength = (Double)SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.get();
        this.grassFlowerGrowth = (Boolean)SereneExtendedConfig.GRASS_FLOWER_GROWTH_ENABLED.get();
        int panelW = 420;
        int panelX = (this.f_96543_ - panelW) / 2;
        int top = 40;
        int bottom = this.f_96544_ - 40;
        this.list = new SereneExtendedList(this.f_96541_, panelW, this.f_96544_, top + 20, bottom - 40, 24);
        this.list.m_93507_(panelX);
        this.m_142416_((GuiEventListener)this.list);
        Button snowFeatureBtn = Button.m_253074_((Component)this.toggleLabel("Snow Features", this.snowFeatureEnabled), b -> {
            this.snowFeatureEnabled = !this.snowFeatureEnabled;
            b.m_93666_(this.toggleLabel("Snow Features", this.snowFeatureEnabled));
        }).m_252987_(0, 0, 200, 20).m_253136_();
        this.list.addRow((Component)Component.m_237113_((String)"Snow Features"), new AbstractWidget[]{snowFeatureBtn});
        Button seasonBtn = Button.m_253074_((Component)this.toggleLabel("Seasonal Daylight Cycle", this.seasonalDaylightCycle), b -> {
            this.seasonalDaylightCycle = !this.seasonalDaylightCycle;
            this.customDayCycle = false;
            b.m_93666_(this.toggleLabel("Seasonal Daylight Cycle", this.seasonalDaylightCycle));
        }).m_252987_(0, 0, 200, 20).m_253136_();
        this.list.addRow((Component)Component.m_237113_((String)"Seasonal Daylight Cycle"), new AbstractWidget[]{seasonBtn});
        Button customBtn = Button.m_253074_((Component)this.toggleLabel("Custom Daylight Cycle", this.customDayCycle), b -> {
            this.customDayCycle = !this.customDayCycle;
            this.seasonalDaylightCycle = false;
            b.m_93666_(this.toggleLabel("Custom Daylight Cycle", this.customDayCycle));
        }).m_252987_(0, 0, 200, 20).m_253136_();
        this.list.addRow((Component)Component.m_237113_((String)"Custom Daylight Cycle"), new AbstractWidget[]{customBtn});
        Button grassFlowerBtn = Button.m_253074_((Component)this.toggleLabel("Grass and Flower Growth", this.grassFlowerGrowth), b -> {
            this.grassFlowerGrowth = !this.grassFlowerGrowth;
            b.m_93666_(this.toggleLabel("Grass and Flower Growth", this.grassFlowerGrowth));
        }).m_252987_(0, 0, 200, 20).m_253136_();
        this.list.addRow((Component)Component.m_237113_((String)"Grass and Flower Growth"), new AbstractWidget[]{grassFlowerBtn});
        this.maxReplacerBox = new EditBox(this.f_96547_, 0, 0, 200, 20, (Component)Component.m_237119_());
        this.maxReplacerBox.m_94144_(Integer.toString(this.tickSnowReplacerThreshold));
        this.list.addRow((Component)Component.m_237113_((String)"Common Feature Threshold"), new AbstractWidget[]{this.maxReplacerBox});
        this.maxSnowHeightBox = new EditBox(this.f_96547_, 0, 0, 200, 20, (Component)Component.m_237119_());
        this.maxSnowHeightBox.m_94144_(Integer.toString(this.maxSnowHeight));
        this.list.addRow((Component)Component.m_237113_((String)"Max Snow Height (layers)"), new AbstractWidget[]{this.maxSnowHeightBox});
        this.nightLengthBox = new EditBox(this.f_96547_, 0, 0, 200, 20, (Component)Component.m_237119_());
        this.nightLengthBox.m_94144_(Double.toString(this.customNightLength));
        this.list.addRow((Component)Component.m_237113_((String)"Custom Night Speed"), new AbstractWidget[]{this.nightLengthBox});
        this.dayLengthBox = new EditBox(this.f_96547_, 0, 0, 200, 20, (Component)Component.m_237119_());
        this.dayLengthBox.m_94144_(Double.toString(this.customDayLength));
        this.list.addRow((Component)Component.m_237113_((String)"Custom Day Speed"), new AbstractWidget[]{this.dayLengthBox});
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), b -> {
            this.saveChanges();
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(panelX + (panelW - 200) / 2, bottom - 30, 200, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        int panelW = 480;
        int panelX = (this.f_96543_ - panelW) / 2;
        int top = 40;
        int bottom = this.f_96544_ - 40;
        g.m_280509_(panelX - 4, top - 4, panelX + panelW + 4, bottom, -1442840576);
        g.m_280056_(this.f_96547_, "Serene Seasons Plus", panelX + 6, top - 14, 0xFFFFFF, false);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private Component toggleLabel(String name, boolean enabled) {
        return Component.m_237113_((String)(name + ": " + (enabled ? "ON" : "OFF")));
    }

    private void saveChanges() {
        MutableComponent errorMessage;
        int parsed2 = this.tickSnowReplacerThreshold;
        int parsedSnowHeight = this.maxSnowHeight;
        double parsed3 = this.customDayLength;
        double parsed4 = this.customNightLength;
        try {
            parsed2 = Integer.parseInt(this.maxReplacerBox.m_94155_());
            parsedSnowHeight = Integer.parseInt(this.maxSnowHeightBox.m_94155_());
            errorMessage = null;
        }
        catch (NumberFormatException ignored) {
            errorMessage = Component.m_237113_((String)"Invalid number for a Snow setting.");
        }
        try {
            parsed3 = Double.parseDouble(this.dayLengthBox.m_94155_());
            parsed4 = Double.parseDouble(this.nightLengthBox.m_94155_());
            errorMessage = null;
        }
        catch (NumberFormatException ignored) {
            errorMessage = Component.m_237113_((String)"Invalid number for one of the DayCycle Speeds.");
        }
        SereneExtendedConfig.TICK_SNOW_REPLACER.set((Object)parsed2);
        SereneExtendedConfig.SNOWSTORM_ENABLED.set((Object)this.snowFeatureEnabled);
        SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.set((Object)parsedSnowHeight);
        SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.set((Object)this.seasonalDaylightCycle);
        SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.set((Object)this.customDayCycle);
        SereneExtendedConfig.CUSTOM_DAY_LENGTH.set((Object)parsed3);
        SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.set((Object)parsed4);
        SereneExtendedConfig.GRASS_FLOWER_GROWTH_ENABLED.set((Object)this.grassFlowerGrowth);
        try {
            SereneExtendedScreen.saveCommonConfigForMod("projectatmosphere");
            errorMessage = null;
        }
        catch (Exception e) {
            errorMessage = Component.m_237113_((String)("Failed to save config: " + e.getMessage()));
        }
    }

    private static void saveCommonConfigForMod(String modId) {
        Set set = (Set)ConfigTracker.INSTANCE.configSets().get(ModConfig.Type.COMMON);
        if (set == null) {
            return;
        }
        for (ModConfig cfg : set) {
            if (!cfg.getModId().equals(modId)) continue;
            cfg.save();
            return;
        }
    }

    public void m_7379_() {
        this.m_93692_(false);
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.list != null && this.list.m_6375_(x, y, button)) {
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_7933_(int key, int sc, int mods) {
        if (this.list != null && this.list.m_7933_(key, sc, mods)) {
            return true;
        }
        if (this.maxReplacerBox != null && this.maxReplacerBox.m_7933_(key, sc, mods)) {
            return true;
        }
        if (this.maxSnowHeightBox != null && this.maxSnowHeightBox.m_7933_(key, sc, mods)) {
            return true;
        }
        if (this.nightLengthBox != null && this.nightLengthBox.m_7933_(key, sc, mods)) {
            return true;
        }
        if (this.dayLengthBox != null && this.dayLengthBox.m_7933_(key, sc, mods)) {
            return true;
        }
        return super.m_7933_(key, sc, mods);
    }

    public boolean m_5534_(char c, int mods) {
        if (this.list != null && this.list.m_5534_(c, mods)) {
            return true;
        }
        if (this.maxReplacerBox != null && this.maxReplacerBox.m_5534_(c, mods)) {
            return true;
        }
        if (this.maxSnowHeightBox != null && this.maxSnowHeightBox.m_5534_(c, mods)) {
            return true;
        }
        if (this.nightLengthBox != null && this.nightLengthBox.m_5534_(c, mods)) {
            return true;
        }
        if (this.dayLengthBox != null && this.dayLengthBox.m_5534_(c, mods)) {
            return true;
        }
        return super.m_5534_(c, mods);
    }
}

