/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.SereneSeasonsPlusForge;
import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.DefaultSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import net.Gabou.gaboulibs.storage.SnowRecord;
import net.Gabou.gaboulibs.util.SnowGenerator;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import sereneseasons.season.SeasonHooks;

public class ForgeSnowEnvironmentHandler
extends DefaultSnowEnvironmentHandler {
    @Override
    public int getBlocksToReplace(ServerLevel level, BlockPos playerPos) {
        if (!SereneSeasonsPlusForge.isProjectAtmosphereLoaded) {
            float temperature = SeasonHooks.getBiomeTemperature((Level)level, (Holder)level.m_204166_(playerPos), (BlockPos)playerPos);
            return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (BlockPos)playerPos) ? CommonSnowBlockFeature.calculateBlocksToReplace(temperature) : 0;
        }
        float temperature = ForecastOrchestrator.getCurrentTemperature((BiomeInstanceKey)new BiomeInstanceKey(((ResourceKey)level.m_204166_(playerPos).m_203543_().get()).m_135782_(), playerPos), (long)level.m_46468_());
        return temperature >= 0.5f ? CommonSnowBlockFeature.calculateBlocksToReplace1(temperature) : -level.f_46441_.m_216339_(2, 6);
    }

    @Override
    public boolean isColdEnoughForSnow(ServerLevel level, BlockPos pos) {
        if (!SereneSeasonsPlusForge.isProjectAtmosphereLoaded) {
            return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (BlockPos)pos);
        }
        float temperature = ForecastOrchestrator.getCurrentTemperature((BiomeInstanceKey)new BiomeInstanceKey(((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_(), pos), (long)level.m_46468_());
        return temperature < 0.5f;
    }

    @Override
    public void onRainCloudSpawned(ServerLevel level, int hashCode) {
        if (!EnvironmentHelper.isSnowySeason()) {
            return;
        }
        DefaultSnowEnvironmentHandler.SnowData data = this.getOrCreateData(level);
        if (data == null) {
            return;
        }
        data.activeStorms.add(hashCode);
    }

    @Override
    public void onRainCloudDespawned(ServerLevel level, int hashCode) {
        DefaultSnowEnvironmentHandler.SnowData data = this.getOrCreateData(level);
        if (data == null || !data.activeStorms.contains(hashCode)) {
            return;
        }
        data.activeStorms.remove(hashCode);
        SnowHistorySavedData hist = SnowHistorySavedData.get();
        SnowRecord rec = SnowGenerator.generateStormRecord((RandomSource)level.f_46441_);
        ++data.stormCount;
        hist.currentStormId = data.stormCount;
        hist.snowHistory.put(hist.currentStormId, rec);
        SnowHistorySavedData.get().snowHistory.put(hist.currentStormId, rec);
        hist.m_77762_();
        this.persist(level, data);
    }
}

