/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.storage;

import java.util.HashMap;
import java.util.Map;
import net.Gabou.gaboulibs.storage.SnowRecord;
import net.Gabou.gaboulibs.util.WorldContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class SnowHistorySavedData
extends SavedData {
    private static volatile SnowHistorySavedData INSTANCE;
    public int currentStormId = 0;
    public final Map<Integer, SnowRecord> snowHistory = new HashMap<Integer, SnowRecord>();

    public static SnowHistorySavedData load(CompoundTag tag) {
        SnowHistorySavedData data = new SnowHistorySavedData();
        if (tag == null) {
            return data;
        }
        data.currentStormId = tag.m_128451_("CurrentStormId");
        ListTag list = tag.m_128437_("SnowHistory", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            int id = entry.m_128451_("Id");
            SnowRecord rec = SnowRecord.fromTag((CompoundTag)entry.m_128469_("Record"));
            data.snowHistory.put(id, rec);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("CurrentStormId", this.currentStormId);
        ListTag list = new ListTag();
        for (Map.Entry<Integer, SnowRecord> e : this.snowHistory.entrySet()) {
            CompoundTag entry = new CompoundTag();
            entry.m_128405_("Id", e.getKey().intValue());
            entry.m_128365_("Record", (Tag)e.getValue().toTag());
            list.add((Object)entry);
        }
        tag.m_128365_("SnowHistory", (Tag)list);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnowHistorySavedData get() {
        SnowHistorySavedData inst = INSTANCE;
        if (inst != null) {
            return inst;
        }
        Class<SnowHistorySavedData> clazz = SnowHistorySavedData.class;
        synchronized (SnowHistorySavedData.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
            ServerLevel overworld = WorldContext.getOverworld();
            INSTANCE = overworld != null ? (SnowHistorySavedData)overworld.m_8895_().m_164861_(SnowHistorySavedData::load, SnowHistorySavedData::new, "ssp_snow_history") : new SnowHistorySavedData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void clearCachedInstance() {
        INSTANCE = null;
    }
}

