/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.util;

import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.util.HotSeason;
import com.Gabou.sereneseasonsplus.util.IEnvironmentHelper;
import net.Gabou.gaboulibs.util.SnowySeason;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class ForgeEnvironmentHelper
implements IEnvironmentHelper {
    private static final Logger LOGGER = LogManager.getLogger((String)"ForgeEnvironmentHelper");
    private Season.SubSeason season;
    private boolean isHotSeason;
    private int baseChance = -1;
    private boolean isSnowySeason;

    @Override
    public boolean isClient() {
        return FMLEnvironment.dist.isClient();
    }

    @Override
    public boolean shouldRunMod() {
        return FMLEnvironment.dist.isDedicatedServer() || FMLEnvironment.dist.isClient() && Minecraft.m_91087_().m_91091_();
    }

    @Override
    public boolean isHotSeason() {
        return this.isHotSeason;
    }

    @Override
    public boolean isSnowySeason() {
        return this.isSnowySeason;
    }

    @Override
    public Season.SubSeason getCurrentSeason() {
        return this.season;
    }

    @Override
    public void onSeasonChange(ServerLevel serverLevel) {
        this.season = SeasonHelper.getSeasonState((Level)serverLevel).getSubSeason();
        LOGGER.info("Season changed to: {}", (Object)this.season);
        this.isHotSeason = HotSeason.isHotSeason(this.season);
        this.isSnowySeason = SnowySeason.isSnowySeason((Season.SubSeason)this.season);
        this.baseChance = this.getGrassChance(true);
    }

    @Override
    public int getGrassChance(boolean force) {
        if (this.baseChance != -1 || force) {
            return this.baseChance;
        }
        switch (this.season) {
            case EARLY_SUMMER: 
            case LATE_SUMMER: {
                this.baseChance = 300;
                break;
            }
            case MID_SUMMER: {
                this.baseChance = 200;
                break;
            }
            case EARLY_SPRING: 
            case LATE_AUTUMN: {
                this.baseChance = 1200;
                break;
            }
            case MID_SPRING: 
            case MID_AUTUMN: {
                this.baseChance = 800;
                break;
            }
            case LATE_SPRING: 
            case EARLY_AUTUMN: {
                this.baseChance = 600;
            }
        }
        return this.baseChance;
    }

    @Override
    public boolean isSereneWildLoaded() {
        return ModList.get().isLoaded("serenewild");
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isSnowRealMagicLoaded() {
        return ModList.get().isLoaded("snowrealmagic");
    }

    @Override
    public boolean isGrassFloweringEnabled() {
        return (Boolean)SereneExtendedConfig.GRASS_FLOWER_GROWTH_ENABLED.get();
    }
}

