/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus;

import com.Gabou.sereneseasonsplus.SereneSeasonPlusCommon;
import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.event.SeasonChangeEvent;
import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.FabricAsyncExecutorHandler;
import com.Gabou.sereneseasonsplus.util.FabricEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import com.Gabou.sereneseasonsplus.util.SereneService;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SereneSeasonsPlusFabric
extends SereneSeasonPlusCommon
implements ModInitializer {
    public void onInitialize() {
        LOGGER.info("Initializing Serene Seasons Plus (Fabric)");
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        EnvironmentHelper.init(new FabricEnvironmentHelper());
        SeasonChangeEvent.register();
        ServerChunkEvents.CHUNK_LOAD.register(this::onChunkLoad);
        SereneExtendedConfig.registerReloadListener(this::onConfigReload);
        PlayerBlockBreakEvents.AFTER.register(this::onBlockBreak);
        ServerTickEvents.START_WORLD_TICK.register(this::onWorldTick);
    }

    private void onBlockBreak(class_1937 lvl, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        int activeId;
        if (!(lvl instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)lvl;
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        if (!state.method_27852(class_2246.field_10477) && !state.method_27852(class_2246.field_10491)) {
            return;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        int n = activeId = sd != null ? sd.currentStormId : 0;
        if (activeId <= 0) {
            return;
        }
        class_2818 chunk = level.method_14178().method_12126(pos.method_10263() >> 4, pos.method_10260() >> 4, false);
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        if (tracked.sereneseasonsplus$getDestroyedStormId() != activeId) {
            tracked.sereneseasonsplus$getDestroyedColumns().clear();
            tracked.sereneseasonsplus$setDestroyedStormId(activeId);
        }
        long xz = (long)pos.method_10263() << 32 ^ (long)pos.method_10260() & 0xFFFFFFFFL;
        tracked.sereneseasonsplus$getDestroyedColumns().add(xz);
        tracked.sereneseasonsplus$getSnowColumns().keySet().removeIf(p -> p.method_10263() == pos.method_10263() && p.method_10260() == pos.method_10260());
        chunk.method_65063();
    }

    private void onConfigReload() {
        CommonSnowBlockFeature.onConfigReload(SereneExtendedConfig.TICK_SNOW_REPLACER.get(), SereneExtendedConfig.SNOWSTORM_ENABLED.get(), SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get());
        SereneService.reloadConfig();
    }

    private void onServerStarting(MinecraftServer server) {
        LOGGER.info("Serene Seasons Plus server starting!");
        SereneService.HANDLER = new FabricAsyncExecutorHandler();
        CommonSnowBlockFeature.onServerStarting(SereneExtendedConfig.TICK_SNOW_REPLACER.get(), SereneExtendedConfig.SNOWSTORM_ENABLED.get(), SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get());
    }

    private void onServerStopping(MinecraftServer server) {
        SereneService.shutdown();
        SereneService.HANDLER = null;
        EnvironmentHelper.onServerStopping(server.method_3847(class_1937.field_25179));
    }

    private void onWorldTick(class_3218 level) {
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        this.onTick((class_1937)level, SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.get(), SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.get(), SereneExtendedConfig.CUSTOM_DAY_LENGTH.get(), SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.get());
        CommonSnowBlockFeature.handleServerTick(level.method_8503(), level);
    }

    private void onServerStarted(MinecraftServer server) {
        EnvironmentHelper.onServerStarted(server.method_3847(class_1937.field_25179));
        ((class_1928.class_4312)server.method_3767().method_20746(class_1928.field_40883)).method_35236(SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get(), server);
    }

    private void onChunkLoad(class_3218 level, class_2791 chunkAccess) {
        if (level == null) {
            return;
        }
        if (!(chunkAccess instanceof class_2818)) {
            return;
        }
        class_2818 chunk = (class_2818)chunkAccess;
        if (level.method_8608()) {
            return;
        }
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        CommonSnowBlockFeature.handleOnChunkLoad(chunk);
    }
}

