/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.features.DefaultSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.features.ISnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.features.snowstorm.ISnowStormLevel;
import com.Gabou.sereneseasonsplus.storage.ChunkQueue;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.tags.SSPTags;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import com.Gabou.sereneseasonsplus.util.MinecraftServerAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.Gabou.gaboulibs.storage.SnowRecord;
import net.Gabou.gaboulibs.util.SnowUtils;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.season.Season;

public class CommonSnowBlockFeature {
    public static final Logger LOGGER = LogManager.getLogger((String)"SnowBlockReplacer");
    protected static final Map<class_3222, class_2338> playerPositions = new ConcurrentHashMap<class_3222, class_2338>();
    protected static int tickThresholdSnowReplacer;
    protected static int tickCounter;
    protected static boolean needUpdateSnowFeature;
    public static ISnowEnvironmentHandler HANDLER;
    protected static final int MAX_ATTEMPTS = 64;
    static final Map<class_2338, QueuedChange> pendingChanges;
    static final Set<class_1923> chunksToDirty;
    static final Map<class_1923, Map<class_2338, Integer>> pendingColumnMapUpdates;
    static final Map<class_1923, Set<class_2338>> pendingIceAdds;
    static final List<class_2338> snowPill;
    static int applyCycleTotal;
    static int applyCycleProcessed;
    protected static boolean snowFeatureEnabled;
    public static boolean FAST_PILING_MODE;
    public static int ACTIVE_STORM_TARGET_TICKS;
    public static float STORM_INTENSITY_MULTIPLIER;
    protected static int maxHeightForSnow;
    protected static final Queue<class_2818> snowQueue;

    public static boolean isSnowFeatureEnabled() {
        return snowFeatureEnabled;
    }

    public static void setFastPilingMode(boolean enabled) {
        FAST_PILING_MODE = enabled;
    }

    public static void setActiveStormTargetTicks(int ticks) {
        ACTIVE_STORM_TARGET_TICKS = Math.max(1, ticks);
    }

    public static void setStormIntensityMultiplier(float mult) {
        STORM_INTENSITY_MULTIPLIER = Math.max(0.01f, mult);
    }

    public static int getTickCounter() {
        return tickCounter;
    }

    protected static void clear() {
        playerPositions.clear();
        tickCounter = 0;
        ChunkQueue.clear();
        pendingChanges.clear();
        chunksToDirty.clear();
        pendingColumnMapUpdates.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
        pendingIceAdds.clear();
    }

    public static void handleServerTick(MinecraftServer server, class_3218 level) {
        int phase;
        if (level == null || level.method_8608()) {
            return;
        }
        ++tickCounter;
        if (!snowFeatureEnabled) {
            if (!ChunkQueue.isEmpty()) {
                CommonSnowBlockFeature.clear();
            }
            return;
        }
        if (needUpdateSnowFeature) {
            ((class_1928.class_4312)server.method_3767().method_20746(class_1928.field_40883)).method_35236(maxHeightForSnow, server);
        }
        if (!snowQueue.isEmpty()) {
            CommonSnowBlockFeature.chunkHandler(level);
        }
        if (level.field_9229.method_43048(16) == 0 || EnvironmentHelper.isHotSeason() && level.field_9229.method_43048(2) == 0) {
            CommonSnowBlockFeature.updatePlayerPositions(level.method_18456());
            CommonSnowBlockFeature.passifSnowBlocks(level);
            EnvironmentHelper.checkAndUpdate(level);
        }
        if ((phase = tickCounter % 5) == 0 && tickCounter > 10) {
            return;
        }
        if (phase == 1) {
            ChunkQueue.Entry entry;
            int processed = 0;
            if (ChunkQueue.isEmpty()) {
                ChunkQueue.shuffle();
            }
            while ((entry = ChunkQueue.poll()) != null) {
                class_2818 chunk;
                boolean timeUp;
                boolean bl = timeUp = ((MinecraftServerAccess)server).sereneseasonsplus$tempsEcoule() && processed >= 5 || processed >= 20;
                if (timeUp) {
                    if (entry.type() == ChunkQueue.TaskType.APPLY_SNOW) {
                        CommonSnowBlockFeature.enqueueChunkForSnowApply(entry.pos(), entry.subSeason());
                        break;
                    }
                    CommonSnowBlockFeature.enqueueChunkForSnowMelt(entry.pos(), entry.fullClear());
                    break;
                }
                boolean changed = false;
                class_1923 chunkPos = entry.pos();
                if (!level.method_8393(chunkPos.field_9181, chunkPos.field_9180) || (chunk = level.method_14178().method_12126(chunkPos.field_9181, chunkPos.field_9180, false)) == null) continue;
                switch (entry.type()) {
                    case APPLY_SNOW: {
                        boolean synced = CommonSnowBlockFeature.syncTrackedColumnsToWorld(level, chunk);
                        if (!synced) {
                            synced = CommonSnowBlockFeature.applySnowHistoryPass(level, chunk);
                        }
                        if (!synced) {
                            synced = CommonSnowBlockFeature.applySnowPatternFromActiveRecord(level, chunk);
                        }
                        if (!synced) break;
                        chunksToDirty.add(chunkPos);
                        changed = true;
                        break;
                    }
                    case MELT_SNOW: {
                        changed = CommonSnowBlockFeature.meltSnowInChunk(level, chunkPos, entry.fullClear());
                        if (!changed) break;
                        chunksToDirty.add(chunkPos);
                    }
                }
                ++processed;
            }
        }
        if (phase == 2 || phase == 3 || phase == 4) {
            if (applyCycleProcessed == 0) {
                applyCycleTotal = pendingChanges.size();
            }
            int batch = (applyCycleTotal + 2) / 3;
            int toProcess = phase == 4 ? Integer.MAX_VALUE : batch;
            int applied = CommonSnowBlockFeature.processQueuedChanges(level, toProcess);
            applyCycleProcessed += applied;
            if (phase == 4) {
                CommonSnowBlockFeature.finalizeChunkBatch(level);
                applyCycleTotal = 0;
                applyCycleProcessed = 0;
            }
        }
    }

    public static void handleOnChunkLoad(class_2818 chunk) {
        if (CommonSnowBlockFeature.isSnowFeatureEnabled()) {
            snowQueue.add(chunk);
        }
    }

    protected static void chunkHandler(class_3218 level) {
        class_2818 chunk;
        while ((chunk = snowQueue.poll()) != null) {
            boolean needAvail;
            if (!(chunk instanceof ISnowTrackedChunk)) continue;
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
            boolean needSurface = tracked.sereneseasonsplus$getSurfaceHeight() == -1;
            boolean bl = needAvail = tracked.sereneseasonsplus$getAvailableSnowColumns() == -1;
            if (!needSurface && !needAvail) continue;
            if (needSurface) {
                int centerX = chunk.method_12004().method_33940();
                int centerZ = chunk.method_12004().method_33942();
                int surfaceHeight = level.method_8624(class_2902.class_2903.field_13202, centerX, centerZ);
                tracked.sereneseasonsplus$setSurfaceHeight(surfaceHeight);
            }
            if (!needAvail) continue;
            int baseX = chunk.method_12004().method_8326();
            int baseZ = chunk.method_12004().method_8328();
            int count = 0;
            for (int dx = 0; dx < 16; ++dx) {
                for (int dz = 0; dz < 16; ++dz) {
                    int x = baseX + dx;
                    int z = baseZ + dz;
                    class_2338 surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                    if (surface == null) continue;
                    ++count;
                }
            }
            tracked.sereneseasonsplus$setAvailableSnowColumns(count);
        }
    }

    public static void enqueueChunkForSnowApply(class_1923 chunkPos, Season.SubSeason subSeason) {
        ChunkQueue.enqueueApply(chunkPos, subSeason);
    }

    public static void enqueueChunkForSnowMelt(class_1923 chunkPos, boolean fullClear) {
        ChunkQueue.enqueueMelt(chunkPos, fullClear);
    }

    protected static void passifSnowBlocks(class_3218 level) {
        for (Map.Entry<class_3222, class_2338> entry : playerPositions.entrySet()) {
            class_3222 player = entry.getKey();
            class_2338 playerPos = entry.getValue();
            int simulationDistance = CommonSnowBlockFeature.getSimulationDistance(player);
            int radius = class_3532.method_15340((int)(simulationDistance * 16), (int)16, (int)64);
            int blocksToReplace = HANDLER.getBlocksToReplace(level, playerPos);
            if (blocksToReplace < 0) {
                if (!EnvironmentHelper.isRainning(level, playerPos)) continue;
                class_5819 random = level.field_9229;
                for (int attempt = 0; attempt < 64; ++attempt) {
                    int z;
                    int dx = random.method_43048(radius * 2 + 1) - radius;
                    int dz = random.method_43048(radius * 2 + 1) - radius;
                    int x = playerPos.method_10263() + dx;
                    class_2338 surface = CommonSnowBlockFeature.findPlacementTop(level, x, z = playerPos.method_10260() + dz);
                    if (surface == null) continue;
                    class_2680 st = level.method_8320(surface);
                    class_2338 targetPos = surface;
                    int targetLayers = 1;
                    if (st.method_27852(class_2246.field_10477)) {
                        int cur = (Integer)st.method_11654((class_2769)class_2488.field_11518);
                        if (cur < 8) {
                            targetLayers = cur + 1;
                        } else {
                            class_2338 above = surface.method_10084();
                            if (!level.method_22347(above)) continue;
                            targetPos = above;
                            targetLayers = 1;
                        }
                    } else if (st.method_27852(class_2246.field_10491)) {
                        class_2338 above = surface.method_10084();
                        if (!level.method_22347(above)) continue;
                        targetPos = above;
                        targetLayers = 1;
                    } else {
                        targetPos = surface;
                        targetLayers = 1;
                    }
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, targetPos, targetLayers, true, false)) {
                        class_2680 ns = level.method_8320(targetPos);
                        CommonSnowBlockFeature.accumulateColumnUpdate(targetPos, ns);
                    }
                    class_2338 below = new class_2338(x, level.method_8624(class_2902.class_2903.field_13197, x, z), z).method_10074();
                    CommonSnowBlockFeature.tryFreezeWaterAt(level, below);
                }
                continue;
            }
            for (int i = 0; i < blocksToReplace; ++i) {
                class_2338 targetPos = CommonSnowBlockFeature.findSnowBlockInRadius(level, playerPos, radius);
                if (targetPos == null) continue;
                SnowUtils.breakOrDecrementLayer((class_1937)level, (class_2338)targetPos);
                class_2680 ns = level.method_8320(targetPos);
                CommonSnowBlockFeature.accumulateColumnUpdate(targetPos, ns);
            }
        }
    }

    protected static boolean syncTrackedColumnsToWorld(class_3218 level, class_2818 chunk) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        class_1923 cp = chunk.method_12004();
        if (pendingColumnMapUpdates.containsKey(cp) || pendingChanges.keySet().stream().anyMatch(p -> p.method_10263() >> 4 == cp.field_9181 && p.method_10260() >> 4 == cp.field_9180)) {
            return false;
        }
        Map<class_2338, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
        if (columns == null) {
            return false;
        }
        Map<class_2338, Integer> pending = pendingColumnMapUpdates.get(cp);
        if (pending != null && !pending.isEmpty()) {
            columns.putAll(pending);
        }
        if (columns.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Map.Entry<class_2338, Integer> e : new ArrayList<Map.Entry<class_2338, Integer>>(columns.entrySet())) {
            class_2338 pos = e.getKey();
            int wantedLayers = class_3532.method_15340((int)e.getValue(), (int)0, (int)8);
            if (wantedLayers <= 0) {
                changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, pos, false);
                columns.remove(pos);
                continue;
            }
            changed |= CommonSnowBlockFeature.placeOrQueueLayers(level, pos, wantedLayers, true, true);
        }
        return changed;
    }

    protected static boolean applySnowHistoryPass(class_3218 level, class_2818 chunk) {
        SnowRecord combined;
        SnowRecord rec;
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.method_8450().method_8356(class_1928.field_40883);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        int baseline = CommonSnowBlockFeature.computeGlobalMinSum(level);
        if (baseline <= 0) {
            return false;
        }
        boolean any = false;
        class_1923 cp = chunk.method_12004();
        int baseX = cp.method_8326();
        int baseZ = cp.method_8328();
        class_2338.class_2339 cursor = new class_2338.class_2339();
        class_2338.class_2339 topCursor = new class_2338.class_2339();
        int minY = level.method_31607();
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                class_2680 topState;
                class_2680 s;
                int remaining;
                int x = baseX + dx;
                int z = baseZ + dz;
                class_2338 surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                if (surface == null) continue;
                int current = 0;
                cursor.method_10103(surface.method_10263(), surface.method_10264(), surface.method_10260());
                class_2680 at = level.method_8320((class_2338)cursor);
                if (!at.method_27852(class_2246.field_10477) && !at.method_27852(class_2246.field_10491)) {
                    cursor.method_10100(0, -1, 0);
                }
                while (cursor.method_10264() >= minY) {
                    class_2680 s2 = level.method_8320((class_2338)cursor);
                    if (s2.method_27852(class_2246.field_10477)) {
                        current += ((Integer)s2.method_11654((class_2769)class_2741.field_12536)).intValue();
                    } else {
                        if (!s2.method_27852(class_2246.field_10491)) break;
                        current += 8;
                    }
                    cursor.method_10100(0, -1, 0);
                }
                int need = baseline - current;
                if (cap > 0) {
                    remaining = cap - current;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                topCursor.method_10103(surface.method_10263(), surface.method_10264(), surface.method_10260());
                while ((s = level.method_8320((class_2338)topCursor)).method_27852(class_2246.field_10477) || s.method_27852(class_2246.field_10491)) {
                    topCursor.method_10100(0, 1, 0);
                }
                remaining = need;
                class_2338.class_2339 placePos = new class_2338.class_2339(topCursor.method_10263(), topCursor.method_10264(), topCursor.method_10260());
                class_2338.class_2339 belowPos = new class_2338.class_2339(topCursor.method_10263(), topCursor.method_10264() - 1, topCursor.method_10260());
                if (belowPos.method_10264() >= minY && ((topState = level.method_8320((class_2338)belowPos)).method_27852(class_2246.field_10477) || topState.method_27852(class_2246.field_10491))) {
                    int currentLayers = topState.method_27852(class_2246.field_10491) ? 8 : (Integer)topState.method_11654((class_2769)class_2741.field_12536);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && remaining > 0) {
                        int add = Math.min(freeSpace, remaining);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (class_2338)belowPos, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(belowPos.method_10062(), targetLayers);
                            any = true;
                        }
                        remaining -= add;
                    }
                    if (remaining <= 0) continue;
                }
                while (remaining > 0 && placePos.method_10264() < level.method_31600()) {
                    int toPlace = Math.min(8, remaining);
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (class_2338)placePos, toPlace, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(placePos.method_10062(), toPlace);
                        any = true;
                    }
                    remaining -= toPlace;
                    placePos.method_10100(0, 1, 0);
                }
            }
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd != null && (sd.currentStormId > 0 ? (rec = sd.snowHistory.get(sd.currentStormId)) != null : (combined = CommonSnowBlockFeature.aggregateFinishedStormSums(level)) != null)) {
            return CommonSnowBlockFeature.applySnowPattern(level, chunk, rec, level.field_9229) || any;
        }
        return any;
    }

    public static boolean tryFreezeWaterAt(class_3218 level, class_2338 pos) {
        if (pos == null) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        if (!state.method_27852(class_2246.field_10382)) {
            return false;
        }
        class_2338 sample = pos.method_10084();
        if (!EnvironmentHelper.isRainning(level, sample)) {
            return false;
        }
        if (!CommonSnowBlockFeature.isExposedToSky(level, sample)) {
            return false;
        }
        if (!HANDLER.isColdEnoughForSnow(level, sample)) {
            return false;
        }
        if (!CommonSnowBlockFeature.isWaterBiome(level, pos)) {
            return false;
        }
        class_2680 ice = class_2246.field_10295.method_9564();
        if (level.method_8501(pos, ice)) {
            CommonSnowBlockFeature.accumulateColumnUpdate(pos, ice);
            return true;
        }
        return false;
    }

    protected static boolean isWaterBiome(class_3218 level, class_2338 pos) {
        try {
            class_6880 holder = level.method_23753(pos);
            return holder.method_40230().map(key -> {
                class_2960 rl = key.method_29177();
                String path = rl.method_12832();
                return path.contains("ocean") || path.contains("river");
            }).orElse(false);
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static boolean applySnowPatternFromActiveRecord(class_3218 level, class_2818 chunk) {
        SnowRecord rec;
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd != null && sd.currentStormId > 0 && (rec = sd.snowHistory.get(sd.currentStormId)) != null) {
            return CommonSnowBlockFeature.applySnowPattern(level, chunk, rec, level.field_9229);
        }
        return false;
    }

    protected static boolean applySnowPattern(class_3218 level, class_2818 chunk, SnowRecord record, class_5819 rng) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.method_8450().method_8356(class_1928.field_40883);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        class_1923 cp = chunk.method_12004();
        int baseX = cp.method_8326();
        int baseZ = cp.method_8328();
        float avg = Math.max(0.0f, record.avgLayers);
        float coverage = class_3532.method_15363((float)(avg / 8.0f), (float)0.1f, (float)0.85f);
        boolean any = false;
        float progress = 1.0f;
        int currentTick = CommonSnowBlockFeature.getTickCounter();
        if (!FAST_PILING_MODE) {
            int activeId;
            SnowHistorySavedData sd = SnowHistorySavedData.get();
            int n = activeId = sd != null ? sd.currentStormId : 0;
            if (activeId > 0) {
                if (tracked.sereneseasonsplus$getStormIdApplied() != activeId) {
                    tracked.sereneseasonsplus$setStormIdApplied(activeId);
                    tracked.sereneseasonsplus$setStormProgress(0.0f);
                    tracked.sereneseasonsplus$setLastProgressTick(currentTick);
                }
                float cur = tracked.sereneseasonsplus$getStormProgress();
                int last = tracked.sereneseasonsplus$getLastProgressTick();
                int dt = Math.max(1, currentTick - last);
                float delta = (float)dt / (float)Math.max(1, ACTIVE_STORM_TARGET_TICKS);
                cur = class_3532.method_15363((float)(cur + delta * STORM_INTENSITY_MULTIPLIER), (float)0.0f, (float)1.0f);
                tracked.sereneseasonsplus$setStormProgress(cur);
                tracked.sereneseasonsplus$setLastProgressTick(currentTick);
                progress = cur;
            }
        }
        int activeId = 0;
        SnowHistorySavedData sdLocal = SnowHistorySavedData.get();
        if (sdLocal != null) {
            activeId = sdLocal.currentStormId;
        }
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int desired;
                class_2338 surface;
                double wave;
                float white;
                float noise;
                int x = baseX + dx;
                int z = baseZ + dz;
                if (activeId > 0) {
                    if (tracked.sereneseasonsplus$getDestroyedStormId() != activeId) {
                        tracked.sereneseasonsplus$getDestroyedColumns().clear();
                        tracked.sereneseasonsplus$setDestroyedStormId(activeId);
                    }
                    long xz = (long)x << 32 ^ (long)z & 0xFFFFFFFFL;
                    if (tracked.sereneseasonsplus$getDestroyedColumns().contains(xz)) continue;
                }
                if ((noise = class_3532.method_15363((float)((float)((double)(white = rng.method_43057()) * 0.7 + ((wave = Math.sin((double)x * 0.12 + (double)z * 0.12)) + 1.0) * 0.15)), (float)0.0f, (float)1.0f)) > coverage || (surface = CommonSnowBlockFeature.findPlacementTop(level, x, z)) == null) continue;
                int minL = Math.max(1, Math.round(record.minLayers));
                int maxL = Math.max(minL, Math.round(record.maxLayers));
                int span = Math.max(1, maxL - minL + 1);
                int pick = minL + rng.method_43048(span);
                int towardAvg = Math.round(class_3532.method_16439((float)0.35f, (float)pick, (float)avg));
                int totalLayers = Math.max(1, towardAvg);
                int n = desired = FAST_PILING_MODE ? totalLayers : Math.max(0, Math.round((float)totalLayers * progress));
                if (desired <= 0) continue;
                class_2338.class_2339 cursor = new class_2338.class_2339(surface.method_10263(), surface.method_10264(), surface.method_10260());
                int minY = level.method_31607();
                int currentTotal = 0;
                class_2338.class_2339 down = new class_2338.class_2339(surface.method_10263(), surface.method_10264(), surface.method_10260());
                class_2680 at = level.method_8320((class_2338)down);
                if (!at.method_27852(class_2246.field_10477) && !at.method_27852(class_2246.field_10491)) {
                    down.method_10100(0, -1, 0);
                }
                while (down.method_10264() >= minY) {
                    class_2680 s = level.method_8320((class_2338)down);
                    if (s.method_27852(class_2246.field_10477)) {
                        currentTotal += ((Integer)s.method_11654((class_2769)class_2741.field_12536)).intValue();
                    } else {
                        if (!s.method_27852(class_2246.field_10491)) break;
                        currentTotal += 8;
                    }
                    down.method_10100(0, -1, 0);
                }
                int need = desired - currentTotal;
                if (cap > 0) {
                    int remaining = cap - currentTotal;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                class_2680 existing = level.method_8320((class_2338)cursor);
                if (existing.method_27852(class_2246.field_10477) || existing.method_27852(class_2246.field_10491)) {
                    int currentLayers = existing.method_27852(class_2246.field_10491) ? 8 : (Integer)existing.method_11654((class_2769)class_2741.field_12536);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && need > 0) {
                        int add = Math.min(freeSpace, need);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (class_2338)cursor, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(cursor.method_10062(), targetLayers);
                            any = true;
                        }
                        need -= add;
                    }
                    if (need > 0) {
                        cursor.method_10100(0, 1, 0);
                    }
                }
                while (need >= 8 && cursor.method_10264() < level.method_31600()) {
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (class_2338)cursor, 8, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(cursor.method_10062(), 8);
                        any = true;
                    }
                    need -= 8;
                    cursor.method_10100(0, 1, 0);
                }
                if (need <= 0 || cursor.method_10264() >= level.method_31600() || !CommonSnowBlockFeature.placeOrQueueLayers(level, (class_2338)cursor, need, true, true)) continue;
                tracked.sereneseasonsplus$getSnowColumns().put(cursor.method_10062(), need);
                any = true;
            }
        }
        return any;
    }

    protected static boolean applyCombinedFinishedPattern(class_3218 level, class_2818 chunk, SnowRecord combined, class_5819 rng) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.method_8450().method_8356(class_1928.field_40883);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        class_1923 cp = chunk.method_12004();
        int baseX = cp.method_8326();
        int baseZ = cp.method_8328();
        int minL = Math.max(0, Math.round(combined.minLayers));
        int avgL = Math.max(minL, Math.round(combined.avgLayers));
        int maxL = Math.max(avgL, Math.round(combined.maxLayers));
        boolean any = false;
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                class_2338 surface;
                double wave;
                int x = baseX + dx;
                int z = baseZ + dz;
                float white = rng.method_43057();
                float noise = class_3532.method_15363((float)((float)((double)white * 0.7 + ((wave = Math.sin((double)x * 0.12 + (double)z * 0.12)) + 1.0) * 0.15)), (float)0.0f, (float)1.0f);
                int pick = minL + Math.round(noise * (float)Math.max(0, maxL - minL));
                int towardAvg = Math.round(class_3532.method_16439((float)0.35f, (float)pick, (float)avgL));
                int desired = Math.max(minL, towardAvg);
                if (desired <= 0 || (surface = CommonSnowBlockFeature.findPlacementTop(level, x, z)) == null) continue;
                int minY = level.method_31607();
                int currentTotal = 0;
                class_2338.class_2339 down = new class_2338.class_2339(surface.method_10263(), surface.method_10264(), surface.method_10260());
                class_2680 at = level.method_8320((class_2338)down);
                if (!at.method_27852(class_2246.field_10477) && !at.method_27852(class_2246.field_10491)) {
                    down.method_10100(0, -1, 0);
                }
                while (down.method_10264() >= minY) {
                    class_2680 s = level.method_8320((class_2338)down);
                    if (s.method_27852(class_2246.field_10477)) {
                        currentTotal += ((Integer)s.method_11654((class_2769)class_2741.field_12536)).intValue();
                    } else {
                        if (!s.method_27852(class_2246.field_10491)) break;
                        currentTotal += 8;
                    }
                    down.method_10100(0, -1, 0);
                }
                int need = desired - currentTotal;
                if (cap > 0) {
                    int remaining = cap - currentTotal;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                class_2338.class_2339 cursor = new class_2338.class_2339(surface.method_10263(), surface.method_10264(), surface.method_10260());
                class_2680 existing = level.method_8320((class_2338)cursor);
                if (existing.method_27852(class_2246.field_10477) || existing.method_27852(class_2246.field_10491)) {
                    int currentLayers = existing.method_27852(class_2246.field_10491) ? 8 : (Integer)existing.method_11654((class_2769)class_2741.field_12536);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && need > 0) {
                        int add = Math.min(freeSpace, need);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (class_2338)cursor, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(cursor.method_10062(), targetLayers);
                            any = true;
                        }
                        need -= add;
                    }
                    if (need > 0) {
                        cursor.method_10100(0, 1, 0);
                    }
                }
                while (need >= 8 && cursor.method_10264() < level.method_31600()) {
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (class_2338)cursor, 8, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(cursor.method_10062(), 8);
                        any = true;
                    }
                    need -= 8;
                    cursor.method_10100(0, 1, 0);
                }
                if (need <= 0 || cursor.method_10264() >= level.method_31600() || !CommonSnowBlockFeature.placeOrQueueLayers(level, (class_2338)cursor, need, true, true)) continue;
                tracked.sereneseasonsplus$getSnowColumns().put(cursor.method_10062(), need);
                any = true;
            }
        }
        return any;
    }

    protected static boolean isChunkAtOrAboveSnowCap(class_3218 level, class_2818 chunk, int capLayers) {
        class_1923 cp = chunk.method_12004();
        int baseX = cp.method_8326();
        int baseZ = cp.method_8328();
        class_2338.class_2339 down = new class_2338.class_2339();
        int minY = level.method_31607();
        for (int dx = 0; dx < 16; ++dx) {
            block1: for (int dz = 0; dz < 16; ++dz) {
                int x = baseX + dx;
                int z = baseZ + dz;
                class_2338 surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                if (surface == null) continue;
                int total = 0;
                down.method_10103(surface.method_10263(), surface.method_10264(), surface.method_10260());
                class_2680 at = level.method_8320((class_2338)down);
                if (!at.method_27852(class_2246.field_10477) && !at.method_27852(class_2246.field_10491)) {
                    down.method_10100(0, -1, 0);
                }
                while (down.method_10264() >= minY) {
                    class_2680 s = level.method_8320((class_2338)down);
                    if (s.method_27852(class_2246.field_10477)) {
                        total += ((Integer)s.method_11654((class_2769)class_2741.field_12536)).intValue();
                    } else {
                        if (!s.method_27852(class_2246.field_10491)) continue block1;
                        total += 8;
                    }
                    if (total >= capLayers) {
                        return true;
                    }
                    down.method_10100(0, -1, 0);
                }
            }
        }
        return false;
    }

    public static boolean meltSnowInChunk(class_3218 level, class_1923 chunkPos, boolean fullClear) {
        class_2818 chunk = level.method_14178().method_12126(chunkPos.field_9181, chunkPos.field_9180, false);
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        boolean changed = false;
        Map<Object, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
        if (columns == null) {
            columns = Collections.emptyMap();
        }
        if (fullClear && !columns.isEmpty()) {
            for (class_2338 class_23382 : new ArrayList<Object>(columns.keySet())) {
                changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, class_23382, false);
                columns.remove(class_23382);
            }
        }
        if (!columns.isEmpty() && !fullClear) {
            HashMap<Long, class_2338> topByColumn = new HashMap<Long, class_2338>();
            for (class_2338 class_23383 : columns.keySet()) {
                long key = (long)class_23383.method_10263() << 32 ^ (long)class_23383.method_10260() & 0xFFFFFFFFL;
                class_2338 cur = (class_2338)topByColumn.get(key);
                if (cur != null && class_23383.method_10264() <= cur.method_10264()) continue;
                topByColumn.put(key, class_23383.method_10062());
            }
            class_2338.class_2339 class_23392 = new class_2338.class_2339();
            block2: for (class_2338 top : topByColumn.values()) {
                class_2680 state = level.method_8320(top);
                if (state.method_27852(class_2246.field_10491)) {
                    changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, top, 7, false);
                    columns.put(top.method_10062(), 7);
                    continue;
                }
                if (state.method_27852(class_2246.field_10477)) {
                    int layers = (Integer)state.method_11654((class_2769)class_2741.field_12536);
                    if (layers <= 1) {
                        changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, top, false);
                        columns.remove(top);
                        continue;
                    }
                    changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, top, layers - 1, false);
                    columns.put(top.method_10062(), layers - 1);
                    continue;
                }
                int minY = level.method_31607();
                class_23392.method_10103(top.method_10263(), top.method_10264(), top.method_10260());
                while (class_23392.method_10264() >= minY) {
                    class_2680 s = level.method_8320((class_2338)class_23392);
                    if (s.method_27852(class_2246.field_10491)) {
                        changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, class_23392.method_10062(), 7, false);
                        columns.put(class_23392.method_10062(), 7);
                        continue block2;
                    }
                    if (s.method_27852(class_2246.field_10477)) {
                        int l = (Integer)s.method_11654((class_2769)class_2741.field_12536);
                        if (l <= 1) {
                            changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, class_23392.method_10062(), false);
                            columns.remove(class_23392);
                            continue block2;
                        }
                        changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, class_23392.method_10062(), l - 1, false);
                        columns.put(class_23392.method_10062(), l - 1);
                        continue block2;
                    }
                    class_23392.method_10100(0, -1, 0);
                }
            }
        }
        changed |= CommonSnowBlockFeature.clearCoveredMeltablesNearSurface(level, chunk);
        return changed |= CommonSnowBlockFeature.meltTrackedIce(level, tracked);
    }

    protected static boolean clearCoveredMeltablesNearSurface(class_3218 level, class_2818 chunk) {
        boolean changed = false;
        class_1923 cp = chunk.method_12004();
        int baseX = cp.method_8326();
        int baseZ = cp.method_8328();
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int dx = 0; dx < 16; ++dx) {
            block1: for (int dz = 0; dz < 16; ++dz) {
                int x = baseX + dx;
                int z = baseZ + dz;
                int groundY = level.method_8624(class_2902.class_2903.field_13203, x, z);
                for (int dy = 0; dy <= 6; ++dy) {
                    class_2680 st;
                    pos.method_10103(x, groundY + dy, z);
                    if (pos.method_10264() < level.method_31607() || pos.method_10264() >= level.method_31600() || !(st = level.method_8320((class_2338)pos)).method_26164(SSPTags.Blocks.MELTABLE) || CommonSnowBlockFeature.isExposedToSky(level, (class_2338)pos)) continue;
                    changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, pos.method_10062(), false);
                    continue block1;
                }
            }
        }
        return changed;
    }

    protected static boolean meltTrackedIce(class_3218 level, ISnowTrackedChunk tracked) {
        boolean changed = false;
        HashSet<class_2338> copy = new HashSet<class_2338>(tracked.sereneseasonsplus$getIceColumns());
        for (class_2338 p : copy) {
            class_2680 st = level.method_8320(p);
            if (st.method_27852(class_2246.field_10295)) {
                CommonSnowBlockFeature.queueChange(p, class_2246.field_10382.method_9564(), 34);
                tracked.sereneseasonsplus$getIceColumns().remove(p);
                changed = true;
                continue;
            }
            tracked.sereneseasonsplus$getIceColumns().remove(p);
        }
        return changed;
    }

    protected static class_2338 findPlacementTop(class_3218 level, int x, int z) {
        int y = level.method_8624(class_2902.class_2903.field_13203, x, z);
        class_2338 base = new class_2338(x, y, z);
        class_2680 at = level.method_8320(base);
        class_2680 snow = class_2246.field_10477.method_9564();
        if ((level.method_22347(base) || at.method_45474()) && snow.method_26184((class_4538)level, base) && CommonSnowBlockFeature.canReceiveSnowAt(level, base)) {
            return base;
        }
        class_2338 up = base.method_10084();
        if (snow.method_26184((class_4538)level, up) && level.method_22347(up) && CommonSnowBlockFeature.canReceiveSnowAt(level, up)) {
            return up;
        }
        if (at.method_27852(class_2246.field_10477) && CommonSnowBlockFeature.canReceiveSnowAt(level, base)) {
            return base;
        }
        return null;
    }

    protected static boolean isExposedToSky(class_3218 level, class_2338 pos) {
        if (pos.equals((Object)new class_2338(-98, 63, -104))) {
            boolean bl = false;
        }
        try {
            return level.method_22348(pos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    protected static boolean canReceiveSnowAt(class_3218 level, class_2338 pos) {
        try {
            if (level.method_22348(pos)) {
                return true;
            }
            class_2338.class_2339 cursor = new class_2338.class_2339(pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
            int max = level.method_31600();
            while (cursor.method_10264() < max) {
                class_2680 st = level.method_8320((class_2338)cursor);
                if (st.method_26215()) {
                    cursor.method_10100(0, 1, 0);
                    continue;
                }
                if (st.method_26164(class_3481.field_15503)) {
                    cursor.method_10100(0, 1, 0);
                    continue;
                }
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            return true;
        }
    }

    protected static boolean placeOrQueueLayers(class_3218 level, class_2338 pos, int targetLayers, boolean allowPlace, boolean queue) {
        class_2818 chunk;
        int activeId;
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        int n = activeId = sd != null ? sd.currentStormId : 0;
        if (activeId > 0 && (chunk = level.method_14178().method_12126(pos.method_10263() >> 4, pos.method_10260() >> 4, false)) instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
            if (tracked.sereneseasonsplus$getDestroyedStormId() != activeId) {
                tracked.sereneseasonsplus$getDestroyedColumns().clear();
                tracked.sereneseasonsplus$setDestroyedStormId(activeId);
            }
            long xz = (long)pos.method_10263() << 32 ^ (long)pos.method_10260() & 0xFFFFFFFFL;
            if (tracked.sereneseasonsplus$getDestroyedColumns().contains(xz)) {
                return false;
            }
        }
        if (queue) {
            return CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, pos, targetLayers, allowPlace);
        }
        targetLayers = class_3532.method_15340((int)targetLayers, (int)1, (int)8);
        class_2680 state = level.method_8320(pos);
        targetLayers = CommonSnowBlockFeature.clampLayersForColumnCap(level, pos, state, targetLayers);
        if (targetLayers <= 0) {
            return false;
        }
        if (state.method_27852(class_2246.field_10477) && state.method_28498((class_2769)class_2488.field_11518)) {
            if (allowPlace && !CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            int current = (Integer)state.method_11654((class_2769)class_2488.field_11518);
            if (current == targetLayers) {
                return false;
            }
            class_2680 newState = (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(targetLayers));
            return level.method_8652(pos, newState, 2);
        }
        if (state.method_27852(class_2246.field_10491)) {
            if (allowPlace && !CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            if (targetLayers == 8) {
                return false;
            }
            class_2680 newState = (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(targetLayers));
            return level.method_8652(pos, newState, 2);
        }
        if (allowPlace && (level.method_22347(pos) || state.method_45474())) {
            if (!CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            class_2680 snow = (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(targetLayers));
            if (!snow.method_26184((class_4538)level, pos)) {
                return false;
            }
            return level.method_8652(pos, snow, 2);
        }
        return false;
    }

    protected static boolean queueSnowLayersIfNeeded(class_3218 level, class_2338 pos, int targetLayers, boolean allowPlace) {
        targetLayers = class_3532.method_15340((int)targetLayers, (int)1, (int)8);
        class_2680 state = level.method_8320(pos);
        targetLayers = CommonSnowBlockFeature.clampLayersForColumnCap(level, pos, state, targetLayers);
        if (targetLayers <= 0) {
            return false;
        }
        if (state.method_27852(class_2246.field_10477) && state.method_28498((class_2769)class_2488.field_11518)) {
            if (allowPlace && !CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            int current = (Integer)state.method_11654((class_2769)class_2488.field_11518);
            if (current == targetLayers) {
                return false;
            }
            class_2680 newState = (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(targetLayers));
            CommonSnowBlockFeature.queueChange(pos, newState, 2);
            snowPill.add(pos.method_10062());
            return true;
        }
        if (state.method_27852(class_2246.field_10491)) {
            if (allowPlace && !CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            if (targetLayers == 8) {
                return false;
            }
            class_2680 newState = (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(targetLayers));
            CommonSnowBlockFeature.queueChange(pos, newState, 2);
            snowPill.add(pos.method_10062());
            return true;
        }
        if (allowPlace && (level.method_22347(pos) || state.method_45474())) {
            if (!CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            class_2680 snow = (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(targetLayers));
            if (!snow.method_26184((class_4538)level, pos)) {
                return false;
            }
            CommonSnowBlockFeature.queueChange(pos, snow, 2);
            snowPill.add(pos.method_10062());
            return true;
        }
        return false;
    }

    private static int clampLayersForColumnCap(class_3218 level, class_2338 pos, class_2680 currentState, int targetLayers) {
        int delta;
        int remaining;
        int cap = level.method_8450().method_8356(class_1928.field_40883);
        if (cap <= 0) {
            return targetLayers;
        }
        int currentAtPos = 0;
        if (currentState.method_27852(class_2246.field_10477)) {
            currentAtPos = (Integer)currentState.method_11654((class_2769)class_2488.field_11518);
        } else if (currentState.method_27852(class_2246.field_10491)) {
            currentAtPos = 8;
        }
        int total = currentAtPos;
        class_2338.class_2339 cursor = new class_2338.class_2339(pos.method_10263(), pos.method_10264() - 1, pos.method_10260());
        int minY = level.method_31607();
        while (cursor.method_10264() >= minY) {
            class_2680 s = level.method_8320((class_2338)cursor);
            if (s.method_27852(class_2246.field_10477)) {
                total += ((Integer)s.method_11654((class_2769)class_2488.field_11518)).intValue();
            } else {
                if (!s.method_27852(class_2246.field_10491)) break;
                total += 8;
            }
            cursor.method_10100(0, -1, 0);
        }
        cursor.method_10103(pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
        int maxY = level.method_31600();
        while (cursor.method_10264() < maxY) {
            class_2680 s = level.method_8320((class_2338)cursor);
            if (s.method_27852(class_2246.field_10477)) {
                total += ((Integer)s.method_11654((class_2769)class_2488.field_11518)).intValue();
            } else {
                if (!s.method_27852(class_2246.field_10491)) break;
                total += 8;
            }
            cursor.method_10100(0, 1, 0);
        }
        if ((remaining = cap - (total - currentAtPos)) <= 0) {
            return Math.min(targetLayers, currentAtPos);
        }
        if (targetLayers > currentAtPos && (delta = targetLayers - currentAtPos) > remaining) {
            targetLayers = currentAtPos + remaining;
        }
        return class_3532.method_15340((int)targetLayers, (int)1, (int)8);
    }

    protected static class_2338 findSnowBlockInRadius(class_3218 level, class_2338 center, int radius) {
        class_3215 chunkSource = level.method_14178();
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int chunkZ;
                int chunkX = center.method_10263() + x >> 4;
                class_2818 chunk = chunkSource.method_12126(chunkX, chunkZ = center.method_10260() + z >> 4, false);
                if (chunk == null) continue;
                for (int y = -5; y <= 5; ++y) {
                    pos.method_10103(center.method_10263() + x, center.method_10264() + y, center.method_10260() + z);
                    if (pos.method_10264() < level.method_31607() || pos.method_10264() >= level.method_31600() || !chunk.method_8320((class_2338)pos).method_26164(SSPTags.Blocks.MELTABLE)) continue;
                    return pos.method_10062();
                }
            }
        }
        return null;
    }

    protected static boolean queueClearIfNeeded(class_3218 level, class_2338 pos, boolean toWater) {
        class_2680 wanted = toWater ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
        class_2680 current = level.method_8320(pos);
        if (current.method_27852(wanted.method_26204())) {
            return false;
        }
        CommonSnowBlockFeature.queueChange(pos, wanted, 34);
        return true;
    }

    protected static void queueChange(class_2338 pos, class_2680 state, int flags) {
        class_2338 imm = pos.method_10062();
        pendingChanges.put(imm, new QueuedChange(imm, state, flags));
    }

    public static void accumulateColumnUpdate(class_2338 pos, class_2680 state) {
        class_1923 cp = new class_1923(pos.method_10263() >> 4, pos.method_10260() >> 4);
        if (state.method_27852(class_2246.field_10295)) {
            pendingIceAdds.computeIfAbsent(cp, k -> new HashSet()).add(pos.method_10062());
            chunksToDirty.add(cp);
            return;
        }
        int val = state.method_27852(class_2246.field_10477) && state.method_28498((class_2769)class_2488.field_11518) ? (Integer)state.method_11654((class_2769)class_2488.field_11518) : (state.method_27852(class_2246.field_10491) ? 8 : 0);
        pendingColumnMapUpdates.computeIfAbsent(cp, k -> new HashMap()).put(pos.method_10062(), val);
        chunksToDirty.add(cp);
    }

    protected static int processQueuedChanges(class_3218 level, int limit) {
        int applied;
        if (pendingChanges.isEmpty()) {
            return 0;
        }
        Iterator<Map.Entry<class_2338, QueuedChange>> it = pendingChanges.entrySet().iterator();
        for (applied = 0; it.hasNext() && applied < limit; ++applied) {
            Map.Entry<class_2338, QueuedChange> e = it.next();
            QueuedChange qc = e.getValue();
            boolean changed = level.method_8652(qc.pos(), qc.state(), qc.flags());
            if (changed) {
                CommonSnowBlockFeature.accumulateColumnUpdate(qc.pos(), qc.state());
            }
            it.remove();
        }
        return applied;
    }

    protected static void finalizeChunkBatch(class_3218 level) {
        class_1923 cp;
        if (!pendingColumnMapUpdates.isEmpty()) {
            for (Map.Entry<class_1923, Object> entry : pendingColumnMapUpdates.entrySet()) {
                class_2818 chunk;
                cp = entry.getKey();
                Map updates = (Map)entry.getValue();
                if (!level.method_8393(cp.field_9181, cp.field_9180) || !((chunk = level.method_14178().method_12126(cp.field_9181, cp.field_9180, false)) instanceof ISnowTrackedChunk)) continue;
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                Map<class_2338, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
                for (Map.Entry up : updates.entrySet()) {
                    int val = (Integer)up.getValue();
                    if (val <= 0) {
                        columns.remove(up.getKey());
                        continue;
                    }
                    columns.put(((class_2338)up.getKey()).method_10062(), class_3532.method_15340((int)val, (int)1, (int)8));
                }
            }
            pendingColumnMapUpdates.clear();
        }
        if (!pendingIceAdds.isEmpty()) {
            for (Map.Entry<class_1923, Object> entry : pendingIceAdds.entrySet()) {
                class_2818 chunk;
                cp = entry.getKey();
                if (!level.method_8393(cp.field_9181, cp.field_9180) || !((chunk = level.method_14178().method_12126(cp.field_9181, cp.field_9180, false)) instanceof ISnowTrackedChunk)) continue;
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                Set<class_2338> set = tracked.sereneseasonsplus$getIceColumns();
                for (class_2338 p : (Set)entry.getValue()) {
                    if (!level.method_8320(p).method_27852(class_2246.field_10295)) continue;
                    set.add(p.method_10062());
                }
            }
            pendingIceAdds.clear();
        }
        for (class_1923 class_19232 : chunksToDirty) {
            class_2818 chunk;
            if (!level.method_8393(class_19232.field_9181, class_19232.field_9180) || (chunk = level.method_14178().method_12126(class_19232.field_9181, class_19232.field_9180, false)) == null) continue;
            chunk.method_12008(true);
        }
        chunksToDirty.clear();
        pendingChanges.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
    }

    protected static void updatePlayerPositions(Iterable<class_3222> players) {
        for (class_3222 player : players) {
            playerPositions.put(player, player.method_24515());
        }
    }

    protected static int getSimulationDistance(class_3222 player) {
        MinecraftServer server = player.method_5682();
        return server != null ? server.method_3760().method_14568() : 10;
    }

    public static int computeGlobalAvg(class_3218 level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.snowHistory.isEmpty()) {
            return 0;
        }
        int excludeId = sd.currentStormId;
        float total = 0.0f;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord rec = e.getValue();
            total += Math.max(0.0f, rec.avgLayers);
        }
        return Math.round(total);
    }

    public static int computeGlobalMinSum(class_3218 level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.snowHistory.isEmpty()) {
            return 0;
        }
        int excludeId = sd.currentStormId;
        float sumMin = 0.0f;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord rec = e.getValue();
            sumMin += Math.max(0.0f, rec.minLayers);
        }
        return Math.max(0, Math.round(sumMin));
    }

    protected static SnowRecord aggregateFinishedStormSums(class_3218 level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.snowHistory.isEmpty()) {
            return null;
        }
        int excludeId = sd.currentStormId;
        float sumMin = 0.0f;
        float sumAvg = 0.0f;
        float sumMax = 0.0f;
        int count = 0;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord r = e.getValue();
            sumMin += Math.max(0.0f, r.minLayers);
            sumAvg += Math.max(0.0f, r.avgLayers);
            sumMax += Math.max(0.0f, r.maxLayers);
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return new SnowRecord(sumMin, sumAvg, sumMax, null);
    }

    public static void onServerStarting(int config, boolean snowStorm, int snowHeight) {
        tickThresholdSnowReplacer = config;
        snowFeatureEnabled = snowStorm;
        maxHeightForSnow = snowHeight;
        tickCounter = 0;
        playerPositions.clear();
        ChunkQueue.clear();
        pendingColumnMapUpdates.clear();
        pendingChanges.clear();
        pendingIceAdds.clear();
        chunksToDirty.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
    }

    public static void onServerStopping() {
        CommonSnowBlockFeature.clear();
    }

    public static void onConfigReload(int config, boolean snowStorm, int snowHeight) {
        if (snowHeight != maxHeightForSnow) {
            maxHeightForSnow = snowHeight;
            needUpdateSnowFeature = true;
        }
        tickThresholdSnowReplacer = config;
        snowFeatureEnabled = snowStorm;
    }

    public static void onSeasonChange(class_3218 level) {
        ChunkQueue.clear();
    }

    protected static int calculateBlocksToReplace1(float temperature) {
        return (int)Math.ceil(temperature / 5.0f);
    }

    protected static int calculateBlocksToReplace(float temperature) {
        if (temperature < 0.2f) {
            return 1;
        }
        return temperature < 0.5f ? 3 : 25;
    }

    public static boolean isSnowStormAt(class_3218 level, class_1923 pos) {
        if (level instanceof ISnowStormLevel) {
            ISnowStormLevel stormLevel = (ISnowStormLevel)level;
            return stormLevel.sereneseasonsplus$isSnowStormAt(pos);
        }
        return false;
    }

    public static int getSnowStormIntensity(class_3218 level, class_1923 pos) {
        if (level instanceof ISnowStormLevel) {
            ISnowStormLevel stormLevel = (ISnowStormLevel)level;
            return stormLevel.sereneseasonsplus$getSnowStormIntensity(pos);
        }
        return 0;
    }

    static {
        tickCounter = 0;
        needUpdateSnowFeature = false;
        HANDLER = new DefaultSnowEnvironmentHandler();
        pendingChanges = new LinkedHashMap<class_2338, QueuedChange>();
        chunksToDirty = new HashSet<class_1923>();
        pendingColumnMapUpdates = new HashMap<class_1923, Map<class_2338, Integer>>();
        pendingIceAdds = new HashMap<class_1923, Set<class_2338>>();
        snowPill = new ArrayList<class_2338>();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
        snowFeatureEnabled = false;
        FAST_PILING_MODE = false;
        ACTIVE_STORM_TARGET_TICKS = 8000;
        STORM_INTENSITY_MULTIPLIER = 1.0f;
        snowQueue = new ConcurrentLinkedQueue<class_2818>();
    }

    public record QueuedChange(class_2338 pos, class_2680 state, int flags) {
    }
}

