/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus;

import com.Gabou.sereneseasonsplus.SereneSeasonPlusCommon;
import com.Gabou.sereneseasonsplus.SereneSeasonsPlusClientForge;
import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.event.SeasonChangeEvent;
import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.ForgeSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ForgeAsyncExecutorHandler;
import com.Gabou.sereneseasonsplus.util.ForgeEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ProjectAtmosphereRainHandler;
import com.Gabou.sereneseasonsplus.util.SereneService;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="sereneseasonsplus")
public class SereneSeasonsPlusForge
extends SereneSeasonPlusCommon {
    public static boolean isProjectAtmosphereLoaded = false;

    public SereneSeasonsPlusForge(FMLJavaModLoadingContext context) {
        isProjectAtmosphereLoaded = ModList.get().isLoaded("projectatmosphere");
        MinecraftForge.EVENT_BUS.register((Object)this);
        CommonSnowBlockFeature.HANDLER = new ForgeSnowEnvironmentHandler();
        EnvironmentHelper.init(new ForgeEnvironmentHelper());
        if (isProjectAtmosphereLoaded) {
            EnvironmentHelper.initRainHandler(new ProjectAtmosphereRainHandler());
        }
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SereneExtendedConfig.COMMON_SPEC);
        if (!isProjectAtmosphereLoaded) {
            SeasonChangeEvent.register();
        }
        context.getModEventBus().addListener(event -> {
            LOGGER.info("Setting up Serene Season Plus (Common)");
            this.clientSetup((FMLClientSetupEvent)event, context);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Serene Seasons Extended is loading!");
        SereneService.HANDLER = new ForgeAsyncExecutorHandler();
        ((GameRules.IntegerValue)event.getServer().m_129900_().m_46170_(GameRules.f_254637_)).m_151489_(100, event.getServer());
        CommonSnowBlockFeature.onServerStarting((Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get(), (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        EnvironmentHelper.onServerStarted(event.getServer().m_129880_(Level.f_46428_));
    }

    private void clientSetup(FMLClientSetupEvent event, FMLJavaModLoadingContext context) {
        LOGGER.info("Setting up Serene Season Plus (Client)");
        event.enqueueWork(() -> SereneSeasonsPlusClientForge.init(context));
        MinecraftForge.EVENT_BUS.register(SereneSeasonsPlusClientForge.class);
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        SereneService.HANDLER.shutdown();
        SereneService.HANDLER = null;
        EnvironmentHelper.onServerStopping(event.getServer().m_129880_(Level.f_46428_));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.END || !event.haveTime()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        if (level.m_46472_() != Level.f_46428_) {
            return;
        }
        this.onTick((Level)level, (Boolean)SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.get(), (Boolean)SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.get(), (Double)SereneExtendedConfig.CUSTOM_DAY_LENGTH.get(), (Double)SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.get());
        CommonSnowBlockFeature.handleServerTick(level.m_7654_(), level);
    }

    @SubscribeEvent
    public void onConfigReload(TickEvent.ServerTickEvent event) {
        CommonSnowBlockFeature.onConfigReload((Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get(), (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get());
        SereneService.reloadConfig();
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        Level level = chunk.m_62953_();
        if (level.m_5776_()) {
            return;
        }
        if (level.m_46472_() != Level.f_46428_) {
            return;
        }
        CommonSnowBlockFeature.handleOnChunkLoad(chunk);
    }
}

