/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features.logic;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.storage.ChunkQueue;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;

public final class SnowLogic {
    private SnowLogic() {
    }

    public static void evaluate(ServerLevel level, Season.SubSeason currentSeason, ISeasonState seasonState, ISnowTrackedChunk tracked, ChunkPos chunkPos, boolean isLoadEvent, int maxHeight) {
        boolean allowApply;
        BlockPos samplePos = chunkPos.m_151394_(Math.max(level.m_141937_(), maxHeight));
        boolean coldEnough = CommonSnowBlockFeature.HANDLER.isColdEnoughForSnow(level, samplePos);
        boolean snowingNow = EnvironmentHelper.isRainning(level, samplePos);
        boolean bl = allowApply = snowingNow || isLoadEvent;
        if (coldEnough) {
            SnowHistorySavedData sd;
            float globalAvg = CommonSnowBlockFeature.computeGlobalAvg(level);
            int totalPositions = tracked.sereneseasonsplus$getTrackedColumnCount();
            int baseline = CommonSnowBlockFeature.computeGlobalMinSum(level);
            if (baseline > 0) {
                int baselineTotal = baseline * 256;
                int trackedTotal = tracked.sereneseasonsplus$getTotalSnowLayers();
                float ratio = (float)trackedTotal / (float)baselineTotal;
                if (ratio < 0.75f && allowApply) {
                    ChunkQueue.enqueueApply(chunkPos, currentSeason);
                    return;
                }
            }
            if (totalPositions == 0) {
                if (globalAvg > 0.5f && allowApply) {
                    ChunkQueue.enqueueApply(chunkPos, currentSeason);
                }
            } else {
                float currentAvg = (float)tracked.sereneseasonsplus$getTotalSnowLayers() / (float)totalPositions;
                float tolerance = Math.max(2.0f, globalAvg * 0.2f);
                if (Math.abs(currentAvg - globalAvg) > tolerance && allowApply) {
                    ChunkQueue.enqueueApply(chunkPos, currentSeason);
                }
            }
            if ((sd = SnowHistorySavedData.get(level)) != null && sd.currentStormId > 0) {
                ChunkQueue.enqueueApply(chunkPos, currentSeason);
            }
        } else {
            boolean inEarlyWinterNoStorm;
            boolean inWarmSeason = currentSeason.ordinal() >= Season.SubSeason.LATE_SPRING.ordinal() && currentSeason.ordinal() < Season.SubSeason.EARLY_WINTER.ordinal();
            boolean bl2 = inEarlyWinterNoStorm = currentSeason == Season.SubSeason.EARLY_WINTER && CommonSnowBlockFeature.HANDLER.getSnowStormsThisWinter(level) == 0;
            if (inWarmSeason || inEarlyWinterNoStorm) {
                ChunkQueue.enqueueMelt(chunkPos, false);
            }
        }
    }
}

