/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.mixin;

import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerSnowMixin {
    private static final String SSP = "SereneSeasonsPlus";

    @Inject(method={"write"}, at={@At(value="RETURN")}, cancellable=true)
    private static void ssp$write(ServerLevel level, ChunkAccess access, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag root = (CompoundTag)cir.getReturnValue();
        if (access instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("LastWinterId", tracked.sereneseasonsplus$getLastWinterId());
            tag.m_128405_("SurfaceHeight", tracked.sereneseasonsplus$getSurfaceHeight());
            tag.m_128350_("StormProgress", tracked.sereneseasonsplus$getStormProgress());
            tag.m_128405_("StormIdApplied", tracked.sereneseasonsplus$getStormIdApplied());
            tag.m_128405_("LastProgressTick", tracked.sereneseasonsplus$getLastProgressTick());
            ListTag list = new ListTag();
            for (Map.Entry<BlockPos, Integer> e : tracked.sereneseasonsplus$getSnowColumns().entrySet()) {
                CompoundTag entry = new CompoundTag();
                entry.m_128356_("Pos", e.getKey().m_121878_());
                entry.m_128405_("Layers", e.getValue().intValue());
                list.add((Object)entry);
            }
            tag.m_128365_("SnowColumns", (Tag)list);
            ListTag iceList = new ListTag();
            for (BlockPos p : tracked.sereneseasonsplus$getIceColumns()) {
                CompoundTag entry = new CompoundTag();
                entry.m_128356_("Pos", p.m_121878_());
                iceList.add((Object)entry);
            }
            tag.m_128365_("IceColumns", (Tag)iceList);
            root.m_128365_(SSP, (Tag)tag);
            cir.setReturnValue((Object)root);
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void ssp$read(ServerLevel level, PoiManager poi, ChunkPos pos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> cir) {
        ChunkAccess access = (ChunkAccess)cir.getReturnValue();
        if (access instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
            CompoundTag tag = nbt.m_128469_(SSP);
            if (!tag.m_128456_()) {
                BlockPos bp;
                if (tag.m_128441_("LastWinterId")) {
                    tracked.sereneseasonsplus$setLastWinterId(tag.m_128451_("LastWinterId"));
                }
                if (tag.m_128441_("SurfaceHeight")) {
                    tracked.sereneseasonsplus$setSurfaceHeight(tag.m_128451_("SurfaceHeight"));
                }
                if (tag.m_128441_("StormProgress")) {
                    tracked.sereneseasonsplus$setStormProgress(tag.m_128457_("StormProgress"));
                }
                if (tag.m_128441_("StormIdApplied")) {
                    tracked.sereneseasonsplus$setStormIdApplied(tag.m_128451_("StormIdApplied"));
                }
                if (tag.m_128441_("LastProgressTick")) {
                    tracked.sereneseasonsplus$setLastProgressTick(tag.m_128451_("LastProgressTick"));
                }
                tracked.sereneseasonsplus$getSnowColumns().clear();
                ListTag list = tag.m_128437_("SnowColumns", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag entry = list.m_128728_(i);
                    long posLong = entry.m_128454_("Pos");
                    int layers = entry.m_128451_("Layers");
                    bp = BlockPos.m_122022_((long)posLong);
                    tracked.sereneseasonsplus$getSnowColumns().put(bp.m_7949_(), layers);
                }
                tracked.sereneseasonsplus$getIceColumns().clear();
                ListTag iceList = tag.m_128437_("IceColumns", 10);
                for (int i = 0; i < iceList.size(); ++i) {
                    CompoundTag entry = iceList.m_128728_(i);
                    long posLong = entry.m_128454_("Pos");
                    bp = BlockPos.m_122022_((long)posLong);
                    tracked.sereneseasonsplus$getIceColumns().add(bp.m_7949_());
                }
            }
        }
    }
}

