/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.SereneSeasonsPlusNeoForge;
import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.DefaultSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import java.util.HashSet;
import java.util.Set;
import net.Gabou.gaboulibs.storage.SnowRecord;
import net.Gabou.gaboulibs.util.SnowGenerator;
import net.Gabou.projectatmosphere.manager.ForecastOrchestrator;
import net.Gabou.projectatmosphere.util.BiomeInstanceKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import sereneseasons.season.SeasonHooks;

public class NeoForgeSnowEnvironmentHandler
extends DefaultSnowEnvironmentHandler {
    private final Set<Integer> activeStorms = new HashSet<Integer>();

    @Override
    public int getBlocksToReplace(ServerLevel level, BlockPos playerPos) {
        if (!SereneSeasonsPlusNeoForge.isProjectAtmosphereLoaded) {
            float temperature = SeasonHooks.getBiomeTemperature((Level)level, (Holder)level.getBiome(playerPos), (BlockPos)playerPos);
            return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (BlockPos)playerPos) ? CommonSnowBlockFeature.calculateBlocksToReplace(temperature) : 0;
        }
        float temperature = ForecastOrchestrator.getCurrentTemperature((BiomeInstanceKey)new BiomeInstanceKey(((ResourceKey)level.getBiome(playerPos).unwrapKey().get()).location(), playerPos), (long)level.getDayTime());
        return temperature >= 0.5f ? CommonSnowBlockFeature.calculateBlocksToReplace1(temperature) : -level.random.nextInt(2, 6);
    }

    @Override
    public boolean isColdEnoughForSnow(ServerLevel level, BlockPos pos) {
        if (!SereneSeasonsPlusNeoForge.isProjectAtmosphereLoaded) {
            return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (BlockPos)pos);
        }
        float temperature = ForecastOrchestrator.getCurrentTemperature((BiomeInstanceKey)new BiomeInstanceKey(((ResourceKey)level.getBiome(pos).unwrapKey().get()).location(), pos), (long)level.getDayTime());
        return temperature < 0.5f;
    }

    @Override
    public void onRainCloudSpawned(ServerLevel level, int hashCode) {
        if (!EnvironmentHelper.isSnowySeason()) {
            return;
        }
        DefaultSnowEnvironmentHandler.SnowData data = this.getOrCreateData(level);
        if (data == null) {
            return;
        }
        data.activeStorms.add(hashCode);
    }

    @Override
    public void onRainCloudDespawned(ServerLevel level, int hashCode) {
        DefaultSnowEnvironmentHandler.SnowData data = this.getOrCreateData(level);
        if (data == null || !data.activeStorms.contains(hashCode)) {
            return;
        }
        data.activeStorms.remove(hashCode);
        SnowHistorySavedData hist = SnowHistorySavedData.get();
        SnowRecord rec = SnowGenerator.generateStormRecord((RandomSource)level.random);
        ++data.stormCount;
        hist.currentStormId = data.stormCount;
        hist.snowHistory.put(hist.currentStormId, rec);
        SnowHistorySavedData.get().snowHistory.put(hist.currentStormId, rec);
        hist.setDirty();
        this.persist(level, data);
    }
}

