/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.util;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.util.DefaultRainHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.Gabou.projectatmosphere.api.AtmoApi;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class ProjectAtmosphereRainHandler
extends DefaultRainHandler {
    private final Map<ServerLevel, PaState> states = new HashMap<ServerLevel, PaState>();

    @Override
    public boolean isRainingAt(ServerLevel level, BlockPos pos) {
        PaState s = this.states.get(level);
        if (s == null) {
            return AtmoApi.getInstance().isRainingOrThundering(level, pos);
        }
        return !s.activeRainClouds.isEmpty();
    }

    @Override
    public void checkAndUpdate(ServerLevel level) {
    }

    @Override
    public void onSimpleCloudsSpawned(ServerLevel level, int cloudId) {
        PaState s = this.states.computeIfAbsent(level, k -> new PaState());
        boolean wasRaining = !s.activeRainClouds.isEmpty();
        s.activeRainClouds.add(cloudId);
        if (!wasRaining && !s.activeRainClouds.isEmpty()) {
            CommonSnowBlockFeature.HANDLER.onRainCloudSpawned(level, cloudId);
            s.lastValue = true;
        }
    }

    @Override
    public void onSimpleCloudsDespawned(ServerLevel level, int cloudId) {
        PaState s = this.states.get(level);
        if (s == null) {
            return;
        }
        boolean wasRaining = !s.activeRainClouds.isEmpty();
        s.activeRainClouds.remove(cloudId);
        if (wasRaining && s.activeRainClouds.isEmpty()) {
            CommonSnowBlockFeature.HANDLER.onRainCloudDespawned(level, cloudId);
            s.lastValue = false;
        }
    }

    protected final class PaState {
        boolean lastValue;
        final Set<Integer> activeRainClouds = new HashSet<Integer>();

        protected PaState() {
        }
    }
}

