/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.util;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.util.HotSeason;
import com.Gabou.sereneseasonsplus.util.IEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.SnowySeason;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class NeoForgeEnvironmentHelper
implements IEnvironmentHelper {
    private static final Logger LOGGER = LogManager.getLogger((String)"EnvironmentHelper");
    private static Season.SubSeason season;
    private static boolean isHotSeason;
    private boolean isSnowySeason;

    @Override
    public boolean isHotSeason() {
        return isHotSeason;
    }

    @Override
    public boolean isSnowySeason() {
        return this.isSnowySeason;
    }

    @Override
    public Season.SubSeason getCurrentSeason() {
        return season;
    }

    @Override
    public boolean shouldRunMod() {
        return FMLEnvironment.dist.isDedicatedServer() || FMLEnvironment.dist.isClient() && Minecraft.getInstance().hasSingleplayerServer();
    }

    @Override
    public boolean isClient() {
        return FMLEnvironment.dist.isClient();
    }

    @Override
    public void onSeasonChange(ServerLevel serverLevel) {
        season = SeasonHelper.getSeasonState((Level)serverLevel).getSubSeason();
        LOGGER.info("Season changed to: {}", (Object)season);
        isHotSeason = HotSeason.isHotSeason(season);
        this.isSnowySeason = SnowySeason.isSnowySeason(season);
        CommonSnowBlockFeature.onSeasonChange(serverLevel);
    }

    static {
        isHotSeason = false;
    }
}

