/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.features.DefaultSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.features.ISnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.features.snowstorm.ISnowStormLevel;
import com.Gabou.sereneseasonsplus.storage.ChunkQueue;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.storage.SnowRecord;
import com.Gabou.sereneseasonsplus.tags.SSPTags;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import com.Gabou.sereneseasonsplus.util.MinecraftServerAccess;
import com.Gabou.sereneseasonsplus.util.SnowUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.season.Season;

public class CommonSnowBlockFeature {
    public static final Logger LOGGER = LogManager.getLogger((String)"SnowBlockReplacer");
    protected static final Map<ServerPlayer, BlockPos> playerPositions = new ConcurrentHashMap<ServerPlayer, BlockPos>();
    protected static int tickThresholdSnowReplacer;
    protected static int tickCounter;
    public static ISnowEnvironmentHandler HANDLER;
    protected static final int MAX_ATTEMPTS = 64;
    static final Map<BlockPos, QueuedChange> pendingChanges;
    static final Set<ChunkPos> chunksToDirty;
    static final Map<ChunkPos, Map<BlockPos, Integer>> pendingColumnMapUpdates;
    static final Map<ChunkPos, Set<BlockPos>> pendingIceAdds;
    static final List<BlockPos> snowPill;
    static int applyCycleTotal;
    static int applyCycleProcessed;
    public static boolean FAST_PILING_MODE;
    public static int ACTIVE_STORM_TARGET_TICKS;
    public static float STORM_INTENSITY_MULTIPLIER;
    private static final Queue<LevelChunk> snowQueue;

    public static void setFastPilingMode(boolean enabled) {
        FAST_PILING_MODE = enabled;
    }

    public static void setActiveStormTargetTicks(int ticks) {
        ACTIVE_STORM_TARGET_TICKS = Math.max(1, ticks);
    }

    public static void setStormIntensityMultiplier(float mult) {
        STORM_INTENSITY_MULTIPLIER = Math.max(0.01f, mult);
    }

    public static int getTickCounter() {
        return tickCounter;
    }

    public static void handleServerTick(MinecraftServer server, ServerLevel level) {
        int phase;
        if (level == null || level.m_5776_()) {
            return;
        }
        ++tickCounter;
        if (!snowQueue.isEmpty()) {
            CommonSnowBlockFeature.chunkHandler(level);
        }
        if (level.f_46441_.m_188503_(16) == 0 || EnvironmentHelper.isHotSeason() && level.f_46441_.m_188503_(2) == 0) {
            CommonSnowBlockFeature.updatePlayerPositions(level.m_6907_());
            CommonSnowBlockFeature.passifSnowBlocks(level);
            EnvironmentHelper.checkAndUpdate(level);
        }
        if ((phase = tickCounter % 5) == 0 && tickCounter > 10) {
            return;
        }
        if (phase == 1) {
            ChunkQueue.Entry entry;
            int processed = 0;
            if (ChunkQueue.isEmpty()) {
                ChunkQueue.shuffle();
            }
            while ((entry = ChunkQueue.poll()) != null) {
                LevelChunk chunk;
                boolean timeUp;
                boolean bl = timeUp = ((MinecraftServerAccess)server).sereneseasonsplus$tempsEcoule() && processed >= 5 || processed >= 20;
                if (timeUp) {
                    if (entry.type() == ChunkQueue.TaskType.APPLY_SNOW) {
                        CommonSnowBlockFeature.enqueueChunkForSnowApply(entry.pos(), entry.subSeason());
                        break;
                    }
                    CommonSnowBlockFeature.enqueueChunkForSnowMelt(entry.pos(), entry.fullClear());
                    break;
                }
                boolean changed = false;
                ChunkPos chunkPos = entry.pos();
                if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_) || (chunk = level.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false)) == null) continue;
                switch (entry.type()) {
                    case APPLY_SNOW: {
                        boolean synced = CommonSnowBlockFeature.syncTrackedColumnsToWorld(level, chunk);
                        if (!synced) {
                            synced = CommonSnowBlockFeature.applySnowHistoryPass(level, chunk);
                        }
                        if (!synced) {
                            synced = CommonSnowBlockFeature.applySnowPatternFromActiveRecord(level, chunk);
                        }
                        if (!synced) break;
                        chunksToDirty.add(chunkPos);
                        changed = true;
                        break;
                    }
                    case MELT_SNOW: {
                        changed = CommonSnowBlockFeature.meltSnowInChunk(level, chunkPos, entry.fullClear());
                        if (!changed) break;
                        chunksToDirty.add(chunkPos);
                    }
                }
                ++processed;
            }
        }
        if (phase == 2 || phase == 3 || phase == 4) {
            if (applyCycleProcessed == 0) {
                applyCycleTotal = pendingChanges.size();
            }
            int batch = (applyCycleTotal + 2) / 3;
            int toProcess = phase == 4 ? Integer.MAX_VALUE : batch;
            int applied = CommonSnowBlockFeature.processQueuedChanges(level, toProcess);
            applyCycleProcessed += applied;
            if (phase == 4) {
                CommonSnowBlockFeature.finalizeChunkBatch(level);
                applyCycleTotal = 0;
                applyCycleProcessed = 0;
            }
        }
    }

    public static void handleOnChunkLoad(LevelChunk chunk) {
        snowQueue.add(chunk);
    }

    private static void chunkHandler(ServerLevel level) {
        LevelChunk chunk;
        while ((chunk = snowQueue.poll()) != null) {
            boolean needAvail;
            if (!(chunk instanceof ISnowTrackedChunk)) continue;
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
            boolean needSurface = tracked.sereneseasonsplus$getSurfaceHeight() == -1;
            boolean bl = needAvail = tracked.sereneseasonsplus$getAvailableSnowColumns() == -1;
            if (!needSurface && !needAvail) continue;
            if (needSurface) {
                int centerX = chunk.m_7697_().m_151390_();
                int centerZ = chunk.m_7697_().m_151393_();
                int surfaceHeight = level.m_6924_(Heightmap.Types.WORLD_SURFACE, centerX, centerZ);
                tracked.sereneseasonsplus$setSurfaceHeight(surfaceHeight);
            }
            if (!needAvail) continue;
            int baseX = chunk.m_7697_().m_45604_();
            int baseZ = chunk.m_7697_().m_45605_();
            int count = 0;
            for (int dx = 0; dx < 16; ++dx) {
                for (int dz = 0; dz < 16; ++dz) {
                    int x = baseX + dx;
                    int z = baseZ + dz;
                    BlockPos surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                    if (surface == null) continue;
                    ++count;
                }
            }
            tracked.sereneseasonsplus$setAvailableSnowColumns(count);
        }
    }

    public static void enqueueChunkForSnowApply(ChunkPos chunkPos, Season.SubSeason subSeason) {
        ChunkQueue.enqueueApply(chunkPos, subSeason);
    }

    public static void enqueueChunkForSnowMelt(ChunkPos chunkPos, boolean fullClear) {
        ChunkQueue.enqueueMelt(chunkPos, fullClear);
    }

    protected static void passifSnowBlocks(ServerLevel level) {
        for (Map.Entry<ServerPlayer, BlockPos> entry : playerPositions.entrySet()) {
            ServerPlayer player = entry.getKey();
            BlockPos playerPos = entry.getValue();
            int simulationDistance = CommonSnowBlockFeature.getSimulationDistance(player);
            int radius = Mth.m_14045_((int)(simulationDistance * 16), (int)16, (int)64);
            int blocksToReplace = HANDLER.getBlocksToReplace(level, playerPos);
            if (blocksToReplace < 0) {
                if (!EnvironmentHelper.isRainning(level, playerPos)) continue;
                RandomSource random = level.f_46441_;
                for (int attempt = 0; attempt < 64; ++attempt) {
                    int z;
                    int dx = random.m_188503_(radius * 2 + 1) - radius;
                    int dz = random.m_188503_(radius * 2 + 1) - radius;
                    int x = playerPos.m_123341_() + dx;
                    BlockPos surface = CommonSnowBlockFeature.findPlacementTop(level, x, z = playerPos.m_123343_() + dz);
                    if (surface == null) continue;
                    BlockState st = level.m_8055_(surface);
                    BlockPos targetPos = surface;
                    int targetLayers = 1;
                    if (st.m_60713_(Blocks.f_50125_)) {
                        int cur = (Integer)st.m_61143_((Property)SnowLayerBlock.f_56581_);
                        if (cur < 8) {
                            targetLayers = cur + 1;
                        } else {
                            BlockPos above = surface.m_7494_();
                            if (!level.m_46859_(above)) continue;
                            targetPos = above;
                            targetLayers = 1;
                        }
                    } else if (st.m_60713_(Blocks.f_50127_)) {
                        BlockPos above = surface.m_7494_();
                        if (!level.m_46859_(above)) continue;
                        targetPos = above;
                        targetLayers = 1;
                    } else {
                        targetPos = surface;
                        targetLayers = 1;
                    }
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, targetPos, targetLayers, true, false)) {
                        BlockState ns = level.m_8055_(targetPos);
                        CommonSnowBlockFeature.accumulateColumnUpdate(targetPos, ns);
                    }
                    BlockPos below = new BlockPos(x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z), z).m_7495_();
                    CommonSnowBlockFeature.tryFreezeWaterAt(level, below);
                }
                continue;
            }
            for (int i = 0; i < blocksToReplace; ++i) {
                BlockPos targetPos = CommonSnowBlockFeature.findSnowBlockInRadius(level, playerPos, radius);
                if (targetPos == null) continue;
                SnowUtils.breakOrDecrementLayer((Level)level, targetPos);
                BlockState ns = level.m_8055_(targetPos);
                CommonSnowBlockFeature.accumulateColumnUpdate(targetPos, ns);
            }
        }
    }

    private static boolean syncTrackedColumnsToWorld(ServerLevel level, LevelChunk chunk) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        ChunkPos cp = chunk.m_7697_();
        if (pendingColumnMapUpdates.containsKey(cp) || pendingChanges.keySet().stream().anyMatch(p -> p.m_123341_() >> 4 == cp.f_45578_ && p.m_123343_() >> 4 == cp.f_45579_)) {
            return false;
        }
        Map<BlockPos, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
        if (columns == null) {
            return false;
        }
        Map<BlockPos, Integer> pending = pendingColumnMapUpdates.get(cp);
        if (pending != null && !pending.isEmpty()) {
            columns.putAll(pending);
        }
        if (columns.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Map.Entry<BlockPos, Integer> e : new ArrayList<Map.Entry<BlockPos, Integer>>(columns.entrySet())) {
            BlockPos pos = e.getKey();
            int wantedLayers = Mth.m_14045_((int)e.getValue(), (int)0, (int)8);
            if (wantedLayers <= 0) {
                changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, pos, false);
                columns.remove(pos);
                continue;
            }
            changed |= CommonSnowBlockFeature.placeOrQueueLayers(level, pos, wantedLayers, true, true);
        }
        return changed;
    }

    private static boolean applySnowHistoryPass(ServerLevel level, LevelChunk chunk) {
        SnowRecord combined;
        SnowRecord rec;
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.m_46469_().m_46215_(GameRules.f_254637_);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        int baseline = CommonSnowBlockFeature.computeGlobalMinSum(level);
        if (baseline <= 0) {
            return false;
        }
        boolean any = false;
        ChunkPos cp = chunk.m_7697_();
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos topCursor = new BlockPos.MutableBlockPos();
        int minY = level.m_141937_();
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                BlockState topState;
                BlockState s;
                int remaining;
                int x = baseX + dx;
                int z = baseZ + dz;
                BlockPos surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                if (surface == null) continue;
                int current = 0;
                cursor.m_122178_(surface.m_123341_(), surface.m_123342_(), surface.m_123343_());
                BlockState at = level.m_8055_((BlockPos)cursor);
                if (!at.m_60713_(Blocks.f_50125_) && !at.m_60713_(Blocks.f_50127_)) {
                    cursor.m_122184_(0, -1, 0);
                }
                while (cursor.m_123342_() >= minY) {
                    BlockState s2 = level.m_8055_((BlockPos)cursor);
                    if (s2.m_60713_(Blocks.f_50125_)) {
                        current += ((Integer)s2.m_61143_((Property)BlockStateProperties.f_61417_)).intValue();
                    } else {
                        if (!s2.m_60713_(Blocks.f_50127_)) break;
                        current += 8;
                    }
                    cursor.m_122184_(0, -1, 0);
                }
                int need = baseline - current;
                if (cap > 0) {
                    remaining = cap - current;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                topCursor.m_122178_(surface.m_123341_(), surface.m_123342_(), surface.m_123343_());
                while ((s = level.m_8055_((BlockPos)topCursor)).m_60713_(Blocks.f_50125_) || s.m_60713_(Blocks.f_50127_)) {
                    topCursor.m_122184_(0, 1, 0);
                }
                remaining = need;
                BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(topCursor.m_123341_(), topCursor.m_123342_(), topCursor.m_123343_());
                BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos(topCursor.m_123341_(), topCursor.m_123342_() - 1, topCursor.m_123343_());
                if (belowPos.m_123342_() >= minY && ((topState = level.m_8055_((BlockPos)belowPos)).m_60713_(Blocks.f_50125_) || topState.m_60713_(Blocks.f_50127_))) {
                    int currentLayers = topState.m_60713_(Blocks.f_50127_) ? 8 : (Integer)topState.m_61143_((Property)BlockStateProperties.f_61417_);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && remaining > 0) {
                        int add = Math.min(freeSpace, remaining);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)belowPos, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(belowPos.m_7949_(), targetLayers);
                            any = true;
                        }
                        remaining -= add;
                    }
                    if (remaining <= 0) continue;
                }
                while (remaining > 0 && placePos.m_123342_() < level.m_151558_()) {
                    int toPlace = Math.min(8, remaining);
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)placePos, toPlace, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(placePos.m_7949_(), toPlace);
                        any = true;
                    }
                    remaining -= toPlace;
                    placePos.m_122184_(0, 1, 0);
                }
            }
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get(level);
        if (sd != null && (sd.currentStormId > 0 ? (rec = sd.snowHistory.get(sd.currentStormId)) != null : (combined = CommonSnowBlockFeature.aggregateFinishedStormSums(level)) != null)) {
            return CommonSnowBlockFeature.applySnowPattern(level, chunk, rec, level.f_46441_) || any;
        }
        return any;
    }

    public static boolean tryFreezeWaterAt(ServerLevel level, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (!state.m_60713_(Blocks.f_49990_)) {
            return false;
        }
        BlockPos sample = pos.m_7494_();
        if (!EnvironmentHelper.isRainning(level, sample)) {
            return false;
        }
        if (!CommonSnowBlockFeature.isExposedToSky(level, sample)) {
            return false;
        }
        if (!HANDLER.isColdEnoughForSnow(level, sample)) {
            return false;
        }
        if (!CommonSnowBlockFeature.isWaterBiome(level, pos)) {
            return false;
        }
        BlockState ice = Blocks.f_50126_.m_49966_();
        if (level.m_46597_(pos, ice)) {
            CommonSnowBlockFeature.accumulateColumnUpdate(pos, ice);
            return true;
        }
        return false;
    }

    private static boolean isWaterBiome(ServerLevel level, BlockPos pos) {
        try {
            Holder holder = level.m_204166_(pos);
            return holder.m_203543_().map(key -> {
                ResourceLocation rl = key.m_135782_();
                String path = rl.m_135815_();
                return path.contains("ocean") || path.contains("river");
            }).orElse(false);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean applySnowPatternFromActiveRecord(ServerLevel level, LevelChunk chunk) {
        SnowRecord rec;
        SnowHistorySavedData sd = SnowHistorySavedData.get(level);
        if (sd != null && sd.currentStormId > 0 && (rec = sd.snowHistory.get(sd.currentStormId)) != null) {
            return CommonSnowBlockFeature.applySnowPattern(level, chunk, rec, level.f_46441_);
        }
        return false;
    }

    private static boolean applySnowPattern(ServerLevel level, LevelChunk chunk, SnowRecord record, RandomSource rng) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.m_46469_().m_46215_(GameRules.f_254637_);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        ChunkPos cp = chunk.m_7697_();
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        float avg = Math.max(0.0f, record.avgLayers);
        float coverage = Mth.m_14036_((float)(avg / 8.0f), (float)0.1f, (float)0.85f);
        boolean any = false;
        float progress = 1.0f;
        int currentTick = CommonSnowBlockFeature.getTickCounter();
        if (!FAST_PILING_MODE) {
            int activeId;
            SnowHistorySavedData sd = SnowHistorySavedData.get(level);
            int n = activeId = sd != null ? sd.currentStormId : 0;
            if (activeId > 0) {
                if (tracked.sereneseasonsplus$getStormIdApplied() != activeId) {
                    tracked.sereneseasonsplus$setStormIdApplied(activeId);
                    tracked.sereneseasonsplus$setStormProgress(0.0f);
                    tracked.sereneseasonsplus$setLastProgressTick(currentTick);
                }
                float cur = tracked.sereneseasonsplus$getStormProgress();
                int last = tracked.sereneseasonsplus$getLastProgressTick();
                int dt = Math.max(1, currentTick - last);
                float delta = (float)dt / (float)Math.max(1, ACTIVE_STORM_TARGET_TICKS);
                cur = Mth.m_14036_((float)(cur + delta * STORM_INTENSITY_MULTIPLIER), (float)0.0f, (float)1.0f);
                tracked.sereneseasonsplus$setStormProgress(cur);
                tracked.sereneseasonsplus$setLastProgressTick(currentTick);
                progress = cur;
            }
        }
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int desired;
                BlockPos surface;
                double wave;
                int x = baseX + dx;
                int z = baseZ + dz;
                float white = rng.m_188501_();
                float noise = Mth.m_14036_((float)((float)((double)white * 0.7 + ((wave = Math.sin((double)x * 0.12 + (double)z * 0.12)) + 1.0) * 0.15)), (float)0.0f, (float)1.0f);
                if (noise > coverage || (surface = CommonSnowBlockFeature.findPlacementTop(level, x, z)) == null) continue;
                int minL = Math.max(1, Math.round(record.minLayers));
                int maxL = Math.max(minL, Math.round(record.maxLayers));
                int span = Math.max(1, maxL - minL + 1);
                int pick = minL + rng.m_188503_(span);
                int towardAvg = Math.round(Mth.m_14179_((float)0.35f, (float)pick, (float)avg));
                int totalLayers = Math.max(1, towardAvg);
                int n = desired = FAST_PILING_MODE ? totalLayers : Math.max(0, Math.round((float)totalLayers * progress));
                if (desired <= 0) continue;
                BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(surface.m_123341_(), surface.m_123342_(), surface.m_123343_());
                int minY = level.m_141937_();
                int currentTotal = 0;
                BlockPos.MutableBlockPos down = new BlockPos.MutableBlockPos(surface.m_123341_(), surface.m_123342_(), surface.m_123343_());
                BlockState at = level.m_8055_((BlockPos)down);
                if (!at.m_60713_(Blocks.f_50125_) && !at.m_60713_(Blocks.f_50127_)) {
                    down.m_122184_(0, -1, 0);
                }
                while (down.m_123342_() >= minY) {
                    BlockState s = level.m_8055_((BlockPos)down);
                    if (s.m_60713_(Blocks.f_50125_)) {
                        currentTotal += ((Integer)s.m_61143_((Property)BlockStateProperties.f_61417_)).intValue();
                    } else {
                        if (!s.m_60713_(Blocks.f_50127_)) break;
                        currentTotal += 8;
                    }
                    down.m_122184_(0, -1, 0);
                }
                int need = desired - currentTotal;
                if (cap > 0) {
                    int remaining = cap - currentTotal;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                BlockState existing = level.m_8055_((BlockPos)cursor);
                if (existing.m_60713_(Blocks.f_50125_) || existing.m_60713_(Blocks.f_50127_)) {
                    int currentLayers = existing.m_60713_(Blocks.f_50127_) ? 8 : (Integer)existing.m_61143_((Property)BlockStateProperties.f_61417_);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && need > 0) {
                        int add = Math.min(freeSpace, need);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(cursor.m_7949_(), targetLayers);
                            any = true;
                        }
                        need -= add;
                    }
                    if (need > 0) {
                        cursor.m_122184_(0, 1, 0);
                    }
                }
                while (need >= 8 && cursor.m_123342_() < level.m_151558_()) {
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, 8, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(cursor.m_7949_(), 8);
                        any = true;
                    }
                    need -= 8;
                    cursor.m_122184_(0, 1, 0);
                }
                if (need <= 0 || cursor.m_123342_() >= level.m_151558_() || !CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, need, true, true)) continue;
                tracked.sereneseasonsplus$getSnowColumns().put(cursor.m_7949_(), need);
                any = true;
            }
        }
        return any;
    }

    private static boolean applyCombinedFinishedPattern(ServerLevel level, LevelChunk chunk, SnowRecord combined, RandomSource rng) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.m_46469_().m_46215_(GameRules.f_254637_);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        ChunkPos cp = chunk.m_7697_();
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        int minL = Math.max(0, Math.round(combined.minLayers));
        int avgL = Math.max(minL, Math.round(combined.avgLayers));
        int maxL = Math.max(avgL, Math.round(combined.maxLayers));
        boolean any = false;
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                BlockPos surface;
                double wave;
                int x = baseX + dx;
                int z = baseZ + dz;
                float white = rng.m_188501_();
                float noise = Mth.m_14036_((float)((float)((double)white * 0.7 + ((wave = Math.sin((double)x * 0.12 + (double)z * 0.12)) + 1.0) * 0.15)), (float)0.0f, (float)1.0f);
                int pick = minL + Math.round(noise * (float)Math.max(0, maxL - minL));
                int towardAvg = Math.round(Mth.m_14179_((float)0.35f, (float)pick, (float)avgL));
                int desired = Math.max(minL, towardAvg);
                if (desired <= 0 || (surface = CommonSnowBlockFeature.findPlacementTop(level, x, z)) == null) continue;
                int minY = level.m_141937_();
                int currentTotal = 0;
                BlockPos.MutableBlockPos down = new BlockPos.MutableBlockPos(surface.m_123341_(), surface.m_123342_(), surface.m_123343_());
                BlockState at = level.m_8055_((BlockPos)down);
                if (!at.m_60713_(Blocks.f_50125_) && !at.m_60713_(Blocks.f_50127_)) {
                    down.m_122184_(0, -1, 0);
                }
                while (down.m_123342_() >= minY) {
                    BlockState s = level.m_8055_((BlockPos)down);
                    if (s.m_60713_(Blocks.f_50125_)) {
                        currentTotal += ((Integer)s.m_61143_((Property)BlockStateProperties.f_61417_)).intValue();
                    } else {
                        if (!s.m_60713_(Blocks.f_50127_)) break;
                        currentTotal += 8;
                    }
                    down.m_122184_(0, -1, 0);
                }
                int need = desired - currentTotal;
                if (cap > 0) {
                    int remaining = cap - currentTotal;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(surface.m_123341_(), surface.m_123342_(), surface.m_123343_());
                BlockState existing = level.m_8055_((BlockPos)cursor);
                if (existing.m_60713_(Blocks.f_50125_) || existing.m_60713_(Blocks.f_50127_)) {
                    int currentLayers = existing.m_60713_(Blocks.f_50127_) ? 8 : (Integer)existing.m_61143_((Property)BlockStateProperties.f_61417_);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && need > 0) {
                        int add = Math.min(freeSpace, need);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(cursor.m_7949_(), targetLayers);
                            any = true;
                        }
                        need -= add;
                    }
                    if (need > 0) {
                        cursor.m_122184_(0, 1, 0);
                    }
                }
                while (need >= 8 && cursor.m_123342_() < level.m_151558_()) {
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, 8, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(cursor.m_7949_(), 8);
                        any = true;
                    }
                    need -= 8;
                    cursor.m_122184_(0, 1, 0);
                }
                if (need <= 0 || cursor.m_123342_() >= level.m_151558_() || !CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, need, true, true)) continue;
                tracked.sereneseasonsplus$getSnowColumns().put(cursor.m_7949_(), need);
                any = true;
            }
        }
        return any;
    }

    private static boolean isChunkAtOrAboveSnowCap(ServerLevel level, LevelChunk chunk, int capLayers) {
        ChunkPos cp = chunk.m_7697_();
        int baseX = cp.m_45604_();
        int baseZ = cp.m_45605_();
        BlockPos.MutableBlockPos down = new BlockPos.MutableBlockPos();
        int minY = level.m_141937_();
        for (int dx = 0; dx < 16; ++dx) {
            block1: for (int dz = 0; dz < 16; ++dz) {
                int x = baseX + dx;
                int z = baseZ + dz;
                BlockPos surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                if (surface == null) continue;
                int total = 0;
                down.m_122178_(surface.m_123341_(), surface.m_123342_(), surface.m_123343_());
                BlockState at = level.m_8055_((BlockPos)down);
                if (!at.m_60713_(Blocks.f_50125_) && !at.m_60713_(Blocks.f_50127_)) {
                    down.m_122184_(0, -1, 0);
                }
                while (down.m_123342_() >= minY) {
                    BlockState s = level.m_8055_((BlockPos)down);
                    if (s.m_60713_(Blocks.f_50125_)) {
                        total += ((Integer)s.m_61143_((Property)BlockStateProperties.f_61417_)).intValue();
                    } else {
                        if (!s.m_60713_(Blocks.f_50127_)) continue block1;
                        total += 8;
                    }
                    if (total >= capLayers) {
                        return true;
                    }
                    down.m_122184_(0, -1, 0);
                }
            }
        }
        return false;
    }

    public static boolean meltSnowInChunk(ServerLevel level, ChunkPos chunkPos, boolean fullClear) {
        LevelChunk chunk = level.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        Map<BlockPos, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
        if (columns == null || columns.isEmpty()) {
            return CommonSnowBlockFeature.meltTrackedIce(level, tracked);
        }
        boolean changed = false;
        if (fullClear) {
            for (BlockPos pos : new ArrayList<BlockPos>(columns.keySet())) {
                changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, pos, false);
                columns.remove(pos);
            }
            return changed;
        }
        HashMap<Long, BlockPos> topByColumn = new HashMap<Long, BlockPos>();
        for (BlockPos p : columns.keySet()) {
            long key = (long)p.m_123341_() << 32 ^ (long)p.m_123343_() & 0xFFFFFFFFL;
            BlockPos cur = (BlockPos)topByColumn.get(key);
            if (cur != null && p.m_123342_() <= cur.m_123342_()) continue;
            topByColumn.put(key, p.m_7949_());
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        block2: for (BlockPos top : topByColumn.values()) {
            BlockState state = level.m_8055_(top);
            if (state.m_60713_(Blocks.f_50127_)) {
                changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, top, 7, false);
                columns.put(top.m_7949_(), 7);
                continue;
            }
            if (state.m_60713_(Blocks.f_50125_)) {
                int layers = (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_);
                if (layers <= 1) {
                    changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, top, false);
                    columns.remove(top);
                    continue;
                }
                changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, top, layers - 1, false);
                columns.put(top.m_7949_(), layers - 1);
                continue;
            }
            int minY = level.m_141937_();
            cursor.m_122178_(top.m_123341_(), top.m_123342_(), top.m_123343_());
            while (cursor.m_123342_() >= minY) {
                BlockState s = level.m_8055_((BlockPos)cursor);
                if (s.m_60713_(Blocks.f_50127_)) {
                    changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, cursor.m_7949_(), 7, false);
                    columns.put(cursor.m_7949_(), 7);
                    continue block2;
                }
                if (s.m_60713_(Blocks.f_50125_)) {
                    int l = (Integer)s.m_61143_((Property)BlockStateProperties.f_61417_);
                    if (l <= 1) {
                        changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, cursor.m_7949_(), false);
                        columns.remove(cursor);
                        continue block2;
                    }
                    changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, cursor.m_7949_(), l - 1, false);
                    columns.put(cursor.m_7949_(), l - 1);
                    continue block2;
                }
                cursor.m_122184_(0, -1, 0);
            }
        }
        return changed |= CommonSnowBlockFeature.meltTrackedIce(level, tracked);
    }

    private static boolean meltTrackedIce(ServerLevel level, ISnowTrackedChunk tracked) {
        boolean changed = false;
        HashSet<BlockPos> copy = new HashSet<BlockPos>(tracked.sereneseasonsplus$getIceColumns());
        for (BlockPos p : copy) {
            BlockState st = level.m_8055_(p);
            if (st.m_60713_(Blocks.f_50126_)) {
                CommonSnowBlockFeature.queueChange(p, Blocks.f_49990_.m_49966_(), 34);
                tracked.sereneseasonsplus$getIceColumns().remove(p);
                changed = true;
                continue;
            }
            tracked.sereneseasonsplus$getIceColumns().remove(p);
        }
        return changed;
    }

    private static BlockPos findPlacementTop(ServerLevel level, int x, int z) {
        int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        BlockPos base = new BlockPos(x, y, z);
        BlockState at = level.m_8055_(base);
        BlockState snow = Blocks.f_50125_.m_49966_();
        if ((level.m_46859_(base) || at.m_247087_()) && snow.m_60710_((LevelReader)level, base) && CommonSnowBlockFeature.isExposedToSky(level, base)) {
            return base;
        }
        BlockPos up = base.m_7494_();
        if (snow.m_60710_((LevelReader)level, up) && level.m_46859_(up) && CommonSnowBlockFeature.isExposedToSky(level, up)) {
            return up;
        }
        if (at.m_60713_(Blocks.f_50125_) && CommonSnowBlockFeature.isExposedToSky(level, base)) {
            return base;
        }
        return null;
    }

    private static boolean isExposedToSky(ServerLevel level, BlockPos pos) {
        if (pos.equals((Object)new BlockPos(-98, 63, -104))) {
            boolean bl = false;
        }
        try {
            return level.m_46861_(pos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static boolean placeOrQueueLayers(ServerLevel level, BlockPos pos, int targetLayers, boolean allowPlace, boolean queue) {
        if (queue) {
            return CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, pos, targetLayers, allowPlace);
        }
        targetLayers = Mth.m_14045_((int)targetLayers, (int)1, (int)8);
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_(Blocks.f_50125_) && state.m_61138_((Property)SnowLayerBlock.f_56581_)) {
            if (allowPlace && !CommonSnowBlockFeature.isExposedToSky(level, pos)) {
                return false;
            }
            int current = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
            if (current == targetLayers) {
                return false;
            }
            BlockState newState = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(targetLayers));
            return level.m_7731_(pos, newState, 2);
        }
        if (state.m_60713_(Blocks.f_50127_)) {
            if (allowPlace && !CommonSnowBlockFeature.isExposedToSky(level, pos)) {
                return false;
            }
            if (targetLayers == 8) {
                return false;
            }
            BlockState newState = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(targetLayers));
            return level.m_7731_(pos, newState, 2);
        }
        if (allowPlace && (level.m_46859_(pos) || state.m_247087_())) {
            if (!CommonSnowBlockFeature.isExposedToSky(level, pos)) {
                return false;
            }
            BlockState snow = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(targetLayers));
            if (!snow.m_60710_((LevelReader)level, pos)) {
                return false;
            }
            return level.m_7731_(pos, snow, 2);
        }
        return false;
    }

    private static boolean queueSnowLayersIfNeeded(ServerLevel level, BlockPos pos, int targetLayers, boolean allowPlace) {
        targetLayers = Mth.m_14045_((int)targetLayers, (int)1, (int)8);
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_(Blocks.f_50125_) && state.m_61138_((Property)SnowLayerBlock.f_56581_)) {
            if (allowPlace && !CommonSnowBlockFeature.isExposedToSky(level, pos)) {
                return false;
            }
            int current = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
            if (current == targetLayers) {
                return false;
            }
            BlockState newState = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(targetLayers));
            CommonSnowBlockFeature.queueChange(pos, newState, 2);
            snowPill.add(pos.m_7949_());
            return true;
        }
        if (state.m_60713_(Blocks.f_50127_)) {
            if (allowPlace && !CommonSnowBlockFeature.isExposedToSky(level, pos)) {
                return false;
            }
            if (targetLayers == 8) {
                return false;
            }
            BlockState newState = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(targetLayers));
            CommonSnowBlockFeature.queueChange(pos, newState, 2);
            snowPill.add(pos.m_7949_());
            return true;
        }
        if (allowPlace && (level.m_46859_(pos) || state.m_247087_())) {
            if (!CommonSnowBlockFeature.isExposedToSky(level, pos)) {
                return false;
            }
            BlockState snow = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(targetLayers));
            if (!snow.m_60710_((LevelReader)level, pos)) {
                return false;
            }
            CommonSnowBlockFeature.queueChange(pos, snow, 2);
            snowPill.add(pos.m_7949_());
            return true;
        }
        return false;
    }

    protected static BlockPos findSnowBlockInRadius(ServerLevel level, BlockPos center, int radius) {
        ServerChunkCache chunkSource = level.m_7726_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int chunkZ;
                int chunkX = center.m_123341_() + x >> 4;
                LevelChunk chunk = chunkSource.m_62227_(chunkX, chunkZ = center.m_123343_() + z >> 4, false);
                if (chunk == null) continue;
                for (int y = -5; y <= 5; ++y) {
                    pos.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    if (pos.m_123342_() < level.m_141937_() || pos.m_123342_() >= level.m_151558_() || !chunk.m_8055_((BlockPos)pos).m_204336_(SSPTags.Blocks.MELTABLE)) continue;
                    return pos.m_7949_();
                }
            }
        }
        return null;
    }

    private static boolean queueClearIfNeeded(ServerLevel level, BlockPos pos, boolean toWater) {
        BlockState wanted = toWater ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
        BlockState current = level.m_8055_(pos);
        if (current.m_60713_(wanted.m_60734_())) {
            return false;
        }
        CommonSnowBlockFeature.queueChange(pos, wanted, 34);
        return true;
    }

    private static void queueChange(BlockPos pos, BlockState state, int flags) {
        BlockPos imm = pos.m_7949_();
        pendingChanges.put(imm, new QueuedChange(imm, state, flags));
    }

    public static void accumulateColumnUpdate(BlockPos pos, BlockState state) {
        ChunkPos cp = new ChunkPos(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (state.m_60713_(Blocks.f_50126_)) {
            pendingIceAdds.computeIfAbsent(cp, k -> new HashSet()).add(pos.m_7949_());
            chunksToDirty.add(cp);
            return;
        }
        int val = state.m_60713_(Blocks.f_50125_) && state.m_61138_((Property)SnowLayerBlock.f_56581_) ? (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_) : (state.m_60713_(Blocks.f_50127_) ? 8 : 0);
        pendingColumnMapUpdates.computeIfAbsent(cp, k -> new HashMap()).put(pos.m_7949_(), val);
        chunksToDirty.add(cp);
    }

    private static int processQueuedChanges(ServerLevel level, int limit) {
        int applied;
        if (pendingChanges.isEmpty()) {
            return 0;
        }
        Iterator<Map.Entry<BlockPos, QueuedChange>> it = pendingChanges.entrySet().iterator();
        for (applied = 0; it.hasNext() && applied < limit; ++applied) {
            Map.Entry<BlockPos, QueuedChange> e = it.next();
            QueuedChange qc = e.getValue();
            boolean changed = level.m_7731_(qc.pos(), qc.state(), qc.flags());
            if (changed) {
                CommonSnowBlockFeature.accumulateColumnUpdate(qc.pos(), qc.state());
            }
            it.remove();
        }
        return applied;
    }

    private static void finalizeChunkBatch(ServerLevel level) {
        ChunkPos cp;
        if (!pendingColumnMapUpdates.isEmpty()) {
            for (Map.Entry<ChunkPos, Object> entry : pendingColumnMapUpdates.entrySet()) {
                LevelChunk chunk;
                cp = entry.getKey();
                Map updates = (Map)entry.getValue();
                if (!level.m_7232_(cp.f_45578_, cp.f_45579_) || !((chunk = level.m_7726_().m_62227_(cp.f_45578_, cp.f_45579_, false)) instanceof ISnowTrackedChunk)) continue;
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                Map<BlockPos, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
                for (Map.Entry up : updates.entrySet()) {
                    int val = (Integer)up.getValue();
                    if (val <= 0) {
                        columns.remove(up.getKey());
                        continue;
                    }
                    columns.put(((BlockPos)up.getKey()).m_7949_(), Mth.m_14045_((int)val, (int)1, (int)8));
                }
            }
            pendingColumnMapUpdates.clear();
        }
        if (!pendingIceAdds.isEmpty()) {
            for (Map.Entry<ChunkPos, Object> entry : pendingIceAdds.entrySet()) {
                LevelChunk chunk;
                cp = entry.getKey();
                if (!level.m_7232_(cp.f_45578_, cp.f_45579_) || !((chunk = level.m_7726_().m_62227_(cp.f_45578_, cp.f_45579_, false)) instanceof ISnowTrackedChunk)) continue;
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                Set<BlockPos> set = tracked.sereneseasonsplus$getIceColumns();
                for (BlockPos p : (Set)entry.getValue()) {
                    if (!level.m_8055_(p).m_60713_(Blocks.f_50126_)) continue;
                    set.add(p.m_7949_());
                }
            }
            pendingIceAdds.clear();
        }
        for (ChunkPos chunkPos : chunksToDirty) {
            LevelChunk chunk;
            if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_) || (chunk = level.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false)) == null) continue;
            chunk.m_8092_(true);
        }
        chunksToDirty.clear();
        pendingChanges.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
    }

    protected static void updatePlayerPositions(Iterable<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            playerPositions.put(player, player.m_20183_());
        }
    }

    protected static int getSimulationDistance(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        return server != null ? server.m_6846_().m_11312_() : 10;
    }

    public static int computeGlobalAvg(ServerLevel level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get(level);
        if (sd == null || sd.snowHistory.isEmpty()) {
            return 0;
        }
        int excludeId = sd.currentStormId;
        float total = 0.0f;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord rec = e.getValue();
            total += Math.max(0.0f, rec.avgLayers);
        }
        return Math.round(total);
    }

    public static int computeGlobalMinSum(ServerLevel level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get(level);
        if (sd == null || sd.snowHistory.isEmpty()) {
            return 0;
        }
        int excludeId = sd.currentStormId;
        float sumMin = 0.0f;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord rec = e.getValue();
            sumMin += Math.max(0.0f, rec.minLayers);
        }
        return Math.max(0, Math.round(sumMin));
    }

    private static SnowRecord aggregateFinishedStormMinMax(ServerLevel level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get(level);
        if (sd == null || sd.snowHistory.isEmpty()) {
            return null;
        }
        int excludeId = sd.currentStormId;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float avg = 0.0f;
        int count = 0;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord r = e.getValue();
            min = Math.min(min, r.minLayers);
            max = Math.max(max, r.maxLayers);
            avg += r.avgLayers;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return new SnowRecord(min, avg / (float)count, max, null);
    }

    private static SnowRecord aggregateFinishedStormSums(ServerLevel level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get(level);
        if (sd == null || sd.snowHistory.isEmpty()) {
            return null;
        }
        int excludeId = sd.currentStormId;
        float sumMin = 0.0f;
        float sumAvg = 0.0f;
        float sumMax = 0.0f;
        int count = 0;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord r = e.getValue();
            sumMin += Math.max(0.0f, r.minLayers);
            sumAvg += Math.max(0.0f, r.avgLayers);
            sumMax += Math.max(0.0f, r.maxLayers);
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return new SnowRecord(sumMin, sumAvg, sumMax, null);
    }

    public static void onServerStarting(int config, boolean snowStorm) {
        tickThresholdSnowReplacer = config;
        tickCounter = 0;
        playerPositions.clear();
        ChunkQueue.clear();
        pendingColumnMapUpdates.clear();
        pendingChanges.clear();
        pendingIceAdds.clear();
        chunksToDirty.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
    }

    public static void onServerStopping() {
        playerPositions.clear();
        tickCounter = 0;
        ChunkQueue.clear();
        pendingChanges.clear();
        chunksToDirty.clear();
        pendingColumnMapUpdates.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
        pendingIceAdds.clear();
    }

    public static void onConfigReload(int config, boolean snowStorm) {
        tickThresholdSnowReplacer = config;
    }

    public static void onSeasonChange(ServerLevel level) {
        ChunkQueue.clear();
    }

    protected static int calculateBlocksToReplace1(float temperature) {
        return (int)Math.ceil(temperature / 5.0f);
    }

    protected static int calculateBlocksToReplace(float temperature) {
        if (temperature < 0.2f) {
            return 1;
        }
        return temperature < 0.5f ? 3 : 25;
    }

    public static boolean isSnowStormAt(ServerLevel level, ChunkPos pos) {
        if (level instanceof ISnowStormLevel) {
            ISnowStormLevel stormLevel = (ISnowStormLevel)level;
            return stormLevel.sereneseasonsplus$isSnowStormAt(pos);
        }
        return false;
    }

    public static int getSnowStormIntensity(ServerLevel level, ChunkPos pos) {
        if (level instanceof ISnowStormLevel) {
            ISnowStormLevel stormLevel = (ISnowStormLevel)level;
            return stormLevel.sereneseasonsplus$getSnowStormIntensity(pos);
        }
        return 0;
    }

    static {
        tickCounter = 0;
        HANDLER = new DefaultSnowEnvironmentHandler();
        pendingChanges = new LinkedHashMap<BlockPos, QueuedChange>();
        chunksToDirty = new HashSet<ChunkPos>();
        pendingColumnMapUpdates = new HashMap<ChunkPos, Map<BlockPos, Integer>>();
        pendingIceAdds = new HashMap<ChunkPos, Set<BlockPos>>();
        snowPill = new ArrayList<BlockPos>();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
        FAST_PILING_MODE = false;
        ACTIVE_STORM_TARGET_TICKS = 8000;
        STORM_INTENSITY_MULTIPLIER = 1.0f;
        snowQueue = new ConcurrentLinkedQueue<LevelChunk>();
    }

    public record QueuedChange(BlockPos pos, BlockState state, int flags) {
    }
}

