/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.mixin;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.logic.SnowLogic;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.season.SeasonHooks;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin {
    @Shadow
    @Final
    private static Logger f_8566_;
    @Shadow
    @Final
    private ServerChunkCache f_8547_;
    @Unique
    private static final int MIN_TICKS_INTERVALLES = 10;

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    private void ssp$handleSnowAndIce(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        ServerLevel level = (ServerLevel)this;
        ProfilerFiller profiler = level.m_46473_();
        if (level.m_46472_() == Level.f_46428_) {
            boolean doEval;
            int t = CommonSnowBlockFeature.getTickCounter();
            ChunkPos cpos = chunk.m_7697_();
            boolean bl = doEval = ((cpos.f_45578_ ^ cpos.f_45579_ ^ t) & 0xF) == 0;
            if (doEval) {
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                Season.SubSeason currentSeason = EnvironmentHelper.getCurrentSeason();
                ISeasonState seasonState = SeasonHelper.getSeasonState((Level)level);
                if (seasonState != null && currentSeason != null) {
                    if (tracked.sereneseasonsplus$getSurfaceHeight() == -1) {
                        int surfaceHeightCache = level.m_6924_(Heightmap.Types.WORLD_SURFACE, cpos.m_151390_(), cpos.m_151393_());
                        tracked.sereneseasonsplus$setSurfaceHeight(surfaceHeightCache);
                    }
                    int surfaceHeight = tracked.sereneseasonsplus$getSurfaceHeight();
                    SnowLogic.evaluate(level, currentSeason, seasonState, tracked, cpos, true, surfaceHeight);
                }
            }
        }
        profiler.m_6182_("iceandsnow");
        if (level.f_46441_.m_188503_(16) == 0) {
            int j = chunk.m_7697_().m_45604_();
            int k = chunk.m_7697_().m_45605_();
            BlockPos blockPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, level.m_46496_(j, 0, k, 15));
            BlockPos blockPos2 = blockPos.m_7495_();
            Biome biome = (Biome)level.m_204166_(blockPos).m_203334_();
            if (EnvironmentHelper.isRainning(level, blockPos) && CommonSnowBlockFeature.HANDLER.isColdEnoughForSnow(level, blockPos)) {
                CommonSnowBlockFeature.tryFreezeWaterAt(level, blockPos2);
            }
            if (EnvironmentHelper.isRainning(level, blockPos) && level.m_46861_(blockPos)) {
                Biome.Precipitation precipitation;
                int maxSnow = level.m_46469_().m_46215_(GameRules.f_254637_);
                if (maxSnow > 0 && SeasonHooks.shouldSnowHook((Biome)biome, (LevelReader)level, (BlockPos)blockPos)) {
                    BlockState state = level.m_8055_(blockPos);
                    if (state.m_60713_(Blocks.f_50125_)) {
                        int layers = (Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_);
                        if (layers < Math.min(maxSnow, 8)) {
                            BlockState next = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers + 1));
                            Block.m_49897_((BlockState)state, (BlockState)next, (LevelAccessor)level, (BlockPos)blockPos);
                            if (level.m_46597_(blockPos, next)) {
                                CommonSnowBlockFeature.accumulateColumnUpdate(blockPos, next);
                            }
                        }
                    } else {
                        BlockState snow = Blocks.f_50125_.m_49966_();
                        if (level.m_46597_(blockPos, snow)) {
                            CommonSnowBlockFeature.accumulateColumnUpdate(blockPos, snow);
                        }
                    }
                }
                if ((precipitation = biome.m_264600_(blockPos2)) != Biome.Precipitation.NONE) {
                    BlockState base = level.m_8055_(blockPos2);
                    base.m_60734_().m_141997_(base, (Level)level, blockPos2, precipitation);
                }
            }
        }
    }
}

