/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.ISnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.storage.SnowRecord;
import com.Gabou.sereneseasonsplus.storage.SnowSavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.SnowGenerator;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_6880;
import sereneseasons.season.SeasonHooks;

public class DefaultSnowEnvironmentHandler
implements ISnowEnvironmentHandler {
    protected SnowData overworldData;

    protected boolean isOverworld(class_3218 level) {
        return level.method_27983() == class_1937.field_25179;
    }

    protected SnowData getOrCreateData(class_3218 level) {
        if (this.overworldData == null) {
            this.overworldData = new SnowData();
            this.restore(level, this.overworldData);
        }
        return this.overworldData;
    }

    protected void restore(class_3218 level, SnowData data) {
        SnowSavedData store = SnowSavedData.get();
        data.winterId = store.winterId;
        data.stormCount = store.stormCount;
        data.activeStorms.clear();
    }

    protected void persist(class_3218 level, SnowData data) {
        SnowSavedData store = SnowSavedData.get();
        store.winterId = data.winterId;
        store.stormCount = data.stormCount;
        store.method_80();
    }

    @Override
    public int getBlocksToReplace(class_3218 level, class_2338 pos) {
        if (!this.isOverworld(level)) {
            return 0;
        }
        float temperature = SeasonHooks.getBiomeTemperature((class_1937)level, (class_6880)level.method_23753(pos), (class_2338)pos);
        boolean cold = SeasonHooks.coldEnoughToSnowSeasonal((class_4538)level, (class_2338)pos);
        boolean precip = EnvironmentHelper.isRainning(level, pos);
        if (cold && precip) {
            return -1;
        }
        return cold ? 0 : CommonSnowBlockFeature.calculateBlocksToReplace(temperature);
    }

    @Override
    public void resetWinterState(class_3218 level, int winterId) {
        if (!this.isOverworld(level)) {
            return;
        }
        SnowData data = this.getOrCreateData(level);
        if (data.winterId == winterId) {
            return;
        }
        data.winterId = winterId;
        data.stormCount = 0;
        data.activeStorms.clear();
        this.persist(level, data);
        SnowHistorySavedData hist = SnowHistorySavedData.get();
        hist.currentStormId = 0;
        hist.snowHistory.clear();
        hist.method_80();
    }

    @Override
    public void onRainChanged(class_3218 level, boolean isRaining) {
        if (!this.isOverworld(level)) {
            return;
        }
        SnowData data = this.getOrCreateData(level);
        if (isRaining && EnvironmentHelper.isSnowySeason()) {
            if (data.activeStorms.isEmpty()) {
                int stormId = data.stormCount + 1;
                data.activeStorms.add(stormId);
                SnowHistorySavedData hist = SnowHistorySavedData.get();
                hist.currentStormId = stormId;
                if (!hist.snowHistory.containsKey(stormId)) {
                    SnowRecord rec = SnowGenerator.generateStormRecord(level.field_9229);
                    hist.snowHistory.put(stormId, rec);
                }
                hist.method_80();
            }
        } else if (!data.activeStorms.isEmpty()) {
            int endedStormId = data.activeStorms.iterator().next();
            data.activeStorms.remove(endedStormId);
            SnowHistorySavedData hist = SnowHistorySavedData.get();
            if (!hist.snowHistory.containsKey(endedStormId)) {
                SnowRecord rec = SnowGenerator.generateStormRecord(level.field_9229);
                hist.snowHistory.put(endedStormId, rec);
            }
            ++data.stormCount;
            hist.currentStormId = 0;
            hist.method_80();
        }
        this.persist(level, data);
    }

    @Override
    public int getSnowStormsThisWinter(class_3218 level) {
        if (!this.isOverworld(level)) {
            return 0;
        }
        SnowData data = this.getOrCreateData(level);
        return data.stormCount - data.activeStorms.size();
    }

    @Override
    public void clear(class_3218 level) {
        if (!this.isOverworld(level)) {
            return;
        }
        if (this.overworldData != null) {
            this.persist(level, this.overworldData);
            this.overworldData = null;
        }
    }

    @Override
    public boolean isColdEnoughForSnow(class_3218 level, class_2338 pos) {
        return this.isOverworld(level) && SeasonHooks.coldEnoughToSnowSeasonal((class_4538)level, (class_2338)pos);
    }

    @Override
    public void onRainCloudSpawned(class_3218 level, int hashCode) {
    }

    @Override
    public void onRainCloudDespawned(class_3218 level, int hashCode) {
    }

    protected static final class SnowData {
        int winterId = -1;
        int stormCount = 0;
        final Set<Integer> activeStorms = new HashSet<Integer>();

        protected SnowData() {
        }
    }
}

