/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus;

import com.Gabou.sereneseasonsplus.SereneSeasonPlusCommon;
import com.Gabou.sereneseasonsplus.SereneSeasonsPlusNeoForgeClient;
import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.event.SeasonChangeEvent;
import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.NeoForgeAsyncExecutorHandler;
import com.Gabou.sereneseasonsplus.util.NeoForgeEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.SereneService;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@Mod(value="sereneseasonsplus")
public class SereneSeasonsPlusNeoForge
extends SereneSeasonPlusCommon {
    public static boolean isProjectAtmosphereLoaded = false;

    public SereneSeasonsPlusNeoForge(IEventBus modEventBus) {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        NeoForge.EVENT_BUS.register((Object)this);
        EnvironmentHelper.init(new NeoForgeEnvironmentHelper());
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SereneExtendedConfig.COMMON_SPEC);
        SeasonChangeEvent.register();
        modEventBus.addListener(event -> {
            LOGGER.info("Setting up Serene Seasons Plus (Common)");
            this.clientSetup((FMLClientSetupEvent)event, modLoadingContext);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Serene Seasons Extended is loading!");
        SereneService.HANDLER = new NeoForgeAsyncExecutorHandler();
        ((GameRules.IntegerValue)event.getServer().getGameRules().getRule(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT)).set(999, event.getServer());
        CommonSnowBlockFeature.onServerStarting((Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get(), (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get(), (Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get());
    }

    private void clientSetup(FMLClientSetupEvent event, ModLoadingContext modContainer) {
        LOGGER.info("Setting up Serene Seasons Plus (Client)");
        SereneSeasonsPlusNeoForgeClient.init(modContainer);
        NeoForge.EVENT_BUS.register(SereneSeasonsPlusNeoForgeClient.class);
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        SereneService.HANDLER.shutdown();
        SereneService.HANDLER = null;
        CommonSnowBlockFeature.onServerStopping();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.END || !event.haveTime()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        this.onTick((Level)level, (Boolean)SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.get(), (Boolean)SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.get(), (Double)SereneExtendedConfig.CUSTOM_DAY_LENGTH.get(), (Double)SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.get());
        CommonSnowBlockFeature.handleServerTick(level.getServer(), level);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        CommonSnowBlockFeature.handleServerTick(level.getServer(), level);
    }

    @SubscribeEvent
    public void onConfigReload(TickEvent.ServerTickEvent event) {
        CommonSnowBlockFeature.onConfigReload((Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get(), (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get(), (Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get());
        SereneService.reloadConfig();
    }
}

