/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.mixin;

import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerSnowMixin {
    private static final String SSP = "SereneSeasonsPlus";

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private static void ssp$write(ServerLevel level, ChunkAccess access, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag root = (CompoundTag)cir.getReturnValue();
        if (!(access instanceof ISnowTrackedChunk)) {
            return;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
        CompoundTag tag = new CompoundTag();
        tag.putInt("LastWinterId", tracked.sereneseasonsplus$getLastWinterId());
        tag.putInt("SurfaceHeight", tracked.sereneseasonsplus$getSurfaceHeight());
        tag.putFloat("StormProgress", tracked.sereneseasonsplus$getStormProgress());
        tag.putInt("StormIdApplied", tracked.sereneseasonsplus$getStormIdApplied());
        tag.putInt("LastProgressTick", tracked.sereneseasonsplus$getLastProgressTick());
        tag.putInt("AvailableColumns", tracked.sereneseasonsplus$getAvailableSnowColumns());
        tag.putInt("DestroyedStormId", tracked.sereneseasonsplus$getDestroyedStormId());
        ListTag snowList = new ListTag();
        for (Map.Entry<BlockPos, Integer> entry : tracked.sereneseasonsplus$getSnowColumns().entrySet()) {
            CompoundTag entry2 = new CompoundTag();
            entry2.putLong("Pos", entry.getKey().asLong());
            entry2.putInt("Layers", entry.getValue().intValue());
            snowList.add((Object)entry2);
        }
        tag.put("SnowColumns", (Tag)snowList);
        ListTag iceList = new ListTag();
        for (BlockPos pos : tracked.sereneseasonsplus$getIceColumns()) {
            CompoundTag entry = new CompoundTag();
            entry.putLong("Pos", pos.asLong());
            iceList.add((Object)entry);
        }
        tag.put("IceColumns", (Tag)iceList);
        ListTag listTag = new ListTag();
        for (Long key : tracked.sereneseasonsplus$getDestroyedColumns()) {
            CompoundTag entry = new CompoundTag();
            entry.putLong("XZ", key.longValue());
            listTag.add((Object)entry);
        }
        tag.put("DestroyedColumns", (Tag)listTag);
        root.put(SSP, (Tag)tag);
    }

    @Inject(method={"read(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/ai/village/poi/PoiManager;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/level/chunk/ProtoChunk;"}, at={@At(value="RETURN")})
    private static void ssp$rehydrateOnRead(ServerLevel level, PoiManager poi, ChunkPos pos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> cir) {
        CompoundTag tag = nbt.getCompound(SSP);
        if (tag.isEmpty()) {
            return;
        }
        ProtoChunk ret = (ProtoChunk)cir.getReturnValue();
        if (ret instanceof ImposterProtoChunk) {
            ImposterProtoChunk ipc = (ImposterProtoChunk)ret;
            LevelChunk lc = ipc.getWrapped();
            ChunkSerializerSnowMixin.ssp$applyTagToTracked(lc, tag);
        } else {
            ChunkSerializerSnowMixin.ssp$applyTagToTracked(ret, tag);
        }
    }

    @Unique
    private static void ssp$applyTagToTracked(Object chunk, CompoundTag tag) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        if (tag.contains("LastWinterId")) {
            tracked.sereneseasonsplus$setLastWinterId(tag.getInt("LastWinterId"));
        }
        if (tag.contains("SurfaceHeight")) {
            tracked.sereneseasonsplus$setSurfaceHeight(tag.getInt("SurfaceHeight"));
        }
        if (tag.contains("StormProgress")) {
            tracked.sereneseasonsplus$setStormProgress(tag.getFloat("StormProgress"));
        }
        if (tag.contains("StormIdApplied")) {
            tracked.sereneseasonsplus$setStormIdApplied(tag.getInt("StormIdApplied"));
        }
        if (tag.contains("LastProgressTick")) {
            tracked.sereneseasonsplus$setLastProgressTick(tag.getInt("LastProgressTick"));
        }
        if (tag.contains("AvailableColumns")) {
            tracked.sereneseasonsplus$setAvailableSnowColumns(tag.getInt("AvailableColumns"));
        }
        if (tag.contains("DestroyedStormId")) {
            tracked.sereneseasonsplus$setDestroyedStormId(tag.getInt("DestroyedStormId"));
        }
        tracked.sereneseasonsplus$getSnowColumns().clear();
        ListTag snow = tag.getList("SnowColumns", 10);
        for (int i = 0; i < snow.size(); ++i) {
            CompoundTag e = snow.getCompound(i);
            tracked.sereneseasonsplus$getSnowColumns().put(BlockPos.of((long)e.getLong("Pos")).immutable(), e.getInt("Layers"));
        }
        tracked.sereneseasonsplus$getIceColumns().clear();
        ListTag ice = tag.getList("IceColumns", 10);
        for (int i = 0; i < ice.size(); ++i) {
            CompoundTag e = ice.getCompound(i);
            tracked.sereneseasonsplus$getIceColumns().add(BlockPos.of((long)e.getLong("Pos")).immutable());
        }
        tracked.sereneseasonsplus$getDestroyedColumns().clear();
        ListTag destroyed = tag.getList("DestroyedColumns", 10);
        for (int i = 0; i < destroyed.size(); ++i) {
            CompoundTag e = destroyed.getCompound(i);
            tracked.sereneseasonsplus$getDestroyedColumns().add(e.getLong("XZ"));
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void ssp$read(ServerLevel level, PoiManager poi, ChunkPos pos, CompoundTag nbt, CallbackInfoReturnable<ProtoChunk> cir) {
        ChunkAccess access = (ChunkAccess)cir.getReturnValue();
        if (access instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)access;
            CompoundTag tag = nbt.getCompound(SSP);
            if (!tag.isEmpty()) {
                BlockPos bp;
                if (tag.contains("LastWinterId")) {
                    tracked.sereneseasonsplus$setLastWinterId(tag.getInt("LastWinterId"));
                }
                if (tag.contains("SurfaceHeight")) {
                    tracked.sereneseasonsplus$setSurfaceHeight(tag.getInt("SurfaceHeight"));
                }
                if (tag.contains("StormProgress")) {
                    tracked.sereneseasonsplus$setStormProgress(tag.getFloat("StormProgress"));
                }
                if (tag.contains("StormIdApplied")) {
                    tracked.sereneseasonsplus$setStormIdApplied(tag.getInt("StormIdApplied"));
                }
                if (tag.contains("LastProgressTick")) {
                    tracked.sereneseasonsplus$setLastProgressTick(tag.getInt("LastProgressTick"));
                }
                if (tag.contains("AvailableColumns")) {
                    tracked.sereneseasonsplus$setAvailableSnowColumns(tag.getInt("AvailableColumns"));
                }
                if (tag.contains("DestroyedStormId")) {
                    tracked.sereneseasonsplus$setDestroyedStormId(tag.getInt("DestroyedStormId"));
                }
                tracked.sereneseasonsplus$getSnowColumns().clear();
                ListTag list = tag.getList("SnowColumns", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag entry = list.getCompound(i);
                    long posLong = entry.getLong("Pos");
                    int layers = entry.getInt("Layers");
                    bp = BlockPos.of((long)posLong);
                    tracked.sereneseasonsplus$getSnowColumns().put(bp.immutable(), layers);
                }
                tracked.sereneseasonsplus$getIceColumns().clear();
                ListTag iceList = tag.getList("IceColumns", 10);
                for (int i = 0; i < iceList.size(); ++i) {
                    CompoundTag entry = iceList.getCompound(i);
                    long posLong = entry.getLong("Pos");
                    bp = BlockPos.of((long)posLong);
                    tracked.sereneseasonsplus$getIceColumns().add(bp.immutable());
                }
                tracked.sereneseasonsplus$getDestroyedColumns().clear();
                ListTag destroyedList = tag.getList("DestroyedColumns", 10);
                for (int i = 0; i < destroyedList.size(); ++i) {
                    CompoundTag entry = destroyedList.getCompound(i);
                    long xz = entry.getLong("XZ");
                    tracked.sereneseasonsplus$getDestroyedColumns().add(xz);
                }
            }
        }
    }
}

