/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.mixin;

import com.Gabou.sereneseasonsplus.tags.SSPTags;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpreadingSnowyDirtBlock.class})
public abstract class SpreadingSnowyDirtBlockMixin {
    @Inject(method={"randomTick"}, at={@At(value="TAIL")})
    private void sereneseasonsplus$growVegetation(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (!state.is(Blocks.GRASS_BLOCK)) {
            return;
        }
        if (!EnvironmentHelper.isHotSeason()) {
            return;
        }
        BlockPos above = pos.above();
        BlockState aboveState = level.getBlockState(above);
        if (!aboveState.isAir()) {
            return;
        }
        if (level.getMaxLocalRawBrightness(above) < 9) {
            return;
        }
        if (random.nextInt(EnvironmentHelper.getGrassChance()) != 0) {
            return;
        }
        if (random.nextFloat() < 0.8f) {
            if (random.nextBoolean()) {
                level.setBlock(above, Blocks.SHORT_GRASS.defaultBlockState(), 3);
            } else {
                level.setBlock(above, Blocks.TALL_GRASS.defaultBlockState(), 3);
            }
        } else {
            List flowers;
            Optional flowerTag = level.registryAccess().registryOrThrow(Registries.BLOCK).getTag(SSPTags.Blocks.FLOWERS);
            if (flowerTag.isPresent() && !(flowers = ((HolderSet.Named)flowerTag.get()).stream().toList()).isEmpty()) {
                Holder randomFlower = (Holder)flowers.get(random.nextInt(flowers.size()));
                Block flowerBlock = (Block)randomFlower.value();
                level.setBlock(above, flowerBlock.defaultBlockState(), 3);
                return;
            }
            level.setBlock(above, Blocks.DANDELION.defaultBlockState(), 3);
        }
    }
}

