/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.api;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.storage.SnowSavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import net.Gabou.gaboulibs.storage.SnowRecord;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.chunk.LevelChunk;

public final class SSPApi {
    private static SSPApi INSTANCE = new SSPApi();
    public static final String MODID = "sereneseasonsplus";

    public static SSPApi getINSTANCE() {
        return INSTANCE;
    }

    private SSPApi() {
    }

    public static void setFastPilingMode(boolean enabled) {
        CommonSnowBlockFeature.setFastPilingMode(enabled);
    }

    public static boolean isFastPilingMode() {
        return CommonSnowBlockFeature.FAST_PILING_MODE;
    }

    public static void setStormTargetTicks(int ticks) {
        CommonSnowBlockFeature.setActiveStormTargetTicks(ticks);
    }

    public static int getStormTargetTicks() {
        return CommonSnowBlockFeature.ACTIVE_STORM_TARGET_TICKS;
    }

    public static void setStormIntensityMultiplier(float multiplier) {
        CommonSnowBlockFeature.setStormIntensityMultiplier(multiplier);
    }

    public static float getStormIntensityMultiplier() {
        return CommonSnowBlockFeature.STORM_INTENSITY_MULTIPLIER;
    }

    public static boolean setCurrentStormLayers(ServerLevel level, float min, float avg, float max) {
        if (level == null || level.isClientSide()) {
            return false;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.currentStormId <= 0) {
            return false;
        }
        int id = sd.currentStormId;
        SnowRecord rec = sd.snowHistory.get(id);
        if (rec == null) {
            rec = new SnowRecord();
            sd.snowHistory.put(id, rec);
        }
        float clampedMin = Math.max(0.0f, min);
        float clampedMax = Math.max(clampedMin, max);
        float clampedAvg = Math.max(clampedMin, Math.min(clampedMax, avg));
        rec.minLayers = clampedMin;
        rec.avgLayers = clampedAvg;
        rec.maxLayers = clampedMax;
        sd.setDirty();
        return true;
    }

    public static boolean setCurrentStormMin(ServerLevel level, float min) {
        float clampedMin;
        SnowRecord rec = SSPApi.getOrCreateActiveRecord(level);
        if (rec == null) {
            return false;
        }
        rec.minLayers = clampedMin = Math.max(0.0f, min);
        if (rec.maxLayers < clampedMin) {
            rec.maxLayers = clampedMin;
        }
        if (rec.avgLayers < clampedMin) {
            rec.avgLayers = clampedMin;
        }
        SnowHistorySavedData.get().setDirty();
        return true;
    }

    public static boolean setCurrentStormAvg(ServerLevel level, float avg) {
        float clamped;
        SnowRecord rec = SSPApi.getOrCreateActiveRecord(level);
        if (rec == null) {
            return false;
        }
        rec.avgLayers = clamped = Math.max(rec.minLayers, Math.min(rec.maxLayers, avg));
        SnowHistorySavedData.get().setDirty();
        return true;
    }

    public static boolean setCurrentStormMax(ServerLevel level, float max) {
        float clamped;
        SnowRecord rec = SSPApi.getOrCreateActiveRecord(level);
        if (rec == null) {
            return false;
        }
        rec.maxLayers = clamped = Math.max(rec.minLayers, max);
        if (rec.avgLayers > rec.maxLayers) {
            rec.avgLayers = rec.maxLayers;
        }
        SnowHistorySavedData.get().setDirty();
        return true;
    }

    public static SnowRecord getCurrentStormRecord(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return null;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.currentStormId <= 0) {
            return null;
        }
        return sd.snowHistory.get(sd.currentStormId);
    }

    private static SnowRecord getOrCreateActiveRecord(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return null;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.currentStormId <= 0) {
            return null;
        }
        SnowRecord rec = sd.snowHistory.get(sd.currentStormId);
        if (rec == null) {
            rec = new SnowRecord();
            sd.snowHistory.put(sd.currentStormId, rec);
        }
        return rec;
    }

    public void onSimpleCloudsSpawned(ServerLevel level, int hashCode) {
        EnvironmentHelper.onSimpleCloudSpawned(level, hashCode);
    }

    public void onCloudsDespawned(ServerLevel level, int hashCode) {
        EnvironmentHelper.onSimpleCloudsDespawned(level, hashCode);
    }

    public static void resetSnowHistory(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        SnowHistorySavedData hist = SnowHistorySavedData.get();
        hist.currentStormId = 0;
        hist.snowHistory.clear();
        hist.setDirty();
    }

    public static void resetEnvironmentState(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        SnowSavedData env = SnowSavedData.get();
        env.stormCount = 0;
        env.stormActive = false;
        env.pendingChunks.clear();
        env.observedChunks.clear();
        env.lastBlanketStormCount = 0;
        env.setDirty();
        CommonSnowBlockFeature.HANDLER.clear(level);
    }

    public static void resetChunkProgress(ServerLevel level, int chunkX, int chunkZ) {
        if (level == null || level.isClientSide()) {
            return;
        }
        LevelChunk chunk = level.getChunkSource().getChunk(chunkX, chunkZ, false);
        if (chunk instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
            tracked.sereneseasonsplus$setStormProgress(0.0f);
            tracked.sereneseasonsplus$setStormIdApplied(0);
            tracked.sereneseasonsplus$setLastProgressTick(0);
        }
    }

    public static void resetLoadedChunkProgress(ServerLevel level) {
        if (level == null || level.isClientSide()) {
            return;
        }
        for (ServerPlayer player : level.players()) {
            int view = player.getServer() != null ? player.getServer().getPlayerList().getViewDistance() : 10;
            int radius = Math.max(1, view);
            int baseCX = player.blockPosition().getX() >> 4;
            int baseCZ = player.blockPosition().getZ() >> 4;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    SSPApi.resetChunkProgress(level, baseCX + dx, baseCZ + dz);
                }
            }
        }
    }

    public static void resetAllStormData(ServerLevel level) {
        SSPApi.resetSnowHistory(level);
        SSPApi.resetEnvironmentState(level);
        SSPApi.resetLoadedChunkProgress(level);
    }
}

