/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.config;

import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.config.SereneExtendedList;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import net.Gabou.gaboulibs.util.IScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.loading.FMLPaths;

public class SereneExtendedScreen
extends Screen {
    private final Screen parent;
    private boolean snowFeatureEnabled;
    private int tickSnowReplacerThreshold;
    private int maxSnowHeight;
    private EditBox maxReplacerBox;
    private EditBox maxSnowHeightBox;
    private EditBox dayLengthBox;
    private EditBox nightLengthBox;
    private boolean seasonalDaylightCycle;
    private boolean customDayCycle;
    private double customDayLength;
    private double customNightLength;
    private boolean grassFlowerGrowth;
    private Component replacerLabel = Component.literal((String)"Common Feature Threshold:");
    private Component pillerLabel = Component.literal((String)"");
    private Component snowHeightLabel = Component.literal((String)"Max Snow Height (layers):");
    private Component nightLabel = Component.literal((String)"Custom Night Speed:");
    private Component dayLabel = Component.literal((String)"Custom Day Speed:");
    private SereneExtendedList list;

    public SereneExtendedScreen(Screen parent) {
        super((Component)Component.literal((String)"Serene Seasons Plus Config"));
        this.parent = parent;
    }

    protected void init() {
        this.snowFeatureEnabled = (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get();
        this.tickSnowReplacerThreshold = (Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get();
        this.maxSnowHeight = (Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get();
        this.seasonalDaylightCycle = (Boolean)SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.get();
        this.customDayCycle = (Boolean)SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.get();
        this.customDayLength = (Double)SereneExtendedConfig.CUSTOM_DAY_LENGTH.get();
        this.customNightLength = (Double)SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.get();
        this.grassFlowerGrowth = (Boolean)SereneExtendedConfig.GRASS_FLOWER_GROWTH_ENABLED.get();
        int panelW = 420;
        int panelX = (this.width - panelW) / 2;
        int top = 40;
        int bottom = this.height - 40;
        this.list = new SereneExtendedList(this.minecraft, panelW, this.height, top + 20, 24);
        try {
            ((Object)((Object)this.list)).getClass().getMethod("setX", Integer.TYPE).invoke((Object)this.list, panelX);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.addRenderableWidget((GuiEventListener)this.list);
        Button snowFeatureBtn = Button.builder((Component)this.toggleLabel("Snow Features", this.snowFeatureEnabled), b -> {
            this.snowFeatureEnabled = !this.snowFeatureEnabled;
            b.setMessage(this.toggleLabel("Snow Features", this.snowFeatureEnabled));
        }).bounds(0, 0, 200, 20).build();
        this.list.addRow((Component)Component.literal((String)"Snow Features"), new AbstractWidget[]{snowFeatureBtn});
        Button seasonBtn = Button.builder((Component)this.toggleLabel("Seasonal Daylight Cycle", this.seasonalDaylightCycle), b -> {
            this.seasonalDaylightCycle = !this.seasonalDaylightCycle;
            this.customDayCycle = false;
            b.setMessage(this.toggleLabel("Seasonal Daylight Cycle", this.seasonalDaylightCycle));
        }).bounds(0, 0, 200, 20).build();
        this.list.addRow((Component)Component.literal((String)"Seasonal Daylight Cycle"), new AbstractWidget[]{seasonBtn});
        Button customBtn = Button.builder((Component)this.toggleLabel("Custom Daylight Cycle", this.customDayCycle), b -> {
            this.customDayCycle = !this.customDayCycle;
            this.seasonalDaylightCycle = false;
            b.setMessage(this.toggleLabel("Custom Daylight Cycle", this.customDayCycle));
        }).bounds(0, 0, 200, 20).build();
        this.list.addRow((Component)Component.literal((String)"Custom Daylight Cycle"), new AbstractWidget[]{customBtn});
        Button grassFlowerBtn = Button.builder((Component)this.toggleLabel("Grass and Flower Growth", this.grassFlowerGrowth), b -> {
            this.grassFlowerGrowth = !this.grassFlowerGrowth;
            b.setMessage(this.toggleLabel("Grass and Flower Growth", this.grassFlowerGrowth));
        }).bounds(0, 0, 200, 20).build();
        this.list.addRow((Component)Component.literal((String)"Grass and Flower Growth"), new AbstractWidget[]{grassFlowerBtn});
        this.maxReplacerBox = new EditBox(this.font, 0, 0, 200, 20, (Component)Component.empty());
        this.maxReplacerBox.setValue(Integer.toString(this.tickSnowReplacerThreshold));
        this.list.addRow((Component)Component.literal((String)"Common Feature Threshold"), new AbstractWidget[]{this.maxReplacerBox});
        this.maxSnowHeightBox = new EditBox(this.font, 0, 0, 200, 20, (Component)Component.empty());
        this.maxSnowHeightBox.setValue(Integer.toString(this.maxSnowHeight));
        this.list.addRow((Component)Component.literal((String)"Max Snow Height (layers)"), new AbstractWidget[]{this.maxSnowHeightBox});
        this.nightLengthBox = new EditBox(this.font, 0, 0, 200, 20, (Component)Component.empty());
        this.nightLengthBox.setValue(Double.toString(this.customNightLength));
        this.list.addRow((Component)Component.literal((String)"Custom Night Speed"), new AbstractWidget[]{this.nightLengthBox});
        this.dayLengthBox = new EditBox(this.font, 0, 0, 200, 20, (Component)Component.empty());
        this.dayLengthBox.setValue(Double.toString(this.customDayLength));
        this.list.addRow((Component)Component.literal((String)"Custom Day Speed"), new AbstractWidget[]{this.dayLengthBox});
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), b -> {
            this.saveChanges();
            this.minecraft.setScreen(this.parent);
        }).bounds(panelX + (panelW - 200) / 2, bottom - 30, 200, 20).build());
    }

    public void render(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(g, mouseX, mouseY, partialTick);
        int panelW = 480;
        int panelX = (this.width - panelW) / 2;
        int top = 40;
        int bottom = this.height - 40;
        g.fill(panelX - 4, top - 4, panelX + panelW + 4, bottom, -1442840576);
        g.drawString(this.font, "Serene Seasons Plus", panelX + 6, top - 14, 0xFFFFFF, false);
        ((IScreen)this).sereneseasonsplus$renderNoBackground(g, mouseX, mouseY, partialTick);
    }

    private Component toggleLabel(String name, boolean enabled) {
        return Component.literal((String)(name + ": " + (enabled ? "ON" : "OFF")));
    }

    private void saveChanges() {
        MutableComponent errorMessage;
        int parsed2 = this.tickSnowReplacerThreshold;
        int parsedSnowHeight = this.maxSnowHeight;
        double parsed3 = this.customDayLength;
        double parsed4 = this.customNightLength;
        try {
            parsed2 = Integer.parseInt(this.maxReplacerBox.getValue());
            parsedSnowHeight = Integer.parseInt(this.maxSnowHeightBox.getValue());
            errorMessage = null;
        }
        catch (NumberFormatException ignored) {
            errorMessage = Component.literal((String)"Invalid number for a Snow setting.");
        }
        try {
            parsed3 = Double.parseDouble(this.dayLengthBox.getValue());
            parsed4 = Double.parseDouble(this.nightLengthBox.getValue());
            errorMessage = null;
        }
        catch (NumberFormatException ignored) {
            errorMessage = Component.literal((String)"Invalid number for one of the DayCycle Speeds.");
        }
        SereneExtendedConfig.TICK_SNOW_REPLACER.set((Object)parsed2);
        SereneExtendedConfig.SNOWSTORM_ENABLED.set((Object)this.snowFeatureEnabled);
        SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.set((Object)parsedSnowHeight);
        SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.set((Object)this.seasonalDaylightCycle);
        SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.set((Object)this.customDayCycle);
        SereneExtendedConfig.CUSTOM_DAY_LENGTH.set((Object)parsed3);
        SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.set((Object)parsed4);
        SereneExtendedConfig.GRASS_FLOWER_GROWTH_ENABLED.set((Object)this.grassFlowerGrowth);
        try {
            this.saveToFile();
            errorMessage = null;
        }
        catch (Exception e) {
            errorMessage = Component.literal((String)("Failed to save config: " + e.getMessage()));
        }
    }

    private void saveToFile() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("sereneseasonsplus-common.toml");
        CommentedFileConfig cfg = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().preserveInsertionOrder().build();
        cfg.load();
        cfg.set("snowstorm.enabled", (Object)this.snowFeatureEnabled);
        cfg.set("snowStorms.maxSnowAccumulationLayers", (Object)this.maxSnowHeight);
        cfg.set("snowPillerAndReplacer.tickSnowReplacer", (Object)this.tickSnowReplacerThreshold);
        cfg.set("seasonalDaylightCycle.enableSeasonalDaylightCycle", (Object)this.seasonalDaylightCycle);
        cfg.set("seasonalDaylightCycle.customCycleLength", (Object)this.customDayCycle);
        cfg.set("seasonalDaylightCycle.customDayLength", (Object)this.customDayLength);
        cfg.set("seasonalDaylightCycle.customNightLength", (Object)this.customNightLength);
        cfg.save();
        cfg.close();
    }

    public void onClose() {
        this.setFocused(false);
        Minecraft.getInstance().setScreen(this.parent);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.list != null && this.list.mouseClicked(x, y, button)) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean keyPressed(int key, int sc, int mods) {
        if (this.list != null && this.list.keyPressed(key, sc, mods)) {
            return true;
        }
        if (this.maxReplacerBox != null && this.maxReplacerBox.keyPressed(key, sc, mods)) {
            return true;
        }
        if (this.maxSnowHeightBox != null && this.maxSnowHeightBox.keyPressed(key, sc, mods)) {
            return true;
        }
        if (this.nightLengthBox != null && this.nightLengthBox.keyPressed(key, sc, mods)) {
            return true;
        }
        if (this.dayLengthBox != null && this.dayLengthBox.keyPressed(key, sc, mods)) {
            return true;
        }
        return super.keyPressed(key, sc, mods);
    }

    public boolean charTyped(char c, int mods) {
        if (this.list != null && this.list.charTyped(c, mods)) {
            return true;
        }
        if (this.maxReplacerBox != null && this.maxReplacerBox.charTyped(c, mods)) {
            return true;
        }
        if (this.maxSnowHeightBox != null && this.maxSnowHeightBox.charTyped(c, mods)) {
            return true;
        }
        if (this.nightLengthBox != null && this.nightLengthBox.charTyped(c, mods)) {
            return true;
        }
        if (this.dayLengthBox != null && this.dayLengthBox.charTyped(c, mods)) {
            return true;
        }
        return super.charTyped(c, mods);
    }
}

