/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.ISnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.storage.SnowSavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import java.util.HashSet;
import java.util.Set;
import net.Gabou.gaboulibs.storage.SnowRecord;
import net.Gabou.gaboulibs.util.SnowGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import sereneseasons.season.SeasonHooks;

public class DefaultSnowEnvironmentHandler
implements ISnowEnvironmentHandler {
    protected SnowData overworldData;

    protected boolean isOverworld(ServerLevel level) {
        return level.dimension() == Level.OVERWORLD;
    }

    protected SnowData getOrCreateData(ServerLevel level) {
        if (this.overworldData == null) {
            this.overworldData = new SnowData();
            this.restore(level, this.overworldData);
        }
        return this.overworldData;
    }

    protected void restore(ServerLevel level, SnowData data) {
        SnowSavedData store = SnowSavedData.get();
        data.winterId = store.winterId;
        data.stormCount = store.stormCount;
        data.activeStorms.clear();
    }

    protected void persist(ServerLevel level, SnowData data) {
        SnowSavedData store = SnowSavedData.get();
        store.winterId = data.winterId;
        store.stormCount = data.stormCount;
        store.setDirty();
    }

    @Override
    public int getBlocksToReplace(ServerLevel level, BlockPos pos) {
        if (!this.isOverworld(level)) {
            return 0;
        }
        float temperature = SeasonHooks.getBiomeTemperature((Level)level, (Holder)level.getBiome(pos), (BlockPos)pos);
        boolean cold = SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (BlockPos)pos);
        boolean precip = EnvironmentHelper.isRainning(level, pos);
        if (cold && precip) {
            return -1;
        }
        return cold ? 0 : CommonSnowBlockFeature.calculateBlocksToReplace(temperature);
    }

    @Override
    public void resetWinterState(ServerLevel level, int winterId) {
        if (!this.isOverworld(level)) {
            return;
        }
        SnowData data = this.getOrCreateData(level);
        if (data.winterId == winterId) {
            return;
        }
        data.winterId = winterId;
        data.stormCount = 0;
        data.activeStorms.clear();
        this.persist(level, data);
        SnowHistorySavedData hist = SnowHistorySavedData.get();
        hist.currentStormId = 0;
        hist.snowHistory.clear();
        hist.setDirty();
    }

    @Override
    public void onRainChanged(ServerLevel level, boolean isRaining) {
        if (!this.isOverworld(level)) {
            return;
        }
        SnowData data = this.getOrCreateData(level);
        if (isRaining && EnvironmentHelper.isSnowySeason()) {
            if (data.activeStorms.isEmpty()) {
                int stormId = data.stormCount + 1;
                data.activeStorms.add(stormId);
                SnowHistorySavedData hist = SnowHistorySavedData.get();
                hist.currentStormId = stormId;
                if (!hist.snowHistory.containsKey(stormId)) {
                    SnowRecord rec = SnowGenerator.generateStormRecord((RandomSource)level.random);
                    hist.snowHistory.put(stormId, rec);
                }
                hist.setDirty();
            }
        } else if (!data.activeStorms.isEmpty()) {
            int endedStormId = data.activeStorms.iterator().next();
            data.activeStorms.remove(endedStormId);
            SnowHistorySavedData hist = SnowHistorySavedData.get();
            if (!hist.snowHistory.containsKey(endedStormId)) {
                SnowRecord rec = SnowGenerator.generateStormRecord((RandomSource)level.random);
                hist.snowHistory.put(endedStormId, rec);
            }
            ++data.stormCount;
            hist.currentStormId = 0;
            hist.setDirty();
        }
        this.persist(level, data);
    }

    @Override
    public int getSnowStormsThisWinter(ServerLevel level) {
        if (!this.isOverworld(level)) {
            return 0;
        }
        SnowData data = this.getOrCreateData(level);
        return data.stormCount - data.activeStorms.size();
    }

    @Override
    public void clear(ServerLevel level) {
        if (!this.isOverworld(level)) {
            return;
        }
        if (this.overworldData != null) {
            this.persist(level, this.overworldData);
            this.overworldData = null;
        }
    }

    @Override
    public boolean isColdEnoughForSnow(ServerLevel level, BlockPos pos) {
        return this.isOverworld(level) && SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, (BlockPos)pos);
    }

    @Override
    public void onRainCloudSpawned(ServerLevel level, int hashCode) {
    }

    @Override
    public void onRainCloudDespawned(ServerLevel level, int hashCode) {
    }

    protected static final class SnowData {
        int winterId = -1;
        int stormCount = 0;
        final Set<Integer> activeStorms = new HashSet<Integer>();

        protected SnowData() {
        }
    }
}

