/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.storage;

import java.util.HashMap;
import java.util.Map;
import net.Gabou.gaboulibs.storage.SnowRecord;
import net.Gabou.gaboulibs.util.WorldContext;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class SnowHistorySavedData
extends SavedData {
    private static volatile SnowHistorySavedData INSTANCE;
    public int currentStormId = 0;
    public final Map<Integer, SnowRecord> snowHistory = new HashMap<Integer, SnowRecord>();

    public static SnowHistorySavedData load(CompoundTag tag, HolderLookup.Provider provider) {
        SnowHistorySavedData data = new SnowHistorySavedData();
        if (tag == null) {
            return data;
        }
        data.currentStormId = tag.getInt("CurrentStormId");
        ListTag list = tag.getList("SnowHistory", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.getCompound(i);
            int id = entry.getInt("Id");
            SnowRecord rec = SnowRecord.fromTag((CompoundTag)entry.getCompound("Record"));
            data.snowHistory.put(id, rec);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnowHistorySavedData get() {
        SnowHistorySavedData inst = INSTANCE;
        if (inst != null) {
            return inst;
        }
        Class<SnowHistorySavedData> clazz = SnowHistorySavedData.class;
        synchronized (SnowHistorySavedData.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
            ServerLevel overworld = WorldContext.getOverworld();
            INSTANCE = overworld != null ? (SnowHistorySavedData)overworld.getDataStorage().computeIfAbsent(new SavedData.Factory(SnowHistorySavedData::new, SnowHistorySavedData::load, DataFixTypes.LEVEL), "ssp_snow_history") : new SnowHistorySavedData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("CurrentStormId", this.currentStormId);
        ListTag list = new ListTag();
        for (Map.Entry<Integer, SnowRecord> e : this.snowHistory.entrySet()) {
            CompoundTag entry = new CompoundTag();
            entry.putInt("Id", e.getKey().intValue());
            entry.put("Record", (Tag)e.getValue().toTag());
            list.add((Object)entry);
        }
        tag.put("SnowHistory", (Tag)list);
        return tag;
    }

    public static void clearCachedInstance() {
        INSTANCE = null;
    }
}

