/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.util;

import com.Gabou.sereneseasonsplus.util.AsyncExecutorHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAsyncExecutorHandler
implements AsyncExecutorHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"SereneService");
    private ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        LOGGER.info("Creating Async executor");
        Thread t = new Thread(r, "useAsync");
        t.setDaemon(false);
        return t;
    });
    protected boolean useAsync = false;

    @Override
    public void runAsync(Runnable task) {
        if (!this.useAsync) {
            task.run();
        } else if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.submit(task);
        } else {
            task.run();
        }
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public void reloadConfig() {
        this.useAsync = false;
    }
}

