/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.api;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.storage.SnowRecord;
import com.Gabou.sereneseasonsplus.storage.SnowSavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class SSPApi {
    private static SSPApi INSTANCE = new SSPApi();
    public static final String MODID = "sereneseasonsplus";

    public static SSPApi getINSTANCE() {
        return INSTANCE;
    }

    private SSPApi() {
    }

    public static void setFastPilingMode(boolean enabled) {
        CommonSnowBlockFeature.setFastPilingMode(enabled);
    }

    public static boolean isFastPilingMode() {
        return CommonSnowBlockFeature.FAST_PILING_MODE;
    }

    public static void setStormTargetTicks(int ticks) {
        CommonSnowBlockFeature.setActiveStormTargetTicks(ticks);
    }

    public static int getStormTargetTicks() {
        return CommonSnowBlockFeature.ACTIVE_STORM_TARGET_TICKS;
    }

    public static void setStormIntensityMultiplier(float multiplier) {
        CommonSnowBlockFeature.setStormIntensityMultiplier(multiplier);
    }

    public static float getStormIntensityMultiplier() {
        return CommonSnowBlockFeature.STORM_INTENSITY_MULTIPLIER;
    }

    public static boolean setCurrentStormLayers(class_3218 level, float min, float avg, float max) {
        if (level == null || level.method_8608()) {
            return false;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.currentStormId <= 0) {
            return false;
        }
        int id = sd.currentStormId;
        SnowRecord rec = sd.snowHistory.get(id);
        if (rec == null) {
            rec = new SnowRecord();
            sd.snowHistory.put(id, rec);
        }
        float clampedMin = Math.max(0.0f, min);
        float clampedMax = Math.max(clampedMin, max);
        float clampedAvg = Math.max(clampedMin, Math.min(clampedMax, avg));
        rec.minLayers = clampedMin;
        rec.avgLayers = clampedAvg;
        rec.maxLayers = clampedMax;
        sd.save();
        return true;
    }

    public static boolean setCurrentStormMin(class_3218 level, float min) {
        float clampedMin;
        SnowRecord rec = SSPApi.getOrCreateActiveRecord(level);
        if (rec == null) {
            return false;
        }
        rec.minLayers = clampedMin = Math.max(0.0f, min);
        if (rec.maxLayers < clampedMin) {
            rec.maxLayers = clampedMin;
        }
        if (rec.avgLayers < clampedMin) {
            rec.avgLayers = clampedMin;
        }
        SnowHistorySavedData.get().save();
        return true;
    }

    public static boolean setCurrentStormAvg(class_3218 level, float avg) {
        float clamped;
        SnowRecord rec = SSPApi.getOrCreateActiveRecord(level);
        if (rec == null) {
            return false;
        }
        rec.avgLayers = clamped = Math.max(rec.minLayers, Math.min(rec.maxLayers, avg));
        SnowHistorySavedData.get().save();
        return true;
    }

    public static boolean setCurrentStormMax(class_3218 level, float max) {
        float clamped;
        SnowRecord rec = SSPApi.getOrCreateActiveRecord(level);
        if (rec == null) {
            return false;
        }
        rec.maxLayers = clamped = Math.max(rec.minLayers, max);
        if (rec.avgLayers > rec.maxLayers) {
            rec.avgLayers = rec.maxLayers;
        }
        SnowHistorySavedData.get().save();
        return true;
    }

    public static SnowRecord getCurrentStormRecord(class_3218 level) {
        if (level == null || level.method_8608()) {
            return null;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.currentStormId <= 0) {
            return null;
        }
        return sd.snowHistory.get(sd.currentStormId);
    }

    private static SnowRecord getOrCreateActiveRecord(class_3218 level) {
        if (level == null || level.method_8608()) {
            return null;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.currentStormId <= 0) {
            return null;
        }
        SnowRecord rec = sd.snowHistory.get(sd.currentStormId);
        if (rec == null) {
            rec = new SnowRecord();
            sd.snowHistory.put(sd.currentStormId, rec);
        }
        return rec;
    }

    public void onSimpleCloudsSpawned(class_3218 level, int hashCode) {
        EnvironmentHelper.onSimpleCloudSpawned(level, hashCode);
    }

    public void onCloudsDespawned(class_3218 level, int hashCode) {
        EnvironmentHelper.onSimpleCloudsDespawned(level, hashCode);
    }

    public static void resetSnowHistory(class_3218 level) {
        if (level == null || level.method_8608()) {
            return;
        }
        SnowHistorySavedData hist = SnowHistorySavedData.get();
        hist.currentStormId = 0;
        hist.snowHistory.clear();
        hist.save();
    }

    public static void resetEnvironmentState(class_3218 level) {
        if (level == null || level.method_8608()) {
            return;
        }
        SnowSavedData env = SnowSavedData.get();
        env.stormCount = 0;
        env.stormActive = false;
        env.pendingChunks.clear();
        env.observedChunks.clear();
        env.lastBlanketStormCount = 0;
        env.save();
        CommonSnowBlockFeature.HANDLER.clear(level);
    }

    public static void resetChunkProgress(class_3218 level, int chunkX, int chunkZ) {
        if (level == null || level.method_8608()) {
            return;
        }
        class_2818 chunk = level.method_14178().method_12126(chunkX, chunkZ, false);
        if (chunk instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
            tracked.sereneseasonsplus$setStormProgress(0.0f);
            tracked.sereneseasonsplus$setStormIdApplied(0);
            tracked.sereneseasonsplus$setLastProgressTick(0);
        }
    }

    public static void resetLoadedChunkProgress(class_3218 level) {
        if (level == null || level.method_8608()) {
            return;
        }
        for (class_3222 player : level.method_18456()) {
            int view = player.method_5682() != null ? player.method_5682().method_3760().method_14568() : 10;
            int radius = Math.max(1, view);
            int baseCX = player.method_24515().method_10263() >> 4;
            int baseCZ = player.method_24515().method_10260() >> 4;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    SSPApi.resetChunkProgress(level, baseCX + dx, baseCZ + dz);
                }
            }
        }
    }

    public static void resetAllStormData(class_3218 level) {
        SSPApi.resetSnowHistory(level);
        SSPApi.resetEnvironmentState(level);
        SSPApi.resetLoadedChunkProgress(level);
    }
}

