/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.storage;

import com.Gabou.sereneseasonsplus.storage.SnowRecord;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

public class SnowHistorySavedData {
    private static final String FILE_NAME = "world/sereneseasonsplus/ssp_snow_history.dat";
    private static volatile SnowHistorySavedData INSTANCE;
    public int currentStormId = 0;
    public final Map<Integer, SnowRecord> snowHistory = new HashMap<Integer, SnowRecord>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnowHistorySavedData get() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<SnowHistorySavedData> clazz = SnowHistorySavedData.class;
        synchronized (SnowHistorySavedData.class) {
            if (INSTANCE == null) {
                INSTANCE = new SnowHistorySavedData();
                INSTANCE.load();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void save() {
        class_2487 tag = new class_2487();
        tag.method_10569("CurrentStormId", this.currentStormId);
        class_2499 list = new class_2499();
        for (Map.Entry<Integer, SnowRecord> e : this.snowHistory.entrySet()) {
            class_2487 entry = new class_2487();
            entry.method_10569("Id", e.getKey().intValue());
            entry.method_10566("Record", (class_2520)e.getValue().toTag());
            list.add((Object)entry);
        }
        tag.method_10566("SnowHistory", (class_2520)list);
        Path filePath = Path.of(FILE_NAME, new String[0]);
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));){
                class_2507.method_10634((class_2487)tag, (OutputStream)out);
            }
        }
        catch (IOException e) {
            System.err.println("[SS+] Failed to save snow history: " + e.getMessage());
        }
    }

    public void load() {
        Path filePath = Path.of(FILE_NAME, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try (DataInputStream in = new DataInputStream(Files.newInputStream(filePath, new OpenOption[0]));){
            class_2487 tag = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
            this.currentStormId = (Integer)tag.method_10550("CurrentStormId").get();
            class_2499 list = (class_2499)tag.method_10554("SnowHistory").get();
            for (int i = 0; i < list.size(); ++i) {
                class_2487 entry = (class_2487)list.method_10602(i).get();
                int id = (Integer)entry.method_10550("Id").get();
                class_2487 recTag = (class_2487)entry.method_10562("Record").get();
                this.snowHistory.put(id, SnowRecord.fromTag(recTag));
            }
        }
        catch (IOException e) {
            System.err.println("[SS+] Failed to load snow history: " + e.getMessage());
        }
    }

    public static void clearCachedInstance() {
        INSTANCE = null;
    }
}

