/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;

public class SnowSavedData {
    private static volatile SnowSavedData INSTANCE;
    private static final String FILE_PATH = "world/sereneseasonsplus/snow_data.dat";
    public int winterId = -1;
    public int stormCount = 0;
    public boolean stormActive = false;
    public final Set<Long> pendingChunks = new HashSet<Long>();
    public final Set<Long> observedChunks = new HashSet<Long>();
    public int lastBlanketStormCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnowSavedData get() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<SnowSavedData> clazz = SnowSavedData.class;
        synchronized (SnowSavedData.class) {
            if (INSTANCE == null) {
                INSTANCE = new SnowSavedData();
                INSTANCE.load();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void save() {
        class_2487 tag = new class_2487();
        tag.method_10569("WinterId", this.winterId);
        tag.method_10569("StormCount", this.stormCount);
        tag.method_10556("StormActive", this.stormActive);
        tag.method_10569("LastBlanketStormCount", this.lastBlanketStormCount);
        long[] pending = new long[this.pendingChunks.size()];
        int i = 0;
        for (Long l : this.pendingChunks) {
            pending[i++] = l;
        }
        tag.method_10564("PendingChunks", pending);
        long[] observed = new long[this.observedChunks.size()];
        i = 0;
        for (Long v : this.observedChunks) {
            observed[i++] = v;
        }
        tag.method_10564("ObservedChunks", observed);
        Path path = Path.of(FILE_PATH, new String[0]);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                class_2507.method_10634((class_2487)tag, (OutputStream)out);
            }
        }
        catch (IOException e) {
            System.err.println("[SS+] Failed to save snow data: " + e.getMessage());
        }
    }

    public void load() {
        Path path = Path.of(FILE_PATH, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (DataInputStream in = new DataInputStream(Files.newInputStream(path, new OpenOption[0]));){
            class_2487 tag = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
            if (tag.method_10550("WinterId").isPresent()) {
                this.winterId = (Integer)tag.method_10550("WinterId").get();
            }
            if (tag.method_10550("StormCount").isPresent()) {
                this.stormCount = (Integer)tag.method_10550("StormCount").get();
            }
            if (tag.method_10577("StormActive").isPresent()) {
                this.stormActive = (Boolean)tag.method_10577("StormActive").get();
            }
            if (tag.method_10550("LastBlanketStormCount").isPresent()) {
                this.lastBlanketStormCount = (Integer)tag.method_10550("LastBlanketStormCount").get();
            }
            if (tag.method_10565("PendingChunks").isPresent()) {
                long[] pending;
                for (long v : pending = (long[])tag.method_10565("PendingChunks").get()) {
                    this.pendingChunks.add(v);
                }
            }
            if (tag.method_10565("ObservedChunks").isPresent()) {
                long[] observed;
                for (long v : observed = (long[])tag.method_10565("ObservedChunks").get()) {
                    this.observedChunks.add(v);
                }
            }
        }
        catch (IOException e) {
            System.err.println("[SS+] Failed to load snow data: " + e.getMessage());
        }
    }

    public static void clearCachedInstance() {
        INSTANCE = null;
    }
}

