/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.storage;

import net.minecraft.nbt.CompoundTag;

public class SnowRecord {
    public float minLayers;
    public float avgLayers;
    public float maxLayers;
    public int[] distributionPattern;

    public SnowRecord() {
    }

    public SnowRecord(float minLayers, float avgLayers, float maxLayers, int[] distributionPattern) {
        this.minLayers = minLayers;
        this.avgLayers = avgLayers;
        this.maxLayers = maxLayers;
        this.distributionPattern = distributionPattern;
    }

    public static SnowRecord fromTag(CompoundTag tag) {
        SnowRecord r = new SnowRecord();
        r.minLayers = tag.getFloat("MinLayers");
        r.avgLayers = tag.getFloat("AvgLayers");
        r.maxLayers = tag.getFloat("MaxLayers");
        if (tag.contains("DistributionPattern")) {
            r.distributionPattern = tag.getIntArray("DistributionPattern");
        }
        return r;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putFloat("MinLayers", this.minLayers);
        tag.putFloat("AvgLayers", this.avgLayers);
        tag.putFloat("MaxLayers", this.maxLayers);
        if (this.distributionPattern != null) {
            tag.putIntArray("DistributionPattern", this.distributionPattern);
        }
        return tag;
    }
}

