/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus;

import com.Gabou.sereneseasonsplus.util.ConfigHacks;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sereneseasons.api.season.Season;

public class SereneSeasonPlusCommon {
    protected int ticker = 0;
    protected Season.SubSeason lastSubSeason = null;
    public static final String MODID = "sereneseasonsplus";
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"sereneseasonsplus");

    protected static void LogInfo(Season.SubSeason currentSubSeason, double daySpeed, double nightSpeed) {
        LOGGER.info("Season: {} \u2192 DaySpeed: {}, NightSpeed: {}", new Object[]{currentSubSeason, daySpeed, nightSpeed});
    }

    protected double getDaySpeedForSeason(Season.SubSeason season) {
        return switch (season) {
            default -> throw new MatchException(null, null);
            case Season.SubSeason.EARLY_SPRING -> 1.09;
            case Season.SubSeason.MID_SPRING -> 0.87;
            case Season.SubSeason.LATE_SPRING -> 0.67;
            case Season.SubSeason.EARLY_SUMMER -> 0.59;
            case Season.SubSeason.MID_SUMMER -> 0.67;
            case Season.SubSeason.LATE_SUMMER -> 0.86;
            case Season.SubSeason.EARLY_AUTUMN -> 1.09;
            case Season.SubSeason.MID_AUTUMN -> 1.28;
            case Season.SubSeason.LATE_AUTUMN -> 1.47;
            case Season.SubSeason.EARLY_WINTER -> 1.55;
            case Season.SubSeason.MID_WINTER -> 1.45;
            case Season.SubSeason.LATE_WINTER -> 1.26;
        };
    }

    protected double getNightSpeedForSeason(Season.SubSeason season) {
        return switch (season) {
            default -> throw new MatchException(null, null);
            case Season.SubSeason.EARLY_SPRING -> 0.92;
            case Season.SubSeason.MID_SPRING -> 1.11;
            case Season.SubSeason.LATE_SPRING -> 1.28;
            case Season.SubSeason.EARLY_SUMMER -> 1.35;
            case Season.SubSeason.MID_SUMMER -> 1.28;
            case Season.SubSeason.LATE_SUMMER -> 1.12;
            case Season.SubSeason.EARLY_AUTUMN -> 0.92;
            case Season.SubSeason.MID_AUTUMN -> 0.77;
            case Season.SubSeason.LATE_AUTUMN -> 0.6;
            case Season.SubSeason.EARLY_WINTER -> 0.54;
            case Season.SubSeason.MID_WINTER -> 0.62;
            case Season.SubSeason.LATE_WINTER -> 0.78;
        };
    }

    protected void onTick(Level level, boolean ENABLE_SEASONAL_DAYLIGHT_CYCLE, boolean CUSTOM_CYCLE_LENGTH, double CUSTOM_DAY_LENGTH, double CUSTOM_NIGHT_LENGTH) {
        if (++this.ticker >= 400) {
            Season.SubSeason currentSubSeason;
            this.ticker = 0;
            if (EnvironmentHelper.shouldRunMod() && (currentSubSeason = EnvironmentHelper.getCurrentSeason()) != this.lastSubSeason) {
                this.lastSubSeason = currentSubSeason;
                if (ENABLE_SEASONAL_DAYLIGHT_CYCLE) {
                    double daySpeed = this.getDaySpeedForSeason(currentSubSeason);
                    double nightSpeed = this.getNightSpeedForSeason(currentSubSeason);
                    ConfigHacks.setTimeSpeeds(daySpeed, nightSpeed);
                    SereneSeasonPlusCommon.LogInfo(currentSubSeason, daySpeed, nightSpeed);
                } else if (CUSTOM_CYCLE_LENGTH) {
                    ConfigHacks.setTimeSpeeds(CUSTOM_DAY_LENGTH, CUSTOM_NIGHT_LENGTH);
                    SereneSeasonPlusCommon.LogInfo(currentSubSeason, CUSTOM_DAY_LENGTH, CUSTOM_NIGHT_LENGTH);
                } else {
                    LOGGER.info(String.valueOf(currentSubSeason) + " is active, but both seasonal and custom daylight cycle are disabled.");
                }
            }
        }
    }
}

