/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.mixin;

import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.logic.SnowLogic;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.season.SeasonHooks;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Shadow
    @Final
    private ServerChunkCache chunkSource;
    @Unique
    private static final int MIN_TICKS_INTERVALLES = 10;

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    private void ssp$handleSnowAndIce(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        ServerLevel level = (ServerLevel)this;
        ProfilerFiller profiler = level.getProfiler();
        if (level.dimension() == Level.OVERWORLD && CommonSnowBlockFeature.isSnowFeatureEnabled()) {
            boolean doEval;
            int t = CommonSnowBlockFeature.getTickCounter();
            ChunkPos cpos = chunk.getPos();
            boolean bl = doEval = ((cpos.x ^ cpos.z ^ t) & 0xF) == 0;
            if (doEval) {
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                Season.SubSeason currentSeason = EnvironmentHelper.getCurrentSeason();
                ISeasonState seasonState = SeasonHelper.getSeasonState((Level)level);
                if (seasonState != null && currentSeason != null) {
                    if (tracked.sereneseasonsplus$getSurfaceHeight() == -1) {
                        int surfaceHeightCache = level.getHeight(Heightmap.Types.WORLD_SURFACE, cpos.getMiddleBlockX(), cpos.getMiddleBlockZ());
                        tracked.sereneseasonsplus$setSurfaceHeight(surfaceHeightCache);
                    }
                    int surfaceHeight = tracked.sereneseasonsplus$getSurfaceHeight();
                    SnowLogic.evaluate(level, currentSeason, seasonState, tracked, cpos, true, surfaceHeight);
                }
            }
        }
        profiler.popPush("iceandsnow");
        if (level.random.nextInt(16) == 0) {
            int j = chunk.getPos().getMinBlockX();
            int k = chunk.getPos().getMinBlockZ();
            BlockPos blockPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, level.getBlockRandomPos(j, 0, k, 15));
            BlockPos blockPos2 = blockPos.below();
            Biome biome = (Biome)level.getBiome(blockPos).value();
            if (EnvironmentHelper.isRainning(level, blockPos) && CommonSnowBlockFeature.HANDLER.isColdEnoughForSnow(level, blockPos)) {
                CommonSnowBlockFeature.tryFreezeWaterAt(level, blockPos2);
            }
            if (EnvironmentHelper.isRainning(level, blockPos) && level.canSeeSkyFromBelowWater(blockPos)) {
                Biome.Precipitation precipitation;
                int maxSnow = level.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
                if (maxSnow > 0 && SeasonHooks.shouldSnowHook((Biome)biome, (LevelReader)level, (BlockPos)blockPos)) {
                    LevelChunk lc;
                    int activeId;
                    BlockState state = level.getBlockState(blockPos);
                    boolean skipDueToDestroyed = false;
                    SnowHistorySavedData sd = SnowHistorySavedData.get();
                    int n = activeId = sd != null ? sd.currentStormId : 0;
                    if (activeId > 0 && (lc = chunk) instanceof ISnowTrackedChunk) {
                        ISnowTrackedChunk tracked = (ISnowTrackedChunk)lc;
                        if (tracked.sereneseasonsplus$getDestroyedStormId() != activeId) {
                            tracked.sereneseasonsplus$getDestroyedColumns().clear();
                            tracked.sereneseasonsplus$setDestroyedStormId(activeId);
                        }
                        long xz = (long)blockPos.getX() << 32 ^ (long)blockPos.getZ() & 0xFFFFFFFFL;
                        if (tracked.sereneseasonsplus$getDestroyedColumns().contains(xz)) {
                            skipDueToDestroyed = true;
                        }
                    }
                    if (skipDueToDestroyed) {
                        return;
                    }
                    if (state.is(Blocks.SNOW)) {
                        int layers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
                        if (layers < Math.min(maxSnow, 8)) {
                            BlockState next = (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers + 1));
                            Block.pushEntitiesUp((BlockState)state, (BlockState)next, (LevelAccessor)level, (BlockPos)blockPos);
                            if (level.setBlockAndUpdate(blockPos, next)) {
                                CommonSnowBlockFeature.accumulateColumnUpdate(blockPos, next);
                            }
                        }
                    } else {
                        BlockState snow = Blocks.SNOW.defaultBlockState();
                        if (level.setBlockAndUpdate(blockPos, snow)) {
                            CommonSnowBlockFeature.accumulateColumnUpdate(blockPos, snow);
                        }
                    }
                }
                if ((precipitation = biome.getPrecipitationAt(blockPos2)) != Biome.Precipitation.NONE) {
                    BlockState base = level.getBlockState(blockPos2);
                    base.getBlock().handlePrecipitation(base, (Level)level, blockPos2, precipitation);
                }
            }
        }
    }
}

