/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus;

import com.Gabou.sereneseasonsplus.SereneSeasonPlusCommon;
import com.Gabou.sereneseasonsplus.SereneSeasonsPlusNeoForgeClient;
import com.Gabou.sereneseasonsplus.config.SereneExtendedConfig;
import com.Gabou.sereneseasonsplus.event.SeasonChangeEvent;
import com.Gabou.sereneseasonsplus.features.CommonSnowBlockFeature;
import com.Gabou.sereneseasonsplus.features.NeoForgeSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.util.DebugCommands;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import com.Gabou.sereneseasonsplus.util.NeoForgeEnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ProjectAtmosphereRainHandler;
import com.Gabou.sereneseasonsplus.util.SereneService;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="sereneseasonsplus")
public class SereneSeasonsPlusNeoForge
extends SereneSeasonPlusCommon {
    public static boolean isProjectAtmosphereLoaded = false;

    public SereneSeasonsPlusNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        CommonSnowBlockFeature.HANDLER = new NeoForgeSnowEnvironmentHandler();
        EnvironmentHelper.init(new NeoForgeEnvironmentHelper());
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SereneExtendedConfig.COMMON_SPEC);
        if (!isProjectAtmosphereLoaded) {
            SeasonChangeEvent.register();
        }
        if (isProjectAtmosphereLoaded) {
            EnvironmentHelper.initRainHandler(new ProjectAtmosphereRainHandler());
        }
        modEventBus.addListener(event -> {
            LOGGER.info("Setting up Serene Seasons Plus (Common)");
            this.clientSetup((FMLClientSetupEvent)event, modContainer);
        });
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Serene Seasons Extended is loading!");
        ((GameRules.IntegerValue)event.getServer().getGameRules().getRule(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT)).set(((Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get()).intValue(), event.getServer());
        CommonSnowBlockFeature.onServerStarting((Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get(), (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get(), (Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        EnvironmentHelper.onServerStarted(event.getServer().getLevel(Level.OVERWORLD));
    }

    private void clientSetup(FMLClientSetupEvent event, ModContainer modContainer) {
        LOGGER.info("Setting up Serene Seasons Plus (Client)");
        SereneSeasonsPlusNeoForgeClient.init(ModLoadingContext.get());
        NeoForge.EVENT_BUS.register(SereneSeasonsPlusNeoForgeClient.class);
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        SereneService.HANDLER.shutdown();
        SereneService.HANDLER = null;
        CommonSnowBlockFeature.onServerStopping();
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide() || !event.hasTime()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        this.onTick((Level)level, (Boolean)SereneExtendedConfig.ENABLE_SEASONAL_DAYLIGHT_CYCLE.get(), (Boolean)SereneExtendedConfig.CUSTOM_CYCLE_LENGTH.get(), (Double)SereneExtendedConfig.CUSTOM_DAY_LENGTH.get(), (Double)SereneExtendedConfig.CUSTOM_NIGHT_LENGTH.get());
        CommonSnowBlockFeature.handleServerTick(level.getServer(), level);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (!(chunkAccess instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        Level level = chunk.getLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        CommonSnowBlockFeature.handleOnChunkLoad(chunk);
    }

    @SubscribeEvent
    public void onConfigReload(ServerTickEvent.Pre event) {
        CommonSnowBlockFeature.onConfigReload((Integer)SereneExtendedConfig.TICK_SNOW_REPLACER.get(), (Boolean)SereneExtendedConfig.SNOWSTORM_ENABLED.get(), (Integer)SereneExtendedConfig.MAX_SNOW_ACCUMULATION_LAYERS.get());
        SereneService.reloadConfig();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        DebugCommands.registerTo((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        int activeId;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (level.dimension() != Level.OVERWORLD) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (!state.is(Blocks.SNOW) && !state.is(Blocks.SNOW_BLOCK)) {
            return;
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        int n = activeId = sd != null ? sd.currentStormId : 0;
        if (activeId <= 0) {
            return;
        }
        LevelChunk chunk = level.getChunkSource().getChunk(pos.getX() >> 4, pos.getZ() >> 4, false);
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        if (tracked.sereneseasonsplus$getDestroyedStormId() != activeId) {
            tracked.sereneseasonsplus$getDestroyedColumns().clear();
            tracked.sereneseasonsplus$setDestroyedStormId(activeId);
        }
        long xz = (long)pos.getX() << 32 ^ (long)pos.getZ() & 0xFFFFFFFFL;
        tracked.sereneseasonsplus$getDestroyedColumns().add(xz);
        tracked.sereneseasonsplus$getSnowColumns().keySet().removeIf(p -> p.getX() == pos.getX() && p.getZ() == pos.getZ());
        chunk.setUnsaved(true);
    }
}

