/*
 * Decompiled with CFR 0.152.
 */
package com.Gabou.sereneseasonsplus.features;

import com.Gabou.sereneseasonsplus.features.DefaultSnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.features.ISnowEnvironmentHandler;
import com.Gabou.sereneseasonsplus.features.snowstorm.ISnowStormLevel;
import com.Gabou.sereneseasonsplus.storage.ChunkQueue;
import com.Gabou.sereneseasonsplus.storage.SnowHistorySavedData;
import com.Gabou.sereneseasonsplus.storage.SnowRecord;
import com.Gabou.sereneseasonsplus.tags.SSPTags;
import com.Gabou.sereneseasonsplus.util.EnvironmentHelper;
import com.Gabou.sereneseasonsplus.util.ISnowTrackedChunk;
import com.Gabou.sereneseasonsplus.util.MinecraftServerAccess;
import com.Gabou.sereneseasonsplus.util.SnowUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sereneseasons.api.season.Season;

public class CommonSnowBlockFeature {
    public static final Logger LOGGER = LogManager.getLogger((String)"SnowBlockReplacer");
    protected static final Map<ServerPlayer, BlockPos> playerPositions = new ConcurrentHashMap<ServerPlayer, BlockPos>();
    protected static int tickThresholdSnowReplacer;
    protected static int tickCounter;
    protected static boolean needUpdateSnowFeature;
    public static ISnowEnvironmentHandler HANDLER;
    protected static final int MAX_ATTEMPTS = 64;
    static final Map<BlockPos, QueuedChange> pendingChanges;
    static final Set<ChunkPos> chunksToDirty;
    static final Map<ChunkPos, Map<BlockPos, Integer>> pendingColumnMapUpdates;
    static final Map<ChunkPos, Set<BlockPos>> pendingIceAdds;
    static final List<BlockPos> snowPill;
    static int applyCycleTotal;
    static int applyCycleProcessed;
    protected static boolean snowFeatureEnabled;
    public static boolean FAST_PILING_MODE;
    public static int ACTIVE_STORM_TARGET_TICKS;
    public static float STORM_INTENSITY_MULTIPLIER;
    protected static int maxHeightForSnow;
    protected static final Queue<LevelChunk> snowQueue;

    public static boolean isSnowFeatureEnabled() {
        return snowFeatureEnabled;
    }

    public static void setFastPilingMode(boolean enabled) {
        FAST_PILING_MODE = enabled;
    }

    public static void setActiveStormTargetTicks(int ticks) {
        ACTIVE_STORM_TARGET_TICKS = Math.max(1, ticks);
    }

    public static void setStormIntensityMultiplier(float mult) {
        STORM_INTENSITY_MULTIPLIER = Math.max(0.01f, mult);
    }

    public static int getTickCounter() {
        return tickCounter;
    }

    protected static void clear() {
        playerPositions.clear();
        tickCounter = 0;
        ChunkQueue.clear();
        pendingChanges.clear();
        chunksToDirty.clear();
        pendingColumnMapUpdates.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
        pendingIceAdds.clear();
    }

    public static void handleServerTick(MinecraftServer server, ServerLevel level) {
        int phase;
        if (level == null || level.isClientSide()) {
            return;
        }
        ++tickCounter;
        if (!snowFeatureEnabled) {
            if (!ChunkQueue.isEmpty()) {
                CommonSnowBlockFeature.clear();
            }
            return;
        }
        if (needUpdateSnowFeature) {
            ((GameRules.IntegerValue)server.getGameRules().getRule(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT)).set(maxHeightForSnow, server);
        }
        if (!snowQueue.isEmpty()) {
            CommonSnowBlockFeature.chunkHandler(level);
        }
        if (level.random.nextInt(16) == 0 || EnvironmentHelper.isHotSeason() && level.random.nextInt(2) == 0) {
            CommonSnowBlockFeature.updatePlayerPositions(level.players());
            CommonSnowBlockFeature.passifSnowBlocks(level);
            EnvironmentHelper.checkAndUpdate(level);
        }
        if ((phase = tickCounter % 5) == 0 && tickCounter > 10) {
            return;
        }
        if (phase == 1) {
            ChunkQueue.Entry entry;
            int processed = 0;
            if (ChunkQueue.isEmpty()) {
                ChunkQueue.shuffle();
            }
            while ((entry = ChunkQueue.poll()) != null) {
                LevelChunk chunk;
                boolean timeUp;
                boolean bl = timeUp = ((MinecraftServerAccess)server).sereneseasonsplus$tempsEcoule() && processed >= 5 || processed >= 20;
                if (timeUp) {
                    if (entry.type() == ChunkQueue.TaskType.APPLY_SNOW) {
                        CommonSnowBlockFeature.enqueueChunkForSnowApply(entry.pos(), entry.subSeason());
                        break;
                    }
                    CommonSnowBlockFeature.enqueueChunkForSnowMelt(entry.pos(), entry.fullClear());
                    break;
                }
                boolean changed = false;
                ChunkPos chunkPos = entry.pos();
                if (!level.hasChunk(chunkPos.x, chunkPos.z) || (chunk = level.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false)) == null) continue;
                switch (entry.type()) {
                    case APPLY_SNOW: {
                        boolean synced = CommonSnowBlockFeature.syncTrackedColumnsToWorld(level, chunk);
                        if (!synced) {
                            synced = CommonSnowBlockFeature.applySnowHistoryPass(level, chunk);
                        }
                        if (!synced) {
                            synced = CommonSnowBlockFeature.applySnowPatternFromActiveRecord(level, chunk);
                        }
                        if (!synced) break;
                        chunksToDirty.add(chunkPos);
                        changed = true;
                        break;
                    }
                    case MELT_SNOW: {
                        changed = CommonSnowBlockFeature.meltSnowInChunk(level, chunkPos, entry.fullClear());
                        if (!changed) break;
                        chunksToDirty.add(chunkPos);
                    }
                }
                ++processed;
            }
        }
        if (phase == 2 || phase == 3 || phase == 4) {
            if (applyCycleProcessed == 0) {
                applyCycleTotal = pendingChanges.size();
            }
            int batch = (applyCycleTotal + 2) / 3;
            int toProcess = phase == 4 ? Integer.MAX_VALUE : batch;
            int applied = CommonSnowBlockFeature.processQueuedChanges(level, toProcess);
            applyCycleProcessed += applied;
            if (phase == 4) {
                CommonSnowBlockFeature.finalizeChunkBatch(level);
                applyCycleTotal = 0;
                applyCycleProcessed = 0;
            }
        }
    }

    public static void handleOnChunkLoad(LevelChunk chunk) {
        if (CommonSnowBlockFeature.isSnowFeatureEnabled()) {
            snowQueue.add(chunk);
        }
    }

    protected static void chunkHandler(ServerLevel level) {
        LevelChunk chunk;
        while ((chunk = snowQueue.poll()) != null) {
            boolean needAvail;
            if (!(chunk instanceof ISnowTrackedChunk)) continue;
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
            boolean needSurface = tracked.sereneseasonsplus$getSurfaceHeight() == -1;
            boolean bl = needAvail = tracked.sereneseasonsplus$getAvailableSnowColumns() == -1;
            if (!needSurface && !needAvail) continue;
            if (needSurface) {
                int centerX = chunk.getPos().getMiddleBlockX();
                int centerZ = chunk.getPos().getMiddleBlockZ();
                int surfaceHeight = level.getHeight(Heightmap.Types.WORLD_SURFACE, centerX, centerZ);
                tracked.sereneseasonsplus$setSurfaceHeight(surfaceHeight);
            }
            if (!needAvail) continue;
            int baseX = chunk.getPos().getMinBlockX();
            int baseZ = chunk.getPos().getMinBlockZ();
            int count = 0;
            for (int dx = 0; dx < 16; ++dx) {
                for (int dz = 0; dz < 16; ++dz) {
                    int x = baseX + dx;
                    int z = baseZ + dz;
                    BlockPos surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                    if (surface == null) continue;
                    ++count;
                }
            }
            tracked.sereneseasonsplus$setAvailableSnowColumns(count);
        }
    }

    public static void enqueueChunkForSnowApply(ChunkPos chunkPos, Season.SubSeason subSeason) {
        ChunkQueue.enqueueApply(chunkPos, subSeason);
    }

    public static void enqueueChunkForSnowMelt(ChunkPos chunkPos, boolean fullClear) {
        ChunkQueue.enqueueMelt(chunkPos, fullClear);
    }

    protected static void passifSnowBlocks(ServerLevel level) {
        for (Map.Entry<ServerPlayer, BlockPos> entry : playerPositions.entrySet()) {
            ServerPlayer player = entry.getKey();
            BlockPos playerPos = entry.getValue();
            int simulationDistance = CommonSnowBlockFeature.getSimulationDistance(player);
            int radius = Mth.clamp((int)(simulationDistance * 16), (int)16, (int)64);
            int blocksToReplace = HANDLER.getBlocksToReplace(level, playerPos);
            if (blocksToReplace < 0) {
                if (!EnvironmentHelper.isRainning(level, playerPos)) continue;
                RandomSource random = level.random;
                for (int attempt = 0; attempt < 64; ++attempt) {
                    int z;
                    int dx = random.nextInt(radius * 2 + 1) - radius;
                    int dz = random.nextInt(radius * 2 + 1) - radius;
                    int x = playerPos.getX() + dx;
                    BlockPos surface = CommonSnowBlockFeature.findPlacementTop(level, x, z = playerPos.getZ() + dz);
                    if (surface == null) continue;
                    BlockState st = level.getBlockState(surface);
                    BlockPos targetPos = surface;
                    int targetLayers = 1;
                    if (st.is(Blocks.SNOW)) {
                        int cur = (Integer)st.getValue((Property)SnowLayerBlock.LAYERS);
                        if (cur < 8) {
                            targetLayers = cur + 1;
                        } else {
                            BlockPos above = surface.above();
                            if (!level.isEmptyBlock(above)) continue;
                            targetPos = above;
                            targetLayers = 1;
                        }
                    } else if (st.is(Blocks.SNOW_BLOCK)) {
                        BlockPos above = surface.above();
                        if (!level.isEmptyBlock(above)) continue;
                        targetPos = above;
                        targetLayers = 1;
                    } else {
                        targetPos = surface;
                        targetLayers = 1;
                    }
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, targetPos, targetLayers, true, false)) {
                        BlockState ns = level.getBlockState(targetPos);
                        CommonSnowBlockFeature.accumulateColumnUpdate(targetPos, ns);
                    }
                    BlockPos below = new BlockPos(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z), z).below();
                    CommonSnowBlockFeature.tryFreezeWaterAt(level, below);
                }
                continue;
            }
            for (int i = 0; i < blocksToReplace; ++i) {
                BlockPos targetPos = CommonSnowBlockFeature.findSnowBlockInRadius(level, playerPos, radius);
                if (targetPos == null) continue;
                SnowUtils.breakOrDecrementLayer((Level)level, targetPos);
                BlockState ns = level.getBlockState(targetPos);
                CommonSnowBlockFeature.accumulateColumnUpdate(targetPos, ns);
            }
        }
    }

    protected static boolean syncTrackedColumnsToWorld(ServerLevel level, LevelChunk chunk) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        ChunkPos cp = chunk.getPos();
        if (pendingColumnMapUpdates.containsKey(cp) || pendingChanges.keySet().stream().anyMatch(p -> p.getX() >> 4 == cp.x && p.getZ() >> 4 == cp.z)) {
            return false;
        }
        Map<BlockPos, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
        if (columns == null) {
            return false;
        }
        Map<BlockPos, Integer> pending = pendingColumnMapUpdates.get(cp);
        if (pending != null && !pending.isEmpty()) {
            columns.putAll(pending);
        }
        if (columns.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Map.Entry<BlockPos, Integer> e : new ArrayList<Map.Entry<BlockPos, Integer>>(columns.entrySet())) {
            BlockPos pos = e.getKey();
            int wantedLayers = Mth.clamp((int)e.getValue(), (int)0, (int)8);
            if (wantedLayers <= 0) {
                changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, pos, false);
                columns.remove(pos);
                continue;
            }
            changed |= CommonSnowBlockFeature.placeOrQueueLayers(level, pos, wantedLayers, true, true);
        }
        return changed;
    }

    protected static boolean applySnowHistoryPass(ServerLevel level, LevelChunk chunk) {
        SnowRecord combined;
        SnowRecord rec;
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        int baseline = CommonSnowBlockFeature.computeGlobalMinSum(level);
        if (baseline <= 0) {
            return false;
        }
        boolean any = false;
        ChunkPos cp = chunk.getPos();
        int baseX = cp.getMinBlockX();
        int baseZ = cp.getMinBlockZ();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos topCursor = new BlockPos.MutableBlockPos();
        int minY = level.getMinBuildHeight();
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                BlockState topState;
                BlockState s;
                int remaining;
                int x = baseX + dx;
                int z = baseZ + dz;
                BlockPos surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                if (surface == null) continue;
                int current = 0;
                cursor.set(surface.getX(), surface.getY(), surface.getZ());
                BlockState at = level.getBlockState((BlockPos)cursor);
                if (!at.is(Blocks.SNOW) && !at.is(Blocks.SNOW_BLOCK)) {
                    cursor.move(0, -1, 0);
                }
                while (cursor.getY() >= minY) {
                    BlockState s2 = level.getBlockState((BlockPos)cursor);
                    if (s2.is(Blocks.SNOW)) {
                        current += ((Integer)s2.getValue((Property)BlockStateProperties.LAYERS)).intValue();
                    } else {
                        if (!s2.is(Blocks.SNOW_BLOCK)) break;
                        current += 8;
                    }
                    cursor.move(0, -1, 0);
                }
                int need = baseline - current;
                if (cap > 0) {
                    remaining = cap - current;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                topCursor.set(surface.getX(), surface.getY(), surface.getZ());
                while ((s = level.getBlockState((BlockPos)topCursor)).is(Blocks.SNOW) || s.is(Blocks.SNOW_BLOCK)) {
                    topCursor.move(0, 1, 0);
                }
                remaining = need;
                BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(topCursor.getX(), topCursor.getY(), topCursor.getZ());
                BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos(topCursor.getX(), topCursor.getY() - 1, topCursor.getZ());
                if (belowPos.getY() >= minY && ((topState = level.getBlockState((BlockPos)belowPos)).is(Blocks.SNOW) || topState.is(Blocks.SNOW_BLOCK))) {
                    int currentLayers = topState.is(Blocks.SNOW_BLOCK) ? 8 : (Integer)topState.getValue((Property)BlockStateProperties.LAYERS);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && remaining > 0) {
                        int add = Math.min(freeSpace, remaining);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)belowPos, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(belowPos.immutable(), targetLayers);
                            any = true;
                        }
                        remaining -= add;
                    }
                    if (remaining <= 0) continue;
                }
                while (remaining > 0 && placePos.getY() < level.getMaxBuildHeight()) {
                    int toPlace = Math.min(8, remaining);
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)placePos, toPlace, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(placePos.immutable(), toPlace);
                        any = true;
                    }
                    remaining -= toPlace;
                    placePos.move(0, 1, 0);
                }
            }
        }
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd != null && (sd.currentStormId > 0 ? (rec = sd.snowHistory.get(sd.currentStormId)) != null : (combined = CommonSnowBlockFeature.aggregateFinishedStormSums(level)) != null)) {
            return CommonSnowBlockFeature.applySnowPattern(level, chunk, rec, level.random) || any;
        }
        return any;
    }

    public static boolean tryFreezeWaterAt(ServerLevel level, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        if (!state.is(Blocks.WATER)) {
            return false;
        }
        BlockPos sample = pos.above();
        if (!EnvironmentHelper.isRainning(level, sample)) {
            return false;
        }
        if (!CommonSnowBlockFeature.isExposedToSky(level, sample)) {
            return false;
        }
        if (!HANDLER.isColdEnoughForSnow(level, sample)) {
            return false;
        }
        if (!CommonSnowBlockFeature.isWaterBiome(level, pos)) {
            return false;
        }
        BlockState ice = Blocks.ICE.defaultBlockState();
        if (level.setBlockAndUpdate(pos, ice)) {
            CommonSnowBlockFeature.accumulateColumnUpdate(pos, ice);
            return true;
        }
        return false;
    }

    protected static boolean isWaterBiome(ServerLevel level, BlockPos pos) {
        try {
            Holder holder = level.getBiome(pos);
            return holder.unwrapKey().map(key -> {
                ResourceLocation rl = key.location();
                String path = rl.getPath();
                return path.contains("ocean") || path.contains("river");
            }).orElse(false);
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static boolean applySnowPatternFromActiveRecord(ServerLevel level, LevelChunk chunk) {
        SnowRecord rec;
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd != null && sd.currentStormId > 0 && (rec = sd.snowHistory.get(sd.currentStormId)) != null) {
            return CommonSnowBlockFeature.applySnowPattern(level, chunk, rec, level.random);
        }
        return false;
    }

    protected static boolean applySnowPattern(ServerLevel level, LevelChunk chunk, SnowRecord record, RandomSource rng) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        ChunkPos cp = chunk.getPos();
        int baseX = cp.getMinBlockX();
        int baseZ = cp.getMinBlockZ();
        float avg = Math.max(0.0f, record.avgLayers);
        float coverage = Mth.clamp((float)(avg / 8.0f), (float)0.1f, (float)0.85f);
        boolean any = false;
        float progress = 1.0f;
        int currentTick = CommonSnowBlockFeature.getTickCounter();
        if (!FAST_PILING_MODE) {
            int activeId;
            SnowHistorySavedData sd = SnowHistorySavedData.get();
            int n = activeId = sd != null ? sd.currentStormId : 0;
            if (activeId > 0) {
                if (tracked.sereneseasonsplus$getStormIdApplied() != activeId) {
                    tracked.sereneseasonsplus$setStormIdApplied(activeId);
                    tracked.sereneseasonsplus$setStormProgress(0.0f);
                    tracked.sereneseasonsplus$setLastProgressTick(currentTick);
                }
                float cur = tracked.sereneseasonsplus$getStormProgress();
                int last = tracked.sereneseasonsplus$getLastProgressTick();
                int dt = Math.max(1, currentTick - last);
                float delta = (float)dt / (float)Math.max(1, ACTIVE_STORM_TARGET_TICKS);
                cur = Mth.clamp((float)(cur + delta * STORM_INTENSITY_MULTIPLIER), (float)0.0f, (float)1.0f);
                tracked.sereneseasonsplus$setStormProgress(cur);
                tracked.sereneseasonsplus$setLastProgressTick(currentTick);
                progress = cur;
            }
        }
        int activeId = 0;
        SnowHistorySavedData sdLocal = SnowHistorySavedData.get();
        if (sdLocal != null) {
            activeId = sdLocal.currentStormId;
        }
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int desired;
                BlockPos surface;
                double wave;
                float white;
                float noise;
                int x = baseX + dx;
                int z = baseZ + dz;
                if (activeId > 0) {
                    if (tracked.sereneseasonsplus$getDestroyedStormId() != activeId) {
                        tracked.sereneseasonsplus$getDestroyedColumns().clear();
                        tracked.sereneseasonsplus$setDestroyedStormId(activeId);
                    }
                    long xz = (long)x << 32 ^ (long)z & 0xFFFFFFFFL;
                    if (tracked.sereneseasonsplus$getDestroyedColumns().contains(xz)) continue;
                }
                if ((noise = Mth.clamp((float)((float)((double)(white = rng.nextFloat()) * 0.7 + ((wave = Math.sin((double)x * 0.12 + (double)z * 0.12)) + 1.0) * 0.15)), (float)0.0f, (float)1.0f)) > coverage || (surface = CommonSnowBlockFeature.findPlacementTop(level, x, z)) == null) continue;
                int minL = Math.max(1, Math.round(record.minLayers));
                int maxL = Math.max(minL, Math.round(record.maxLayers));
                int span = Math.max(1, maxL - minL + 1);
                int pick = minL + rng.nextInt(span);
                int towardAvg = Math.round(Mth.lerp((float)0.35f, (float)pick, (float)avg));
                int totalLayers = Math.max(1, towardAvg);
                int n = desired = FAST_PILING_MODE ? totalLayers : Math.max(0, Math.round((float)totalLayers * progress));
                if (desired <= 0) continue;
                BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(surface.getX(), surface.getY(), surface.getZ());
                int minY = level.getMinBuildHeight();
                int currentTotal = 0;
                BlockPos.MutableBlockPos down = new BlockPos.MutableBlockPos(surface.getX(), surface.getY(), surface.getZ());
                BlockState at = level.getBlockState((BlockPos)down);
                if (!at.is(Blocks.SNOW) && !at.is(Blocks.SNOW_BLOCK)) {
                    down.move(0, -1, 0);
                }
                while (down.getY() >= minY) {
                    BlockState s = level.getBlockState((BlockPos)down);
                    if (s.is(Blocks.SNOW)) {
                        currentTotal += ((Integer)s.getValue((Property)BlockStateProperties.LAYERS)).intValue();
                    } else {
                        if (!s.is(Blocks.SNOW_BLOCK)) break;
                        currentTotal += 8;
                    }
                    down.move(0, -1, 0);
                }
                int need = desired - currentTotal;
                if (cap > 0) {
                    int remaining = cap - currentTotal;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                BlockState existing = level.getBlockState((BlockPos)cursor);
                if (existing.is(Blocks.SNOW) || existing.is(Blocks.SNOW_BLOCK)) {
                    int currentLayers = existing.is(Blocks.SNOW_BLOCK) ? 8 : (Integer)existing.getValue((Property)BlockStateProperties.LAYERS);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && need > 0) {
                        int add = Math.min(freeSpace, need);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(cursor.immutable(), targetLayers);
                            any = true;
                        }
                        need -= add;
                    }
                    if (need > 0) {
                        cursor.move(0, 1, 0);
                    }
                }
                while (need >= 8 && cursor.getY() < level.getMaxBuildHeight()) {
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, 8, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(cursor.immutable(), 8);
                        any = true;
                    }
                    need -= 8;
                    cursor.move(0, 1, 0);
                }
                if (need <= 0 || cursor.getY() >= level.getMaxBuildHeight() || !CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, need, true, true)) continue;
                tracked.sereneseasonsplus$getSnowColumns().put(cursor.immutable(), need);
                any = true;
            }
        }
        return any;
    }

    protected static boolean applyCombinedFinishedPattern(ServerLevel level, LevelChunk chunk, SnowRecord combined, RandomSource rng) {
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        int cap = level.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
        if (cap > 0 && CommonSnowBlockFeature.isChunkAtOrAboveSnowCap(level, chunk, cap)) {
            return false;
        }
        ChunkPos cp = chunk.getPos();
        int baseX = cp.getMinBlockX();
        int baseZ = cp.getMinBlockZ();
        int minL = Math.max(0, Math.round(combined.minLayers));
        int avgL = Math.max(minL, Math.round(combined.avgLayers));
        int maxL = Math.max(avgL, Math.round(combined.maxLayers));
        boolean any = false;
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                BlockPos surface;
                double wave;
                int x = baseX + dx;
                int z = baseZ + dz;
                float white = rng.nextFloat();
                float noise = Mth.clamp((float)((float)((double)white * 0.7 + ((wave = Math.sin((double)x * 0.12 + (double)z * 0.12)) + 1.0) * 0.15)), (float)0.0f, (float)1.0f);
                int pick = minL + Math.round(noise * (float)Math.max(0, maxL - minL));
                int towardAvg = Math.round(Mth.lerp((float)0.35f, (float)pick, (float)avgL));
                int desired = Math.max(minL, towardAvg);
                if (desired <= 0 || (surface = CommonSnowBlockFeature.findPlacementTop(level, x, z)) == null) continue;
                int minY = level.getMinBuildHeight();
                int currentTotal = 0;
                BlockPos.MutableBlockPos down = new BlockPos.MutableBlockPos(surface.getX(), surface.getY(), surface.getZ());
                BlockState at = level.getBlockState((BlockPos)down);
                if (!at.is(Blocks.SNOW) && !at.is(Blocks.SNOW_BLOCK)) {
                    down.move(0, -1, 0);
                }
                while (down.getY() >= minY) {
                    BlockState s = level.getBlockState((BlockPos)down);
                    if (s.is(Blocks.SNOW)) {
                        currentTotal += ((Integer)s.getValue((Property)BlockStateProperties.LAYERS)).intValue();
                    } else {
                        if (!s.is(Blocks.SNOW_BLOCK)) break;
                        currentTotal += 8;
                    }
                    down.move(0, -1, 0);
                }
                int need = desired - currentTotal;
                if (cap > 0) {
                    int remaining = cap - currentTotal;
                    if (remaining <= 0) continue;
                    if (need > remaining) {
                        need = remaining;
                    }
                }
                if (need <= 0) continue;
                BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(surface.getX(), surface.getY(), surface.getZ());
                BlockState existing = level.getBlockState((BlockPos)cursor);
                if (existing.is(Blocks.SNOW) || existing.is(Blocks.SNOW_BLOCK)) {
                    int currentLayers = existing.is(Blocks.SNOW_BLOCK) ? 8 : (Integer)existing.getValue((Property)BlockStateProperties.LAYERS);
                    int freeSpace = 8 - currentLayers;
                    if (freeSpace > 0 && need > 0) {
                        int add = Math.min(freeSpace, need);
                        int targetLayers = currentLayers + add;
                        if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, targetLayers, true, true)) {
                            tracked.sereneseasonsplus$getSnowColumns().put(cursor.immutable(), targetLayers);
                            any = true;
                        }
                        need -= add;
                    }
                    if (need > 0) {
                        cursor.move(0, 1, 0);
                    }
                }
                while (need >= 8 && cursor.getY() < level.getMaxBuildHeight()) {
                    if (CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, 8, true, true)) {
                        tracked.sereneseasonsplus$getSnowColumns().put(cursor.immutable(), 8);
                        any = true;
                    }
                    need -= 8;
                    cursor.move(0, 1, 0);
                }
                if (need <= 0 || cursor.getY() >= level.getMaxBuildHeight() || !CommonSnowBlockFeature.placeOrQueueLayers(level, (BlockPos)cursor, need, true, true)) continue;
                tracked.sereneseasonsplus$getSnowColumns().put(cursor.immutable(), need);
                any = true;
            }
        }
        return any;
    }

    protected static boolean isChunkAtOrAboveSnowCap(ServerLevel level, LevelChunk chunk, int capLayers) {
        ChunkPos cp = chunk.getPos();
        int baseX = cp.getMinBlockX();
        int baseZ = cp.getMinBlockZ();
        BlockPos.MutableBlockPos down = new BlockPos.MutableBlockPos();
        int minY = level.getMinBuildHeight();
        for (int dx = 0; dx < 16; ++dx) {
            block1: for (int dz = 0; dz < 16; ++dz) {
                int x = baseX + dx;
                int z = baseZ + dz;
                BlockPos surface = CommonSnowBlockFeature.findPlacementTop(level, x, z);
                if (surface == null) continue;
                int total = 0;
                down.set(surface.getX(), surface.getY(), surface.getZ());
                BlockState at = level.getBlockState((BlockPos)down);
                if (!at.is(Blocks.SNOW) && !at.is(Blocks.SNOW_BLOCK)) {
                    down.move(0, -1, 0);
                }
                while (down.getY() >= minY) {
                    BlockState s = level.getBlockState((BlockPos)down);
                    if (s.is(Blocks.SNOW)) {
                        total += ((Integer)s.getValue((Property)BlockStateProperties.LAYERS)).intValue();
                    } else {
                        if (!s.is(Blocks.SNOW_BLOCK)) continue block1;
                        total += 8;
                    }
                    if (total >= capLayers) {
                        return true;
                    }
                    down.move(0, -1, 0);
                }
            }
        }
        return false;
    }

    public static boolean meltSnowInChunk(ServerLevel level, ChunkPos chunkPos, boolean fullClear) {
        LevelChunk chunk = level.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false);
        if (!(chunk instanceof ISnowTrackedChunk)) {
            return false;
        }
        ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
        boolean changed = false;
        Map<Object, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
        if (columns == null) {
            columns = Collections.emptyMap();
        }
        if (fullClear && !columns.isEmpty()) {
            for (BlockPos blockPos : new ArrayList<Object>(columns.keySet())) {
                changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, blockPos, false);
                columns.remove(blockPos);
            }
        }
        if (!columns.isEmpty() && !fullClear) {
            HashMap<Long, BlockPos> topByColumn = new HashMap<Long, BlockPos>();
            for (BlockPos blockPos : columns.keySet()) {
                long key = (long)blockPos.getX() << 32 ^ (long)blockPos.getZ() & 0xFFFFFFFFL;
                BlockPos cur = (BlockPos)topByColumn.get(key);
                if (cur != null && blockPos.getY() <= cur.getY()) continue;
                topByColumn.put(key, blockPos.immutable());
            }
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            block2: for (BlockPos top : topByColumn.values()) {
                BlockState state = level.getBlockState(top);
                if (state.is(Blocks.SNOW_BLOCK)) {
                    changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, top, 7, false);
                    columns.put(top.immutable(), 7);
                    continue;
                }
                if (state.is(Blocks.SNOW)) {
                    int layers = (Integer)state.getValue((Property)BlockStateProperties.LAYERS);
                    if (layers <= 1) {
                        changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, top, false);
                        columns.remove(top);
                        continue;
                    }
                    changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, top, layers - 1, false);
                    columns.put(top.immutable(), layers - 1);
                    continue;
                }
                int minY = level.getMinBuildHeight();
                mutableBlockPos.set(top.getX(), top.getY(), top.getZ());
                while (mutableBlockPos.getY() >= minY) {
                    BlockState s = level.getBlockState((BlockPos)mutableBlockPos);
                    if (s.is(Blocks.SNOW_BLOCK)) {
                        changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, mutableBlockPos.immutable(), 7, false);
                        columns.put(mutableBlockPos.immutable(), 7);
                        continue block2;
                    }
                    if (s.is(Blocks.SNOW)) {
                        int l = (Integer)s.getValue((Property)BlockStateProperties.LAYERS);
                        if (l <= 1) {
                            changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, mutableBlockPos.immutable(), false);
                            columns.remove(mutableBlockPos);
                            continue block2;
                        }
                        changed |= CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, mutableBlockPos.immutable(), l - 1, false);
                        columns.put(mutableBlockPos.immutable(), l - 1);
                        continue block2;
                    }
                    mutableBlockPos.move(0, -1, 0);
                }
            }
        }
        changed |= CommonSnowBlockFeature.clearCoveredMeltablesNearSurface(level, chunk);
        return changed |= CommonSnowBlockFeature.meltTrackedIce(level, tracked);
    }

    protected static boolean clearCoveredMeltablesNearSurface(ServerLevel level, LevelChunk chunk) {
        boolean changed = false;
        ChunkPos cp = chunk.getPos();
        int baseX = cp.getMinBlockX();
        int baseZ = cp.getMinBlockZ();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dx = 0; dx < 16; ++dx) {
            block1: for (int dz = 0; dz < 16; ++dz) {
                int x = baseX + dx;
                int z = baseZ + dz;
                int groundY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                for (int dy = 0; dy <= 6; ++dy) {
                    BlockState st;
                    pos.set(x, groundY + dy, z);
                    if (pos.getY() < level.getMinBuildHeight() || pos.getY() >= level.getMaxBuildHeight() || !(st = level.getBlockState((BlockPos)pos)).is(SSPTags.Blocks.MELTABLE) || CommonSnowBlockFeature.isExposedToSky(level, (BlockPos)pos)) continue;
                    changed |= CommonSnowBlockFeature.queueClearIfNeeded(level, pos.immutable(), false);
                    continue block1;
                }
            }
        }
        return changed;
    }

    protected static boolean meltTrackedIce(ServerLevel level, ISnowTrackedChunk tracked) {
        boolean changed = false;
        HashSet<BlockPos> copy = new HashSet<BlockPos>(tracked.sereneseasonsplus$getIceColumns());
        for (BlockPos p : copy) {
            BlockState st = level.getBlockState(p);
            if (st.is(Blocks.ICE)) {
                CommonSnowBlockFeature.queueChange(p, Blocks.WATER.defaultBlockState(), 34);
                tracked.sereneseasonsplus$getIceColumns().remove(p);
                changed = true;
                continue;
            }
            tracked.sereneseasonsplus$getIceColumns().remove(p);
        }
        return changed;
    }

    protected static BlockPos findPlacementTop(ServerLevel level, int x, int z) {
        int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        BlockPos base = new BlockPos(x, y, z);
        BlockState at = level.getBlockState(base);
        BlockState snow = Blocks.SNOW.defaultBlockState();
        if ((level.isEmptyBlock(base) || at.canBeReplaced()) && snow.canSurvive((LevelReader)level, base) && CommonSnowBlockFeature.canReceiveSnowAt(level, base)) {
            return base;
        }
        BlockPos up = base.above();
        if (snow.canSurvive((LevelReader)level, up) && level.isEmptyBlock(up) && CommonSnowBlockFeature.canReceiveSnowAt(level, up)) {
            return up;
        }
        if (at.is(Blocks.SNOW) && CommonSnowBlockFeature.canReceiveSnowAt(level, base)) {
            return base;
        }
        return null;
    }

    protected static boolean isExposedToSky(ServerLevel level, BlockPos pos) {
        if (pos.equals((Object)new BlockPos(-98, 63, -104))) {
            boolean bl = false;
        }
        try {
            return level.canSeeSkyFromBelowWater(pos);
        }
        catch (Throwable t) {
            return true;
        }
    }

    protected static boolean canReceiveSnowAt(ServerLevel level, BlockPos pos) {
        try {
            if (level.canSeeSkyFromBelowWater(pos)) {
                return true;
            }
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(pos.getX(), pos.getY() + 1, pos.getZ());
            int max = level.getMaxBuildHeight();
            while (cursor.getY() < max) {
                BlockState st = level.getBlockState((BlockPos)cursor);
                if (st.isAir()) {
                    cursor.move(0, 1, 0);
                    continue;
                }
                if (st.is(BlockTags.LEAVES)) {
                    cursor.move(0, 1, 0);
                    continue;
                }
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            return true;
        }
    }

    protected static boolean placeOrQueueLayers(ServerLevel level, BlockPos pos, int targetLayers, boolean allowPlace, boolean queue) {
        LevelChunk chunk;
        int activeId;
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        int n = activeId = sd != null ? sd.currentStormId : 0;
        if (activeId > 0 && (chunk = level.getChunkSource().getChunk(pos.getX() >> 4, pos.getZ() >> 4, false)) instanceof ISnowTrackedChunk) {
            ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
            if (tracked.sereneseasonsplus$getDestroyedStormId() != activeId) {
                tracked.sereneseasonsplus$getDestroyedColumns().clear();
                tracked.sereneseasonsplus$setDestroyedStormId(activeId);
            }
            long xz = (long)pos.getX() << 32 ^ (long)pos.getZ() & 0xFFFFFFFFL;
            if (tracked.sereneseasonsplus$getDestroyedColumns().contains(xz)) {
                return false;
            }
        }
        if (queue) {
            return CommonSnowBlockFeature.queueSnowLayersIfNeeded(level, pos, targetLayers, allowPlace);
        }
        targetLayers = Mth.clamp((int)targetLayers, (int)1, (int)8);
        BlockState state = level.getBlockState(pos);
        targetLayers = CommonSnowBlockFeature.clampLayersForColumnCap(level, pos, state, targetLayers);
        if (targetLayers <= 0) {
            return false;
        }
        if (state.is(Blocks.SNOW) && state.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            if (allowPlace && !CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            int current = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
            if (current == targetLayers) {
                return false;
            }
            BlockState newState = (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(targetLayers));
            return level.setBlock(pos, newState, 2);
        }
        if (state.is(Blocks.SNOW_BLOCK)) {
            if (allowPlace && !CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            if (targetLayers == 8) {
                return false;
            }
            BlockState newState = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(targetLayers));
            return level.setBlock(pos, newState, 2);
        }
        if (allowPlace && (level.isEmptyBlock(pos) || state.canBeReplaced())) {
            if (!CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            BlockState snow = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(targetLayers));
            if (!snow.canSurvive((LevelReader)level, pos)) {
                return false;
            }
            return level.setBlock(pos, snow, 2);
        }
        return false;
    }

    protected static boolean queueSnowLayersIfNeeded(ServerLevel level, BlockPos pos, int targetLayers, boolean allowPlace) {
        targetLayers = Mth.clamp((int)targetLayers, (int)1, (int)8);
        BlockState state = level.getBlockState(pos);
        targetLayers = CommonSnowBlockFeature.clampLayersForColumnCap(level, pos, state, targetLayers);
        if (targetLayers <= 0) {
            return false;
        }
        if (state.is(Blocks.SNOW) && state.hasProperty((Property)SnowLayerBlock.LAYERS)) {
            if (allowPlace && !CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            int current = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
            if (current == targetLayers) {
                return false;
            }
            BlockState newState = (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(targetLayers));
            CommonSnowBlockFeature.queueChange(pos, newState, 2);
            snowPill.add(pos.immutable());
            return true;
        }
        if (state.is(Blocks.SNOW_BLOCK)) {
            if (allowPlace && !CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            if (targetLayers == 8) {
                return false;
            }
            BlockState newState = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(targetLayers));
            CommonSnowBlockFeature.queueChange(pos, newState, 2);
            snowPill.add(pos.immutable());
            return true;
        }
        if (allowPlace && (level.isEmptyBlock(pos) || state.canBeReplaced())) {
            if (!CommonSnowBlockFeature.canReceiveSnowAt(level, pos)) {
                return false;
            }
            BlockState snow = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(targetLayers));
            if (!snow.canSurvive((LevelReader)level, pos)) {
                return false;
            }
            CommonSnowBlockFeature.queueChange(pos, snow, 2);
            snowPill.add(pos.immutable());
            return true;
        }
        return false;
    }

    private static int clampLayersForColumnCap(ServerLevel level, BlockPos pos, BlockState currentState, int targetLayers) {
        int delta;
        int remaining;
        int cap = level.getGameRules().getInt(GameRules.RULE_SNOW_ACCUMULATION_HEIGHT);
        if (cap <= 0) {
            return targetLayers;
        }
        int currentAtPos = 0;
        if (currentState.is(Blocks.SNOW)) {
            currentAtPos = (Integer)currentState.getValue((Property)SnowLayerBlock.LAYERS);
        } else if (currentState.is(Blocks.SNOW_BLOCK)) {
            currentAtPos = 8;
        }
        int total = currentAtPos;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos(pos.getX(), pos.getY() - 1, pos.getZ());
        int minY = level.getMinBuildHeight();
        while (cursor.getY() >= minY) {
            BlockState s = level.getBlockState((BlockPos)cursor);
            if (s.is(Blocks.SNOW)) {
                total += ((Integer)s.getValue((Property)SnowLayerBlock.LAYERS)).intValue();
            } else {
                if (!s.is(Blocks.SNOW_BLOCK)) break;
                total += 8;
            }
            cursor.move(0, -1, 0);
        }
        cursor.set(pos.getX(), pos.getY() + 1, pos.getZ());
        int maxY = level.getMaxBuildHeight();
        while (cursor.getY() < maxY) {
            BlockState s = level.getBlockState((BlockPos)cursor);
            if (s.is(Blocks.SNOW)) {
                total += ((Integer)s.getValue((Property)SnowLayerBlock.LAYERS)).intValue();
            } else {
                if (!s.is(Blocks.SNOW_BLOCK)) break;
                total += 8;
            }
            cursor.move(0, 1, 0);
        }
        if ((remaining = cap - (total - currentAtPos)) <= 0) {
            return Math.min(targetLayers, currentAtPos);
        }
        if (targetLayers > currentAtPos && (delta = targetLayers - currentAtPos) > remaining) {
            targetLayers = currentAtPos + remaining;
        }
        return Mth.clamp((int)targetLayers, (int)1, (int)8);
    }

    protected static BlockPos findSnowBlockInRadius(ServerLevel level, BlockPos center, int radius) {
        ServerChunkCache chunkSource = level.getChunkSource();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int chunkZ;
                int chunkX = center.getX() + x >> 4;
                LevelChunk chunk = chunkSource.getChunk(chunkX, chunkZ = center.getZ() + z >> 4, false);
                if (chunk == null) continue;
                for (int y = -5; y <= 5; ++y) {
                    pos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                    if (pos.getY() < level.getMinBuildHeight() || pos.getY() >= level.getMaxBuildHeight() || !chunk.getBlockState((BlockPos)pos).is(SSPTags.Blocks.MELTABLE)) continue;
                    return pos.immutable();
                }
            }
        }
        return null;
    }

    protected static boolean queueClearIfNeeded(ServerLevel level, BlockPos pos, boolean toWater) {
        BlockState wanted = toWater ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
        BlockState current = level.getBlockState(pos);
        if (current.is(wanted.getBlock())) {
            return false;
        }
        CommonSnowBlockFeature.queueChange(pos, wanted, 34);
        return true;
    }

    protected static void queueChange(BlockPos pos, BlockState state, int flags) {
        BlockPos imm = pos.immutable();
        pendingChanges.put(imm, new QueuedChange(imm, state, flags));
    }

    public static void accumulateColumnUpdate(BlockPos pos, BlockState state) {
        ChunkPos cp = new ChunkPos(pos.getX() >> 4, pos.getZ() >> 4);
        if (state.is(Blocks.ICE)) {
            pendingIceAdds.computeIfAbsent(cp, k -> new HashSet()).add(pos.immutable());
            chunksToDirty.add(cp);
            return;
        }
        int val = state.is(Blocks.SNOW) && state.hasProperty((Property)SnowLayerBlock.LAYERS) ? (Integer)state.getValue((Property)SnowLayerBlock.LAYERS) : (state.is(Blocks.SNOW_BLOCK) ? 8 : 0);
        pendingColumnMapUpdates.computeIfAbsent(cp, k -> new HashMap()).put(pos.immutable(), val);
        chunksToDirty.add(cp);
    }

    protected static int processQueuedChanges(ServerLevel level, int limit) {
        int applied;
        if (pendingChanges.isEmpty()) {
            return 0;
        }
        Iterator<Map.Entry<BlockPos, QueuedChange>> it = pendingChanges.entrySet().iterator();
        for (applied = 0; it.hasNext() && applied < limit; ++applied) {
            Map.Entry<BlockPos, QueuedChange> e = it.next();
            QueuedChange qc = e.getValue();
            boolean changed = level.setBlock(qc.pos(), qc.state(), qc.flags());
            if (changed) {
                CommonSnowBlockFeature.accumulateColumnUpdate(qc.pos(), qc.state());
            }
            it.remove();
        }
        return applied;
    }

    protected static void finalizeChunkBatch(ServerLevel level) {
        ChunkPos cp;
        if (!pendingColumnMapUpdates.isEmpty()) {
            for (Map.Entry<ChunkPos, Object> entry : pendingColumnMapUpdates.entrySet()) {
                LevelChunk chunk;
                cp = entry.getKey();
                Map updates = (Map)entry.getValue();
                if (!level.hasChunk(cp.x, cp.z) || !((chunk = level.getChunkSource().getChunk(cp.x, cp.z, false)) instanceof ISnowTrackedChunk)) continue;
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                Map<BlockPos, Integer> columns = tracked.sereneseasonsplus$getSnowColumns();
                for (Map.Entry up : updates.entrySet()) {
                    int val = (Integer)up.getValue();
                    if (val <= 0) {
                        columns.remove(up.getKey());
                        continue;
                    }
                    columns.put(((BlockPos)up.getKey()).immutable(), Mth.clamp((int)val, (int)1, (int)8));
                }
            }
            pendingColumnMapUpdates.clear();
        }
        if (!pendingIceAdds.isEmpty()) {
            for (Map.Entry<ChunkPos, Object> entry : pendingIceAdds.entrySet()) {
                LevelChunk chunk;
                cp = entry.getKey();
                if (!level.hasChunk(cp.x, cp.z) || !((chunk = level.getChunkSource().getChunk(cp.x, cp.z, false)) instanceof ISnowTrackedChunk)) continue;
                ISnowTrackedChunk tracked = (ISnowTrackedChunk)chunk;
                Set<BlockPos> set = tracked.sereneseasonsplus$getIceColumns();
                for (BlockPos p : (Set)entry.getValue()) {
                    if (!level.getBlockState(p).is(Blocks.ICE)) continue;
                    set.add(p.immutable());
                }
            }
            pendingIceAdds.clear();
        }
        for (ChunkPos chunkPos : chunksToDirty) {
            LevelChunk chunk;
            if (!level.hasChunk(chunkPos.x, chunkPos.z) || (chunk = level.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false)) == null) continue;
            chunk.setUnsaved(true);
        }
        chunksToDirty.clear();
        pendingChanges.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
    }

    protected static void updatePlayerPositions(Iterable<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            playerPositions.put(player, player.blockPosition());
        }
    }

    protected static int getSimulationDistance(ServerPlayer player) {
        MinecraftServer server = player.getServer();
        return server != null ? server.getPlayerList().getViewDistance() : 10;
    }

    public static int computeGlobalAvg(ServerLevel level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.snowHistory.isEmpty()) {
            return 0;
        }
        int excludeId = sd.currentStormId;
        float total = 0.0f;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord rec = e.getValue();
            total += Math.max(0.0f, rec.avgLayers);
        }
        return Math.round(total);
    }

    public static int computeGlobalMinSum(ServerLevel level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.snowHistory.isEmpty()) {
            return 0;
        }
        int excludeId = sd.currentStormId;
        float sumMin = 0.0f;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord rec = e.getValue();
            sumMin += Math.max(0.0f, rec.minLayers);
        }
        return Math.max(0, Math.round(sumMin));
    }

    protected static SnowRecord aggregateFinishedStormSums(ServerLevel level) {
        SnowHistorySavedData sd = SnowHistorySavedData.get();
        if (sd == null || sd.snowHistory.isEmpty()) {
            return null;
        }
        int excludeId = sd.currentStormId;
        float sumMin = 0.0f;
        float sumAvg = 0.0f;
        float sumMax = 0.0f;
        int count = 0;
        for (Map.Entry<Integer, SnowRecord> e : sd.snowHistory.entrySet()) {
            if (excludeId > 0 && e.getKey() == excludeId) continue;
            SnowRecord r = e.getValue();
            sumMin += Math.max(0.0f, r.minLayers);
            sumAvg += Math.max(0.0f, r.avgLayers);
            sumMax += Math.max(0.0f, r.maxLayers);
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return new SnowRecord(sumMin, sumAvg, sumMax, null);
    }

    public static void onServerStarting(int config, boolean snowStorm, int snowHeight) {
        tickThresholdSnowReplacer = config;
        snowFeatureEnabled = snowStorm;
        maxHeightForSnow = snowHeight;
        tickCounter = 0;
        playerPositions.clear();
        ChunkQueue.clear();
        pendingColumnMapUpdates.clear();
        pendingChanges.clear();
        pendingIceAdds.clear();
        chunksToDirty.clear();
        snowPill.clear();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
    }

    public static void onServerStopping() {
        CommonSnowBlockFeature.clear();
    }

    public static void onConfigReload(int config, boolean snowStorm, int snowHeight) {
        if (snowHeight != maxHeightForSnow) {
            maxHeightForSnow = snowHeight;
            needUpdateSnowFeature = true;
        }
        tickThresholdSnowReplacer = config;
        snowFeatureEnabled = snowStorm;
    }

    public static void onSeasonChange(ServerLevel level) {
        ChunkQueue.clear();
    }

    protected static int calculateBlocksToReplace1(float temperature) {
        return (int)Math.ceil(temperature / 5.0f);
    }

    protected static int calculateBlocksToReplace(float temperature) {
        if (temperature < 0.2f) {
            return 1;
        }
        return temperature < 0.5f ? 3 : 25;
    }

    public static boolean isSnowStormAt(ServerLevel level, ChunkPos pos) {
        if (level instanceof ISnowStormLevel) {
            ISnowStormLevel stormLevel = (ISnowStormLevel)level;
            return stormLevel.sereneseasonsplus$isSnowStormAt(pos);
        }
        return false;
    }

    public static int getSnowStormIntensity(ServerLevel level, ChunkPos pos) {
        if (level instanceof ISnowStormLevel) {
            ISnowStormLevel stormLevel = (ISnowStormLevel)level;
            return stormLevel.sereneseasonsplus$getSnowStormIntensity(pos);
        }
        return 0;
    }

    static {
        tickCounter = 0;
        needUpdateSnowFeature = false;
        HANDLER = new DefaultSnowEnvironmentHandler();
        pendingChanges = new LinkedHashMap<BlockPos, QueuedChange>();
        chunksToDirty = new HashSet<ChunkPos>();
        pendingColumnMapUpdates = new HashMap<ChunkPos, Map<BlockPos, Integer>>();
        pendingIceAdds = new HashMap<ChunkPos, Set<BlockPos>>();
        snowPill = new ArrayList<BlockPos>();
        applyCycleTotal = 0;
        applyCycleProcessed = 0;
        snowFeatureEnabled = false;
        FAST_PILING_MODE = false;
        ACTIVE_STORM_TARGET_TICKS = 8000;
        STORM_INTENSITY_MULTIPLIER = 1.0f;
        snowQueue = new ConcurrentLinkedQueue<LevelChunk>();
    }

    public record QueuedChange(BlockPos pos, BlockState state, int flags) {
    }
}

